/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream;

import com.sun.xml.stream.Entity;
import com.sun.xml.stream.PropertyManager;
import com.sun.xml.stream.XMLBufferListener;
import com.sun.xml.stream.XMLEntityManager;
import com.sun.xml.stream.XMLEntityReader;
import com.sun.xml.stream.XMLErrorReporter;
import com.sun.xml.stream.xerces.impl.io.ASCIIReader;
import com.sun.xml.stream.xerces.impl.io.UCSReader;
import com.sun.xml.stream.xerces.impl.io.UTF8Reader;
import com.sun.xml.stream.xerces.util.EncodingMap;
import com.sun.xml.stream.xerces.util.SymbolTable;
import com.sun.xml.stream.xerces.util.XMLChar;
import com.sun.xml.stream.xerces.util.XMLStringBuffer;
import com.sun.xml.stream.xerces.xni.QName;
import com.sun.xml.stream.xerces.xni.XMLString;
import com.sun.xml.stream.xerces.xni.parser.XMLComponentManager;
import com.sun.xml.stream.xerces.xni.parser.XMLConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import java.util.Vector;

public class XMLEntityReaderImpl
extends XMLEntityReader {
    protected Entity.ScannedEntity fCurrentEntity = null;
    protected XMLEntityManager fEntityManager;
    private static final boolean DEBUG_ENCODINGS = false;
    private Vector listeners = new Vector();
    public static final boolean[] validContent;
    public static final boolean[] validNames;
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_SKIP_STRING = false;
    protected SymbolTable fSymbolTable = null;
    protected XMLErrorReporter fErrorReporter = null;
    int[] whiteSpaceLookup = new int[100];
    int whiteSpaceLen = 0;
    boolean whiteSpaceInfoNeeded = true;
    char[] scannedName = null;
    protected boolean fAllowJavaEncodings;
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected PropertyManager fPropertyManager = null;
    boolean isExternal = false;

    public XMLEntityReaderImpl(XMLEntityManager entityManager) {
        this.fEntityManager = entityManager;
    }

    public XMLEntityReaderImpl(PropertyManager propertyManager, XMLEntityManager entityManager) {
        this.fEntityManager = entityManager;
        this.reset(propertyManager);
    }

    public void reset(PropertyManager propertyManager) {
        this.fSymbolTable = (SymbolTable)propertyManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)propertyManager.getProperty(ERROR_REPORTER);
        this.fCurrentEntity = null;
        this.whiteSpaceLen = 0;
        this.whiteSpaceInfoNeeded = true;
        this.scannedName = null;
        this.listeners.clear();
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        try {
            this.fAllowJavaEncodings = componentManager.getFeature(ALLOW_JAVA_ENCODINGS);
        }
        catch (XMLConfigurationException e) {
            this.fAllowJavaEncodings = false;
        }
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
    }

    public void setCurrentEntity(Entity.ScannedEntity scannedEntity) {
        this.fCurrentEntity = scannedEntity;
        if (this.fCurrentEntity != null) {
            this.isExternal = this.fCurrentEntity.isExternal();
        }
    }

    public Entity.ScannedEntity getCurrentEntity() {
        return this.fCurrentEntity;
    }

    public String getBaseSystemId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getExpandedSystemId() : null;
    }

    public int getLineNumber() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.lineNumber : -1;
    }

    public int getColumnNumber() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.columnNumber : -1;
    }

    public int getCharacterOffset() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.fTotalCountTillLastLoad + this.fCurrentEntity.position : -1;
    }

    public String getExpandedSystemId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getExpandedSystemId() : null;
    }

    public String getLiteralSystemId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getLiteralSystemId() : null;
    }

    public String getPublicId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getPublicId() : null;
    }

    public void setVersion(String version) {
        this.fCurrentEntity.version = version;
    }

    public String getVersion() {
        return this.fCurrentEntity.version;
    }

    public String getEncoding() {
        return this.fCurrentEntity.encoding;
    }

    public void setEncoding(String encoding) throws IOException {
        if (!(this.fCurrentEntity.stream == null || this.fCurrentEntity.encoding != null && this.fCurrentEntity.encoding.equals(encoding))) {
            if (this.fCurrentEntity.encoding != null && this.fCurrentEntity.encoding.startsWith("UTF-16")) {
                String ENCODING = encoding.toUpperCase(Locale.ENGLISH);
                if (ENCODING.equals("UTF-16")) {
                    return;
                }
                if (ENCODING.equals("ISO-10646-UCS-4")) {
                    this.fCurrentEntity.reader = this.fCurrentEntity.encoding.equals("UTF-16BE") ? new UCSReader(this.fCurrentEntity.stream, 8) : new UCSReader(this.fCurrentEntity.stream, 4);
                    return;
                }
                if (ENCODING.equals("ISO-10646-UCS-2")) {
                    this.fCurrentEntity.reader = this.fCurrentEntity.encoding.equals("UTF-16BE") ? new UCSReader(this.fCurrentEntity.stream, 2) : new UCSReader(this.fCurrentEntity.stream, 1);
                    return;
                }
            }
            this.fCurrentEntity.reader = this.createReader(this.fCurrentEntity.stream, encoding, null);
            this.fCurrentEntity.encoding = encoding;
        }
    }

    public boolean isExternal() {
        return this.fCurrentEntity.isExternal();
    }

    public int getChar(int relative) throws IOException {
        if (this.arrangeCapacity(relative + 1, false)) {
            return this.fCurrentEntity.ch[this.fCurrentEntity.position + relative];
        }
        return -1;
    }

    public int peekChar() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        int c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
        if (this.isExternal) {
            return c != 13 ? c : 10;
        }
        return c;
    }

    public int scanChar() throws IOException {
        int c;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 10 || c == 13 && this.isExternal) {
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = (char)c;
                this.load(1, false);
            }
            if (c == 13 && this.isExternal) {
                if (this.fCurrentEntity.ch[this.fCurrentEntity.position++] != '\n') {
                    --this.fCurrentEntity.position;
                }
                c = 10;
            }
        }
        ++this.fCurrentEntity.columnNumber;
        return c;
    }

    public String scanNmtoken() throws IOException {
        int length;
        char c;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        int offset = this.fCurrentEntity.position;
        boolean vc = false;
        while (vc = (c = this.fCurrentEntity.ch[this.fCurrentEntity.position]) < '\u007f' ? validNames[c] : XMLChar.isName(c)) {
            if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
            length = this.fCurrentEntity.position - offset;
            this.invokeListeners(length);
            if (length == this.fCurrentEntity.fBufferSize) {
                char[] tmp = new char[this.fCurrentEntity.fBufferSize * 2];
                System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                this.fCurrentEntity.ch = tmp;
                this.fCurrentEntity.fBufferSize *= 2;
            } else {
                System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
            }
            offset = 0;
            if (!this.load(length, false)) continue;
            break;
        }
        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length;
        String symbol = null;
        if (length > 0) {
            symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, length);
        }
        return symbol;
    }

    public String scanName() throws IOException {
        int offset;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        if (XMLChar.isNameStart(this.fCurrentEntity.ch[offset = this.fCurrentEntity.position++])) {
            char c;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[offset];
                offset = 0;
                if (this.load(1, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    this.scannedName = this.fSymbolTable.getCharArray();
                    return symbol;
                }
            }
            boolean vc = false;
            while (vc = (c = this.fCurrentEntity.ch[this.fCurrentEntity.position]) < '\u007f' ? validNames[c] : XMLChar.isName(c)) {
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                int length = this.fCurrentEntity.position - offset;
                this.invokeListeners(length);
                if (length == this.fCurrentEntity.fBufferSize) {
                    char[] tmp = new char[this.fCurrentEntity.fBufferSize * 2];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                    this.fCurrentEntity.fBufferSize *= 2;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                offset = 0;
                if (!this.load(length, false)) continue;
                break;
            }
        }
        int length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length;
        String symbol = null;
        if (length > 0) {
            symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, length);
            this.scannedName = this.fSymbolTable.getCharArray();
        }
        return symbol;
    }

    public boolean scanQName(QName qname) throws IOException {
        int offset;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        if (XMLChar.isNameStart(this.fCurrentEntity.ch[offset = this.fCurrentEntity.position++])) {
            char c;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[offset];
                offset = 0;
                if (this.load(1, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String name = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    qname.setValues(null, name, name, null);
                    qname.characters = this.fSymbolTable.getCharArray();
                    return true;
                }
            }
            int index = -1;
            boolean vc = false;
            while (vc = (c = this.fCurrentEntity.ch[this.fCurrentEntity.position]) < '\u007f' ? validNames[c] : XMLChar.isName(c)) {
                if (c == ':') {
                    if (index != -1) break;
                    index = this.fCurrentEntity.position;
                }
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                int length = this.fCurrentEntity.position - offset;
                this.invokeListeners(length);
                if (length == this.fCurrentEntity.fBufferSize) {
                    char[] tmp = new char[this.fCurrentEntity.fBufferSize * 2];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                    this.fCurrentEntity.fBufferSize *= 2;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                if (index != -1) {
                    index -= offset;
                }
                offset = 0;
                if (!this.load(length, false)) continue;
                break;
            }
            int length = this.fCurrentEntity.position - offset;
            this.fCurrentEntity.columnNumber += length;
            if (length > 0) {
                String prefix = null;
                String localpart = null;
                String rawname = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, length);
                qname.characters = this.fSymbolTable.getCharArray();
                if (index != -1) {
                    int prefixLength = index - offset;
                    prefix = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, prefixLength);
                    int len = length - prefixLength - 1;
                    localpart = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, index + 1, len);
                } else {
                    localpart = rawname;
                }
                qname.setValues(prefix, localpart, rawname, null);
                return true;
            }
        }
        return false;
    }

    public int scanContent(XMLString content) throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.invokeListeners(0);
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false);
            this.fCurrentEntity.position = 0;
        }
        int offset = this.fCurrentEntity.position;
        int c = this.fCurrentEntity.ch[offset];
        int newlines = 0;
        if (c == 10 || c == 13 && this.isExternal) {
            do {
                if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && this.isExternal) {
                    ++newlines;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        offset = 0;
                        this.invokeListeners(newlines);
                        this.fCurrentEntity.position = newlines;
                        if (this.load(newlines, false)) break;
                    }
                    if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                        ++this.fCurrentEntity.position;
                        ++offset;
                        continue;
                    }
                    ++newlines;
                    continue;
                }
                if (c == 10) {
                    ++newlines;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    offset = 0;
                    this.invokeListeners(newlines);
                    this.fCurrentEntity.position = newlines;
                    if (!this.load(newlines, false)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            for (int i = offset; i < this.fCurrentEntity.position; ++i) {
                this.fCurrentEntity.ch[i] = 10;
            }
            int length = this.fCurrentEntity.position - offset;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                content.setValues(this.fCurrentEntity.ch, offset, length);
                return -1;
            }
        }
        boolean vc = false;
        while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
            if (vc = (c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) < 127 ? validContent[c] : XMLChar.isContent(c)) continue;
            --this.fCurrentEntity.position;
            break;
        }
        int length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length - newlines;
        content.setValues(this.fCurrentEntity.ch, offset, length);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (c == 13 && this.isExternal) {
                c = 10;
            }
        } else {
            c = -1;
        }
        return c;
    }

    public int scanLiteral(int quote, XMLString content) throws IOException {
        int length;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.invokeListeners(0);
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false);
            this.fCurrentEntity.position = 0;
        }
        int offset = this.fCurrentEntity.position;
        int c = this.fCurrentEntity.ch[offset];
        int newlines = 0;
        if (this.whiteSpaceInfoNeeded) {
            this.whiteSpaceLen = 0;
        }
        if (c == 10 || c == 13 && this.isExternal) {
            do {
                if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && this.isExternal) {
                    ++newlines;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        this.invokeListeners(newlines);
                        offset = 0;
                        this.fCurrentEntity.position = newlines;
                        if (this.load(newlines, false)) break;
                    }
                    if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                        ++this.fCurrentEntity.position;
                        ++offset;
                        continue;
                    }
                    ++newlines;
                    continue;
                }
                if (c == 10) {
                    ++newlines;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    offset = 0;
                    this.invokeListeners(newlines);
                    this.fCurrentEntity.position = newlines;
                    if (!this.load(newlines, false)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            int i = 0;
            i = offset;
            while (i < this.fCurrentEntity.position) {
                this.fCurrentEntity.ch[i] = 10;
                this.whiteSpaceLookup[this.whiteSpaceLen++] = i++;
            }
            length = this.fCurrentEntity.position - offset;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                content.setValues(this.fCurrentEntity.ch, offset, length);
                return -1;
            }
        }
        boolean vc = true;
        while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
            if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == quote && (!this.fCurrentEntity.literal || this.isExternal) || c == 37) {
                --this.fCurrentEntity.position;
                break;
            }
            vc = c < 127 ? validContent[c] : XMLChar.isContent(c);
            if (!vc) {
                --this.fCurrentEntity.position;
                break;
            }
            if (!this.whiteSpaceInfoNeeded || c != 32 && c != 9) continue;
            if (this.whiteSpaceLen < this.whiteSpaceLookup.length) {
                this.whiteSpaceLookup[this.whiteSpaceLen++] = this.fCurrentEntity.position - 1;
                continue;
            }
            int[] tmp = new int[this.whiteSpaceLookup.length + 20];
            System.arraycopy(this.whiteSpaceLookup, 0, tmp, 0, this.whiteSpaceLookup.length);
            this.whiteSpaceLookup = tmp;
            this.whiteSpaceLookup[this.whiteSpaceLen++] = this.fCurrentEntity.position - 1;
        }
        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length - newlines;
        content.setValues(this.fCurrentEntity.ch, offset, length);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (c == quote && this.fCurrentEntity.literal) {
                c = -1;
            }
        } else {
            c = -1;
        }
        return c;
    }

    public boolean scanData(String delimiter, XMLStringBuffer buffer) throws IOException {
        boolean done = false;
        int delimLen = delimiter.length();
        char charAt0 = delimiter.charAt(0);
        do {
            int length;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(0);
                this.load(0, true);
            } else if (this.fCurrentEntity.position >= this.fCurrentEntity.count - delimLen) {
                this.invokeListeners(this.fCurrentEntity.count - this.fCurrentEntity.position);
                System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.position, this.fCurrentEntity.ch, 0, this.fCurrentEntity.count - this.fCurrentEntity.position);
                this.load(this.fCurrentEntity.count - this.fCurrentEntity.position, false);
                this.fCurrentEntity.position = 0;
            }
            if (this.fCurrentEntity.position >= this.fCurrentEntity.count - delimLen) {
                this.invokeListeners(0);
                int length2 = this.fCurrentEntity.count - this.fCurrentEntity.position;
                buffer.append(this.fCurrentEntity.ch, this.fCurrentEntity.position, length2);
                this.fCurrentEntity.columnNumber += this.fCurrentEntity.count;
                this.fCurrentEntity.position = this.fCurrentEntity.count;
                this.load(0, true);
                return false;
            }
            int offset = this.fCurrentEntity.position;
            char c = this.fCurrentEntity.ch[offset];
            int newlines = 0;
            if (c == '\n' || c == '\r' && this.isExternal) {
                do {
                    if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == '\r' && this.isExternal) {
                        ++newlines;
                        ++this.fCurrentEntity.lineNumber;
                        this.fCurrentEntity.columnNumber = 1;
                        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                            offset = 0;
                            this.invokeListeners(newlines);
                            this.fCurrentEntity.position = newlines;
                            if (this.load(newlines, false)) break;
                        }
                        if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                            ++this.fCurrentEntity.position;
                            ++offset;
                            continue;
                        }
                        ++newlines;
                        continue;
                    }
                    if (c == '\n') {
                        ++newlines;
                        ++this.fCurrentEntity.lineNumber;
                        this.fCurrentEntity.columnNumber = 1;
                        if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                        offset = 0;
                        this.invokeListeners(newlines);
                        this.fCurrentEntity.position = newlines;
                        this.fCurrentEntity.count = newlines;
                        if (!this.load(newlines, false)) continue;
                        break;
                    }
                    --this.fCurrentEntity.position;
                    break;
                } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
                for (int i = offset; i < this.fCurrentEntity.position; ++i) {
                    this.fCurrentEntity.ch[i] = 10;
                }
                length = this.fCurrentEntity.position - offset;
                if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                    buffer.append(this.fCurrentEntity.ch, offset, length);
                    return true;
                }
            }
            block3: while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
                if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == charAt0) {
                    int delimOffset = this.fCurrentEntity.position - 1;
                    for (int i = 1; i < delimLen; ++i) {
                        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                            this.fCurrentEntity.position -= i;
                            break block3;
                        }
                        c = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
                        if (delimiter.charAt(i) == c) continue;
                        this.fCurrentEntity.position -= i;
                        break;
                    }
                    if (this.fCurrentEntity.position != delimOffset + delimLen) continue;
                    done = true;
                    break;
                }
                if (c == '\n' || this.isExternal && c == '\r') {
                    --this.fCurrentEntity.position;
                    break;
                }
                if (!XMLChar.isInvalid(c)) continue;
                --this.fCurrentEntity.position;
                length = this.fCurrentEntity.position - offset;
                this.fCurrentEntity.columnNumber += length - newlines;
                buffer.append(this.fCurrentEntity.ch, offset, length);
                return true;
            }
            length = this.fCurrentEntity.position - offset;
            this.fCurrentEntity.columnNumber += length - newlines;
            if (done) {
                length -= delimLen;
            }
            buffer.append(this.fCurrentEntity.ch, offset, length);
        } while (!done);
        return !done;
    }

    public boolean skipChar(int c) throws IOException {
        char cc;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        if ((cc = this.fCurrentEntity.ch[this.fCurrentEntity.position]) == c) {
            ++this.fCurrentEntity.position;
            if (c == 10) {
                ++this.fCurrentEntity.lineNumber;
                this.fCurrentEntity.columnNumber = 1;
            } else {
                ++this.fCurrentEntity.columnNumber;
            }
            return true;
        }
        if (c == 10 && cc == '\r' && this.isExternal) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = cc;
                this.load(1, false);
            }
            ++this.fCurrentEntity.position;
            if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                ++this.fCurrentEntity.position;
            }
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            return true;
        }
        return false;
    }

    public boolean isSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r';
    }

    public boolean skipSpaces() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        if (this.fCurrentEntity == null) {
            return false;
        }
        char c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
        if (XMLChar.isSpace(c)) {
            do {
                boolean entityChanged = false;
                if (c == '\n' || this.isExternal && c == '\r') {
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                        this.invokeListeners(0);
                        this.fCurrentEntity.ch[0] = c;
                        entityChanged = this.load(1, true);
                        if (!entityChanged) {
                            this.fCurrentEntity.position = 0;
                        } else if (this.fCurrentEntity == null) {
                            return true;
                        }
                    }
                    if (c == '\r' && this.isExternal && this.fCurrentEntity.ch[++this.fCurrentEntity.position] != '\n') {
                        --this.fCurrentEntity.position;
                    }
                } else {
                    ++this.fCurrentEntity.columnNumber;
                }
                if (!entityChanged) {
                    ++this.fCurrentEntity.position;
                }
                if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                this.invokeListeners(0);
                this.load(0, true);
                if (this.fCurrentEntity != null) continue;
                return true;
            } while (XMLChar.isSpace(c = this.fCurrentEntity.ch[this.fCurrentEntity.position]));
            return true;
        }
        return false;
    }

    public boolean arrangeCapacity(int length) throws IOException {
        return this.arrangeCapacity(length, false);
    }

    public boolean arrangeCapacity(int length, boolean changeEntity) throws IOException {
        if (this.fCurrentEntity.count - this.fCurrentEntity.position >= length) {
            return true;
        }
        boolean entityChanged = false;
        while (this.fCurrentEntity.count - this.fCurrentEntity.position < length) {
            if (this.fCurrentEntity.ch.length - this.fCurrentEntity.position < length) {
                this.invokeListeners(0);
                System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.position, this.fCurrentEntity.ch, 0, this.fCurrentEntity.count - this.fCurrentEntity.position);
                this.fCurrentEntity.count -= this.fCurrentEntity.position;
                this.fCurrentEntity.position = 0;
            }
            if (this.fCurrentEntity.count - this.fCurrentEntity.position >= length) continue;
            int pos = this.fCurrentEntity.position;
            this.invokeListeners(pos);
            entityChanged = this.load(this.fCurrentEntity.count, changeEntity);
            this.fCurrentEntity.position = pos;
            if (!entityChanged) continue;
            break;
        }
        return this.fCurrentEntity.count - this.fCurrentEntity.position >= length;
    }

    public boolean skipString(String s) throws IOException {
        int length = s.length();
        if (this.arrangeCapacity(length, false)) {
            int beforeSkip = this.fCurrentEntity.position;
            int afterSkip = this.fCurrentEntity.position + length - 1;
            int i = length - 1;
            while (s.charAt(i--) == this.fCurrentEntity.ch[afterSkip]) {
                if (afterSkip-- != beforeSkip) continue;
                this.fCurrentEntity.position += length;
                this.fCurrentEntity.columnNumber += length;
                return true;
            }
        }
        return false;
    }

    public boolean skipString(char[] s) throws IOException {
        int length = s.length;
        if (this.arrangeCapacity(length, false)) {
            int beforeSkip = this.fCurrentEntity.position;
            int afterSkip = this.fCurrentEntity.position + length;
            for (int i = 0; i < length; ++i) {
                if (this.fCurrentEntity.ch[beforeSkip++] == s[i]) continue;
                return false;
            }
            this.fCurrentEntity.position += length;
            this.fCurrentEntity.columnNumber += length;
            return true;
        }
        return false;
    }

    final boolean load(int offset, boolean changeEntity) throws IOException {
        this.fCurrentEntity.fTotalCountTillLastLoad += this.fCurrentEntity.fLastCount;
        int length = this.fCurrentEntity.mayReadChunks ? this.fCurrentEntity.ch.length - offset : 64;
        int count = this.fCurrentEntity.reader.read(this.fCurrentEntity.ch, offset, length);
        boolean entityChanged = false;
        if (count != -1) {
            if (count != 0) {
                this.fCurrentEntity.fLastCount = count;
                this.fCurrentEntity.count = count + offset;
                this.fCurrentEntity.position = offset;
            }
        } else {
            this.fCurrentEntity.count = offset;
            this.fCurrentEntity.position = offset;
            entityChanged = true;
            if (changeEntity) {
                this.fEntityManager.endEntity();
                if (this.fCurrentEntity == null) {
                    return true;
                }
                if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                    this.load(0, true);
                }
            }
        }
        return entityChanged;
    }

    protected Reader createReader(InputStream inputStream, String encoding, Boolean isBigEndian) throws IOException {
        String javaEncoding;
        String ENCODING;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if ((ENCODING = encoding.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
            return new UTF8Reader(inputStream, this.fCurrentEntity.fBufferSize, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        if (ENCODING.equals("US-ASCII")) {
            return new ASCIIReader(inputStream, this.fCurrentEntity.fBufferSize, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        if (ENCODING.equals("ISO-10646-UCS-4")) {
            if (isBigEndian != null) {
                boolean isBE = isBigEndian;
                if (isBE) {
                    return new UCSReader(inputStream, 8);
                }
                return new UCSReader(inputStream, 4);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{encoding}, (short)2);
        }
        if (ENCODING.equals("ISO-10646-UCS-2")) {
            if (isBigEndian != null) {
                boolean isBE = isBigEndian;
                if (isBE) {
                    return new UCSReader(inputStream, 2);
                }
                return new UCSReader(inputStream, 1);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{encoding}, (short)2);
        }
        boolean validIANA = XMLChar.isValidIANAEncoding(encoding);
        boolean validJava = XMLChar.isValidJavaEncoding(encoding);
        if (!validIANA || this.fAllowJavaEncodings && !validJava) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{encoding}, (short)2);
            encoding = "ISO-8859-1";
        }
        if ((javaEncoding = EncodingMap.getIANA2JavaMapping(ENCODING)) == null) {
            if (this.fAllowJavaEncodings) {
                javaEncoding = encoding;
            } else {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{encoding}, (short)2);
                javaEncoding = "ISO8859_1";
            }
        }
        return new InputStreamReader(inputStream, javaEncoding);
    }

    protected Object[] getEncodingName(byte[] b4, int count) {
        if (count < 2) {
            return new Object[]{"UTF-8", null};
        }
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 254 && b1 == 255) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (b0 == 255 && b1 == 254) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (count < 3) {
            return new Object[]{"UTF-8", null};
        }
        int b2 = b4[2] & 0xFF;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            return new Object[]{"UTF-8", null};
        }
        if (count < 4) {
            return new Object[]{"UTF-8", null};
        }
        int b3 = b4[3] & 0xFF;
        if (b0 == 0 && b1 == 0 && b2 == 0 && b3 == 60) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (b0 == 60 && b1 == 0 && b2 == 0 && b3 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(false)};
        }
        if (b0 == 0 && b1 == 0 && b2 == 60 && b3 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (b0 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
            return new Object[]{"CP037", null};
        }
        return new Object[]{"UTF-8", null};
    }

    final void print() {
    }

    public void registerListener(XMLBufferListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private void invokeListeners(int loadPos) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            XMLBufferListener listener = (XMLBufferListener)this.listeners.get(i);
            listener.refresh(loadPos);
        }
    }

    static {
        int i;
        validContent = new boolean[127];
        validNames = new boolean[127];
        for (i = 32; i < 127; i = (int)((char)(i + 1))) {
            XMLEntityReaderImpl.validContent[i] = true;
        }
        XMLEntityReaderImpl.validContent[9] = true;
        XMLEntityReaderImpl.validContent[38] = false;
        XMLEntityReaderImpl.validContent[60] = false;
        XMLEntityReaderImpl.validContent[93] = false;
        for (i = 65; i <= 90; ++i) {
            XMLEntityReaderImpl.validNames[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            XMLEntityReaderImpl.validNames[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            XMLEntityReaderImpl.validNames[i] = true;
        }
        XMLEntityReaderImpl.validNames[45] = true;
        XMLEntityReaderImpl.validNames[46] = true;
        XMLEntityReaderImpl.validNames[58] = true;
        XMLEntityReaderImpl.validNames[95] = true;
    }
}

