/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	storagev1 "k8s.io/api/storage/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	applyconfigurationsstoragev1 "k8s.io/client-go/applyconfigurations/storage/v1"
	gentype "k8s.io/client-go/gentype"
	scheme "k8s.io/client-go/kubernetes/scheme"
)

// VolumeAttributesClassesGetter has a method to return a VolumeAttributesClassInterface.
// A group's client should implement this interface.
type VolumeAttributesClassesGetter interface {
	VolumeAttributesClasses() VolumeAttributesClassInterface
}

// VolumeAttributesClassInterface has methods to work with VolumeAttributesClass resources.
type VolumeAttributesClassInterface interface {
	Create(ctx context.Context, volumeAttributesClass *storagev1.VolumeAttributesClass, opts metav1.CreateOptions) (*storagev1.VolumeAttributesClass, error)
	Update(ctx context.Context, volumeAttributesClass *storagev1.VolumeAttributesClass, opts metav1.UpdateOptions) (*storagev1.VolumeAttributesClass, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*storagev1.VolumeAttributesClass, error)
	List(ctx context.Context, opts metav1.ListOptions) (*storagev1.VolumeAttributesClassList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *storagev1.VolumeAttributesClass, err error)
	Apply(ctx context.Context, volumeAttributesClass *applyconfigurationsstoragev1.VolumeAttributesClassApplyConfiguration, opts metav1.ApplyOptions) (result *storagev1.VolumeAttributesClass, err error)
	VolumeAttributesClassExpansion
}

// volumeAttributesClasses implements VolumeAttributesClassInterface
type volumeAttributesClasses struct {
	*gentype.ClientWithListAndApply[*storagev1.VolumeAttributesClass, *storagev1.VolumeAttributesClassList, *applyconfigurationsstoragev1.VolumeAttributesClassApplyConfiguration]
}

// newVolumeAttributesClasses returns a VolumeAttributesClasses
func newVolumeAttributesClasses(c *StorageV1Client) *volumeAttributesClasses {
	return &volumeAttributesClasses{
		gentype.NewClientWithListAndApply[*storagev1.VolumeAttributesClass, *storagev1.VolumeAttributesClassList, *applyconfigurationsstoragev1.VolumeAttributesClassApplyConfiguration](
			"volumeattributesclasses",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *storagev1.VolumeAttributesClass { return &storagev1.VolumeAttributesClass{} },
			func() *storagev1.VolumeAttributesClassList { return &storagev1.VolumeAttributesClassList{} },
			gentype.PrefersProtobuf[*storagev1.VolumeAttributesClass](),
		),
	}
}
