// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct RegisterClientOutput {
    /// <p>The unique identifier string for each client. This client uses this identifier to get authenticated by the service in subsequent calls.</p>
    pub client_id: ::std::option::Option<::std::string::String>,
    /// <p>A secret string generated for the client. The client will use this string to get authenticated by the service in subsequent calls.</p>
    pub client_secret: ::std::option::Option<::std::string::String>,
    /// <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.</p>
    pub client_id_issued_at: i64,
    /// <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become invalid.</p>
    pub client_secret_expires_at: i64,
    /// <p>An endpoint that the client can use to request authorization.</p>
    pub authorization_endpoint: ::std::option::Option<::std::string::String>,
    /// <p>An endpoint that the client can use to create tokens.</p>
    pub token_endpoint: ::std::option::Option<::std::string::String>,
    _request_id: Option<String>,
}
impl RegisterClientOutput {
    /// <p>The unique identifier string for each client. This client uses this identifier to get authenticated by the service in subsequent calls.</p>
    pub fn client_id(&self) -> ::std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>A secret string generated for the client. The client will use this string to get authenticated by the service in subsequent calls.</p>
    pub fn client_secret(&self) -> ::std::option::Option<&str> {
        self.client_secret.as_deref()
    }
    /// <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.</p>
    pub fn client_id_issued_at(&self) -> i64 {
        self.client_id_issued_at
    }
    /// <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become invalid.</p>
    pub fn client_secret_expires_at(&self) -> i64 {
        self.client_secret_expires_at
    }
    /// <p>An endpoint that the client can use to request authorization.</p>
    pub fn authorization_endpoint(&self) -> ::std::option::Option<&str> {
        self.authorization_endpoint.as_deref()
    }
    /// <p>An endpoint that the client can use to create tokens.</p>
    pub fn token_endpoint(&self) -> ::std::option::Option<&str> {
        self.token_endpoint.as_deref()
    }
}
impl ::std::fmt::Debug for RegisterClientOutput {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterClientOutput");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("client_id_issued_at", &self.client_id_issued_at);
        formatter.field("client_secret_expires_at", &self.client_secret_expires_at);
        formatter.field("authorization_endpoint", &self.authorization_endpoint);
        formatter.field("token_endpoint", &self.token_endpoint);
        formatter.field("_request_id", &self._request_id);
        formatter.finish()
    }
}
impl ::aws_types::request_id::RequestId for RegisterClientOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl RegisterClientOutput {
    /// Creates a new builder-style object to manufacture [`RegisterClientOutput`](crate::operation::register_client::RegisterClientOutput).
    pub fn builder() -> crate::operation::register_client::builders::RegisterClientOutputBuilder {
        crate::operation::register_client::builders::RegisterClientOutputBuilder::default()
    }
}

/// A builder for [`RegisterClientOutput`](crate::operation::register_client::RegisterClientOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct RegisterClientOutputBuilder {
    pub(crate) client_id: ::std::option::Option<::std::string::String>,
    pub(crate) client_secret: ::std::option::Option<::std::string::String>,
    pub(crate) client_id_issued_at: ::std::option::Option<i64>,
    pub(crate) client_secret_expires_at: ::std::option::Option<i64>,
    pub(crate) authorization_endpoint: ::std::option::Option<::std::string::String>,
    pub(crate) token_endpoint: ::std::option::Option<::std::string::String>,
    _request_id: Option<String>,
}
impl RegisterClientOutputBuilder {
    /// <p>The unique identifier string for each client. This client uses this identifier to get authenticated by the service in subsequent calls.</p>
    pub fn client_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.client_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The unique identifier string for each client. This client uses this identifier to get authenticated by the service in subsequent calls.</p>
    pub fn set_client_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.client_id = input;
        self
    }
    /// <p>The unique identifier string for each client. This client uses this identifier to get authenticated by the service in subsequent calls.</p>
    pub fn get_client_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.client_id
    }
    /// <p>A secret string generated for the client. The client will use this string to get authenticated by the service in subsequent calls.</p>
    pub fn client_secret(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.client_secret = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A secret string generated for the client. The client will use this string to get authenticated by the service in subsequent calls.</p>
    pub fn set_client_secret(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.client_secret = input;
        self
    }
    /// <p>A secret string generated for the client. The client will use this string to get authenticated by the service in subsequent calls.</p>
    pub fn get_client_secret(&self) -> &::std::option::Option<::std::string::String> {
        &self.client_secret
    }
    /// <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.</p>
    pub fn client_id_issued_at(mut self, input: i64) -> Self {
        self.client_id_issued_at = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.</p>
    pub fn set_client_id_issued_at(mut self, input: ::std::option::Option<i64>) -> Self {
        self.client_id_issued_at = input;
        self
    }
    /// <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.</p>
    pub fn get_client_id_issued_at(&self) -> &::std::option::Option<i64> {
        &self.client_id_issued_at
    }
    /// <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become invalid.</p>
    pub fn client_secret_expires_at(mut self, input: i64) -> Self {
        self.client_secret_expires_at = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become invalid.</p>
    pub fn set_client_secret_expires_at(mut self, input: ::std::option::Option<i64>) -> Self {
        self.client_secret_expires_at = input;
        self
    }
    /// <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become invalid.</p>
    pub fn get_client_secret_expires_at(&self) -> &::std::option::Option<i64> {
        &self.client_secret_expires_at
    }
    /// <p>An endpoint that the client can use to request authorization.</p>
    pub fn authorization_endpoint(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.authorization_endpoint = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An endpoint that the client can use to request authorization.</p>
    pub fn set_authorization_endpoint(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.authorization_endpoint = input;
        self
    }
    /// <p>An endpoint that the client can use to request authorization.</p>
    pub fn get_authorization_endpoint(&self) -> &::std::option::Option<::std::string::String> {
        &self.authorization_endpoint
    }
    /// <p>An endpoint that the client can use to create tokens.</p>
    pub fn token_endpoint(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.token_endpoint = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An endpoint that the client can use to create tokens.</p>
    pub fn set_token_endpoint(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.token_endpoint = input;
        self
    }
    /// <p>An endpoint that the client can use to create tokens.</p>
    pub fn get_token_endpoint(&self) -> &::std::option::Option<::std::string::String> {
        &self.token_endpoint
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`RegisterClientOutput`](crate::operation::register_client::RegisterClientOutput).
    pub fn build(self) -> crate::operation::register_client::RegisterClientOutput {
        crate::operation::register_client::RegisterClientOutput {
            client_id: self.client_id,
            client_secret: self.client_secret,
            client_id_issued_at: self.client_id_issued_at.unwrap_or_default(),
            client_secret_expires_at: self.client_secret_expires_at.unwrap_or_default(),
            authorization_endpoint: self.authorization_endpoint,
            token_endpoint: self.token_endpoint,
            _request_id: self._request_id,
        }
    }
}
impl ::std::fmt::Debug for RegisterClientOutputBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterClientOutputBuilder");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("client_id_issued_at", &self.client_id_issued_at);
        formatter.field("client_secret_expires_at", &self.client_secret_expires_at);
        formatter.field("authorization_endpoint", &self.authorization_endpoint);
        formatter.field("token_endpoint", &self.token_endpoint);
        formatter.field("_request_id", &self._request_id);
        formatter.finish()
    }
}
