/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.tools.registry.ToolDescriptor;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class ExecuteToolHandler
implements IActionDelegate {
    private final IWorkbenchWindow window;
    private final ToolDescriptor tool;
    private ISelection selection;

    public ExecuteToolHandler(IWorkbenchWindow window, ToolDescriptor tool) {
        this.window = window;
        this.tool = tool;
    }

    public void run(IAction action) {
        if (!this.selection.isEmpty()) {
            List selectedObjects = NavigatorUtils.getSelectedObjects((ISelection)this.selection);
            this.executeTool(selectedObjects);
        }
    }

    private void executeTool(List<DBSObject> objects) {
        try {
            DBPDataSource dataSource = objects.get(0).getDataSource();
            if (dataSource != null) {
                DBPProject selectedProject = dataSource.getContainer().getProject();
                TaskTypeDescriptor taskForObjs = this.tool.getTaskForObjects(objects);
                if (taskForObjs != null) {
                    if (taskForObjs.requiresMutableDatabase() && DBUtils.isReadOnly((DBSObject)dataSource)) {
                        DBWorkbench.getPlatformUI().showWarningMessageBox(TaskUIMessages.task_execute_handler_tool_warn_readonly_title, NLS.bind((String)TaskUIMessages.task_execute_handler_tool_warn_readonly_message, (Object)dataSource.getName()));
                    } else if (taskForObjs.requiresExportPrivileges() && ApplicationPolicyProvider.getInstance().isPolicyEnabled("policy.data.export.disabled")) {
                        DBWorkbench.getPlatformUI().showWarningMessageBox(UIMessages.dialog_policy_data_export_title, UIMessages.dialog_policy_data_export_msg);
                    } else {
                        StructuredSelection selectedObjects = new StructuredSelection(objects.toArray());
                        TaskConfigurationWizardDialog.openNewToolTaskDialog(this.window, selectedProject, taskForObjs.getId(), (IStructuredSelection)selectedObjects);
                    }
                } else {
                    Command cmd = this.tool.getCommandForObjects(objects);
                    if (cmd != null) {
                        StructuredSelection selection = new StructuredSelection(objects);
                        EvaluationContext context = new EvaluationContext(null, (Object)selection);
                        context.addVariable("selection", (Object)selection);
                        ExecutionEvent event = new ExecutionEvent(cmd, Collections.EMPTY_MAP, null, (Object)context);
                        cmd.executeWithChecks(event);
                    } else {
                        DBWorkbench.getPlatformUI().showWarningMessageBox(TaskUIMessages.task_execute_handler_tool_error_title, TaskUIMessages.task_execute_handler_tool_error_apply_message);
                    }
                }
            } else {
                DBWorkbench.getPlatformUI().showWarningMessageBox(TaskUIMessages.task_execute_handler_tool_error_title, TaskUIMessages.task_execute_handler_tool_error_project_message);
            }
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError(TaskUIMessages.task_execute_handler_tool_error_title, NLS.bind((String)TaskUIMessages.task_execute_handler_tool_error_message, (Object)this.tool.getLabel()), e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

