<?php
/** Chinese (中文)
 *
 * @file
 * @ingroup Languages
 *
 * @author Kuailong
 * @author PhiLiP
 * @author Shizhao
 * @author Winston Sung
 * @author Wong128hk
 */

# Message file for converter code "zh"

$fallback = 'zh-hans, zh-hant, zh-cn, zh-tw, zh-hk';

# Set namespace names in en by default to prevent fallback to translations of language variants.
$namespaceNames = [
	NS_MEDIA            => 'Media',
	NS_SPECIAL          => 'Special',
	NS_TALK             => 'Talk',
	NS_USER             => 'User',
	NS_USER_TALK        => 'User_talk',
	NS_PROJECT_TALK     => '$1_talk',
	NS_FILE             => 'File',
	NS_FILE_TALK        => 'File_talk',
	NS_MEDIAWIKI        => 'MediaWiki',
	NS_MEDIAWIKI_TALK   => 'MediaWiki_talk',
	NS_TEMPLATE         => 'Template',
	NS_TEMPLATE_TALK    => 'Template_talk',
	NS_HELP             => 'Help',
	NS_HELP_TALK        => 'Help_talk',
	NS_CATEGORY         => 'Category',
	NS_CATEGORY_TALK    => 'Category_talk',
];

# T296188: Store namespace aliases of language variants
#  in their message files respectively.
#
# $namespaceAliases = [];

/** @phpcs-require-sorted-array */
$specialPageAliases = [
	'Activeusers'                => [ 'ActiveUsers' ],
	'Allmessages'                => [ 'AllMessages' ],
	'AllMyUploads'               => [ 'AllMyUploads' ],
	'Allpages'                   => [ 'AllPages' ],
	'Ancientpages'               => [ 'AncientPages' ],
	'ApiHelp'                    => [ 'ApiHelp' ],
	'ApiSandbox'                 => [ 'ApiSandbox' ],
	'AuthenticationPopupSuccess' => [ 'AuthenticationPopupSuccess' ],
	'AutoblockList'              => [ 'AutoblockList' ],
	'Badtitle'                   => [ 'Badtitle' ],
	'Blankpage'                  => [ 'BlankPage' ],
	'Block'                      => [ 'Block' ],
	'BlockList'                  => [ 'BlockList' ],
	'Booksources'                => [ 'BookSources' ],
	'BotPasswords'               => [ 'BotPasswords' ],
	'BrokenRedirects'            => [ 'BrokenRedirects' ],
	'Categories'                 => [ 'Categories' ],
	'ChangeContentModel'         => [ 'ChangeContentModel' ],
	'ChangeCredentials'          => [ 'ChangeCredentials' ],
	'ChangeEmail'                => [ 'ChangeEmail' ],
	'ChangePassword'             => [ 'ChangePassword' ],
	'ComparePages'               => [ 'ComparePages' ],
	'Confirmemail'               => [ 'ConfirmEmail' ],
	'Contribute'                 => [ 'Contribute' ],
	'Contributions'              => [ 'Contributions' ],
	'CreateAccount'              => [ 'CreateAccount' ],
	'Deadendpages'               => [ 'DeadendPages' ],
	'DeletedContributions'       => [ 'DeletedContributions' ],
	'DeletePage'                 => [ 'DeletePage' ],
	'Diff'                       => [ 'Diff' ],
	'DoubleRedirects'            => [ 'DoubleRedirects' ],
	'EditPage'                   => [ 'EditPage' ],
	'EditRecovery'               => [ 'EditRecovery' ],
	'EditTags'                   => [ 'EditTags' ],
	'EditWatchlist'              => [ 'EditWatchlist' ],
	'Emailuser'                  => [ 'EmailUser' ],
	'ExpandTemplates'            => [ 'ExpandTemplates' ],
	'Export'                     => [ 'Export' ],
	'Fewestrevisions'            => [ 'FewestRevisions' ],
	'FileDuplicateSearch'        => [ 'FileDuplicateSearch' ],
	'Filepath'                   => [ 'FilePath' ],
	'GoToInterwiki'              => [ 'GoToInterwiki' ],
	'Import'                     => [ 'Import' ],
	'Interwiki'                  => [ 'Interwiki' ],
	'Invalidateemail'            => [ 'InvalidateEmail' ],
	'JavaScriptTest'             => [ 'JavaScriptTest' ],
	'LinkAccounts'               => [ 'LinkAccounts' ],
	'LinkSearch'                 => [ 'LinkSearch' ],
	'Listadmins'                 => [ 'ListAdmins' ],
	'Listbots'                   => [ 'ListBots' ],
	'ListDuplicatedFiles'        => [ 'ListDuplicatedFiles' ],
	'Listfiles'                  => [ 'ListFiles' ],
	'Listgrants'                 => [ 'ListGrants' ],
	'Listgrouprights'            => [ 'ListGroupRights' ],
	'Listredirects'              => [ 'ListRedirects' ],
	'Listusers'                  => [ 'ListUsers' ],
	'Lockdb'                     => [ 'LockDB' ],
	'Log'                        => [ 'Log' ],
	'Lonelypages'                => [ 'LonelyPages' ],
	'Longpages'                  => [ 'LongPages' ],
	'MediaStatistics'            => [ 'MediaStatistics' ],
	'MergeHistory'               => [ 'MergeHistory' ],
	'MIMEsearch'                 => [ 'MIMESearch' ],
	'Mostcategories'             => [ 'MostCategories' ],
	'Mostimages'                 => [ 'MostLinkedFiles' ],
	'Mostinterwikis'             => [ 'MostInterwikis' ],
	'Mostlinked'                 => [ 'MostLinkedPages' ],
	'Mostlinkedcategories'       => [ 'MostLinkedCategories' ],
	'Mostlinkedtemplates'        => [ 'MostTranscludedPages' ],
	'Mostrevisions'              => [ 'MostRevisions' ],
	'Movepage'                   => [ 'MovePage' ],
	'Mute'                       => [ 'Mute' ],
	'Mycontributions'            => [ 'MyContributions' ],
	'MyLanguage'                 => [ 'MyLanguage' ],
	'Mylog'                      => [ 'MyLog' ],
	'Mypage'                     => [ 'MyPage' ],
	'Mytalk'                     => [ 'MyTalk' ],
	'Myuploads'                  => [ 'MyUploads' ],
	'NamespaceInfo'              => [ 'NamespaceInfo' ],
	'Newimages'                  => [ 'NewFiles' ],
	'Newpages'                   => [ 'NewPages' ],
	'NewSection'                 => [ 'NewSection' ],
	'PageData'                   => [ 'PageData' ],
	'PageHistory'                => [ 'PageHistory' ],
	'PageInfo'                   => [ 'PageInfo' ],
	'PageLanguage'               => [ 'PageLanguage' ],
	'PagesWithProp'              => [ 'PagesWithProp' ],
	'PasswordPolicies'           => [ 'PasswordPolicies' ],
	'PasswordReset'              => [ 'PasswordReset' ],
	'PermanentLink'              => [ 'PermanentLink' ],
	'Preferences'                => [ 'Preferences' ],
	'Prefixindex'                => [ 'PrefixIndex' ],
	'Protectedpages'             => [ 'ProtectedPages' ],
	'Protectedtitles'            => [ 'ProtectedTitles' ],
	'ProtectPage'                => [ 'ProtectPage' ],
	'Purge'                      => [ 'Purge' ],
	'RandomInCategory'           => [ 'RandomInCategory' ],
	'Randompage'                 => [ 'Random' ],
	'Randomredirect'             => [ 'RandomRedirect' ],
	'Randomrootpage'             => [ 'RandomRootpage' ],
	'Recentchanges'              => [ 'RecentChanges' ],
	'Recentchangeslinked'        => [ 'RecentChangesLinked' ],
	'Redirect'                   => [ 'Redirect' ],
	'RemoveCredentials'          => [ 'RemoveCredentials' ],
	'Renameuser'                 => [ 'RenameUser' ],
	'ResetTokens'                => [ 'ResetTokens' ],
	'Revisiondelete'             => [ 'RevisionDelete' ],
	'RunJobs'                    => [ 'RunJobs' ],
	'Search'                     => [ 'Search' ],
	'Shortpages'                 => [ 'ShortPages' ],
	'Specialpages'               => [ 'SpecialPages' ],
	'Statistics'                 => [ 'Statistics' ],
	'Tags'                       => [ 'Tags' ],
	'TalkPage'                   => [ 'TalkPage' ],
	'TrackingCategories'         => [ 'TrackingCategories' ],
	'Unblock'                    => [ 'Unblock' ],
	'Uncategorizedcategories'    => [ 'UncategorizedCategories' ],
	'Uncategorizedimages'        => [ 'UncategorizedFiles' ],
	'Uncategorizedpages'         => [ 'UncategorizedPages' ],
	'Uncategorizedtemplates'     => [ 'UncategorizedTemplates' ],
	'Undelete'                   => [ 'Undelete' ],
	'UnlinkAccounts'             => [ 'UnlinkAccounts' ],
	'Unlockdb'                   => [ 'UnlockDB' ],
	'Unusedcategories'           => [ 'UnusedCategories' ],
	'Unusedimages'               => [ 'UnusedFiles' ],
	'Unusedtemplates'            => [ 'UnusedTemplates' ],
	'Unwatchedpages'             => [ 'UnwatchedPages' ],
	'Upload'                     => [ 'Upload' ],
	'UploadStash'                => [ 'UploadStash' ],
	'Userlogin'                  => [ 'UserLogin' ],
	'Userlogout'                 => [ 'UserLogout' ],
	'Userrights'                 => [ 'UserRights' ],
	'Version'                    => [ 'Version' ],
	'Wantedcategories'           => [ 'WantedCategories' ],
	'Wantedfiles'                => [ 'WantedFiles' ],
	'Wantedpages'                => [ 'WantedPages' ],
	'Wantedtemplates'            => [ 'WantedTemplates' ],
	'Watchlist'                  => [ 'Watchlist' ],
	'Whatlinkshere'              => [ 'WhatLinksHere' ],
	'Withoutinterwiki'           => [ 'WithoutInterwiki' ],
];

# Set magic words in en by default to prevent fallback to translations of language variants.
# Store magic word aliases of language variants in their message files respectively.

/** @phpcs-require-sorted-array */
$magicWords = [
	'!'                       => [ 1, '!' ],
	'anchorencode'            => [ 0, 'ANCHORENCODE' ],
	'articlepath'             => [ 0, 'ARTICLEPATH' ],
	'basepagename'            => [ 1, 'BASEPAGENAME' ],
	'basepagenamee'           => [ 1, 'BASEPAGENAMEE' ],
	'bidi'                    => [ 0, 'BIDI:' ],
	'canonicalurl'            => [ 0, 'CANONICALURL:' ],
	'canonicalurle'           => [ 0, 'CANONICALURLE:' ],
	'cascadingsources'        => [ 1, 'CASCADINGSOURCES' ],
	'contentlanguage'         => [ 1, 'CONTENTLANGUAGE', 'CONTENTLANG' ],
	'currentday'              => [ 1, 'CURRENTDAY' ],
	'currentday2'             => [ 1, 'CURRENTDAY2' ],
	'currentdayname'          => [ 1, 'CURRENTDAYNAME' ],
	'currentdow'              => [ 1, 'CURRENTDOW' ],
	'currenthour'             => [ 1, 'CURRENTHOUR' ],
	'currentmonth'            => [ 1, 'CURRENTMONTH', 'CURRENTMONTH2' ],
	'currentmonth1'           => [ 1, 'CURRENTMONTH1' ],
	'currentmonthabbrev'      => [ 1, 'CURRENTMONTHABBREV' ],
	'currentmonthname'        => [ 1, 'CURRENTMONTHNAME' ],
	'currentmonthnamegen'     => [ 1, 'CURRENTMONTHNAMEGEN' ],
	'currenttime'             => [ 1, 'CURRENTTIME' ],
	'currenttimestamp'        => [ 1, 'CURRENTTIMESTAMP' ],
	'currentversion'          => [ 1, 'CURRENTVERSION' ],
	'currentweek'             => [ 1, 'CURRENTWEEK' ],
	'currentyear'             => [ 1, 'CURRENTYEAR' ],
	'defaultsort'             => [ 1, 'DEFAULTSORT:', 'DEFAULTSORTKEY:', 'DEFAULTCATEGORYSORT:' ],
	'defaultsort_noerror'     => [ 0, 'noerror' ],
	'defaultsort_noreplace'   => [ 0, 'noreplace' ],
	'directionmark'           => [ 1, 'DIRECTIONMARK', 'DIRMARK' ],
	'displaytitle'            => [ 1, 'DISPLAYTITLE' ],
	'displaytitle_noerror'    => [ 0, 'noerror' ],
	'displaytitle_noreplace'  => [ 0, 'noreplace' ],
	'expectunusedcategory'    => [ 1, '__EXPECTUNUSEDCATEGORY__', ],
	'filepath'                => [ 0, 'FILEPATH:' ],
	'forcetoc'                => [ 0, '__FORCETOC__' ],
	'formatdate'              => [ 0, 'formatdate', 'dateformat' ],
	'formatnum'               => [ 0, 'FORMATNUM' ],
	'fullpagename'            => [ 1, 'FULLPAGENAME' ],
	'fullpagenamee'           => [ 1, 'FULLPAGENAMEE' ],
	'fullurl'                 => [ 0, 'FULLURL:' ],
	'fullurle'                => [ 0, 'FULLURLE:' ],
	'gender'                  => [ 0, 'GENDER:' ],
	'grammar'                 => [ 0, 'GRAMMAR:' ],
	'hiddencat'               => [ 1, '__HIDDENCAT__' ],
	'img_alt'                 => [ 1, 'alt=$1' ],
	'img_baseline'            => [ 1, 'baseline' ],
	'img_border'              => [ 1, 'border' ],
	'img_bottom'              => [ 1, 'bottom' ],
	'img_center'              => [ 1, 'center', 'centre' ],
	'img_class'               => [ 1, 'class=$1' ],
	'img_framed'              => [ 1, 'frame', 'framed', 'enframed' ],
	'img_frameless'           => [ 1, 'frameless' ],
	'img_lang'                => [ 1, 'lang=$1' ],
	'img_left'                => [ 1, 'left' ],
	'img_link'                => [ 1, 'link=$1' ],
	'img_manualthumb'         => [ 1, 'thumbnail=$1', 'thumb=$1' ],
	'img_middle'              => [ 1, 'middle' ],
	'img_none'                => [ 1, 'none' ],
	'img_page'                => [ 1, 'page=$1', 'page $1' ],
	'img_right'               => [ 1, 'right' ],
	'img_sub'                 => [ 1, 'sub' ],
	'img_super'               => [ 1, 'super', 'sup' ],
	'img_text_bottom'         => [ 1, 'text-bottom' ],
	'img_text_top'            => [ 1, 'text-top' ],
	'img_thumbnail'           => [ 1, 'thumb', 'thumbnail' ],
	'img_top'                 => [ 1, 'top' ],
	'img_upright'             => [ 1, 'upright', 'upright=$1', 'upright $1' ],
	'img_width'               => [ 1, '$1px' ],
	'index'                   => [ 1, '__INDEX__' ],
	'int'                     => [ 0, 'INT:' ],
	'language'                => [ 0, '#LANGUAGE' ],
	'lc'                      => [ 0, 'LC:' ],
	'lcfirst'                 => [ 0, 'LCFIRST:' ],
	'localday'                => [ 1, 'LOCALDAY' ],
	'localday2'               => [ 1, 'LOCALDAY2' ],
	'localdayname'            => [ 1, 'LOCALDAYNAME' ],
	'localdow'                => [ 1, 'LOCALDOW' ],
	'localhour'               => [ 1, 'LOCALHOUR' ],
	'localmonth'              => [ 1, 'LOCALMONTH', 'LOCALMONTH2' ],
	'localmonth1'             => [ 1, 'LOCALMONTH1' ],
	'localmonthabbrev'        => [ 1, 'LOCALMONTHABBREV' ],
	'localmonthname'          => [ 1, 'LOCALMONTHNAME' ],
	'localmonthnamegen'       => [ 1, 'LOCALMONTHNAMEGEN' ],
	'localtime'               => [ 1, 'LOCALTIME' ],
	'localtimestamp'          => [ 1, 'LOCALTIMESTAMP' ],
	'localurl'                => [ 0, 'LOCALURL:' ],
	'localurle'               => [ 0, 'LOCALURLE:' ],
	'localweek'               => [ 1, 'LOCALWEEK' ],
	'localyear'               => [ 1, 'LOCALYEAR' ],
	'msg'                     => [ 0, 'MSG:' ],
	'msgnw'                   => [ 0, 'MSGNW:' ],
	'namespace'               => [ 1, 'NAMESPACE' ],
	'namespacee'              => [ 1, 'NAMESPACEE' ],
	'namespacenumber'         => [ 1, 'NAMESPACENUMBER' ],
	'newsectionlink'          => [ 1, '__NEWSECTIONLINK__' ],
	'nocommafysuffix'         => [ 0, 'NOSEP' ],
	'nocontentconvert'        => [ 0, '__NOCONTENTCONVERT__', '__NOCC__' ],
	'noeditsection'           => [ 0, '__NOEDITSECTION__' ],
	'nogallery'               => [ 0, '__NOGALLERY__' ],
	'noindex'                 => [ 1, '__NOINDEX__' ],
	'nonewsectionlink'        => [ 1, '__NONEWSECTIONLINK__' ],
	'notitleconvert'          => [ 0, '__NOTITLECONVERT__', '__NOTC__' ],
	'notoc'                   => [ 0, '__NOTOC__' ],
	'ns'                      => [ 0, 'NS:' ],
	'nse'                     => [ 0, 'NSE:' ],
	'numberingroup'           => [ 1, 'NUMBERINGROUP', 'NUMINGROUP' ],
	'numberofactiveusers'     => [ 1, 'NUMBEROFACTIVEUSERS' ],
	'numberofadmins'          => [ 1, 'NUMBEROFADMINS' ],
	'numberofarticles'        => [ 1, 'NUMBEROFARTICLES' ],
	'numberofedits'           => [ 1, 'NUMBEROFEDITS' ],
	'numberoffiles'           => [ 1, 'NUMBEROFFILES' ],
	'numberofpages'           => [ 1, 'NUMBEROFPAGES' ],
	'numberofusers'           => [ 1, 'NUMBEROFUSERS' ],
	'padleft'                 => [ 0, 'PADLEFT' ],
	'padright'                => [ 0, 'PADRIGHT' ],
	'pageid'                  => [ 0, 'PAGEID' ],
	'pagelanguage'            => [ 1, 'PAGELANGUAGE' ],
	'pagename'                => [ 1, 'PAGENAME' ],
	'pagenamee'               => [ 1, 'PAGENAMEE' ],
	'pagesincategory'         => [ 1, 'PAGESINCATEGORY', 'PAGESINCAT' ],
	'pagesincategory_all'     => [ 0, 'all' ],
	'pagesincategory_files'   => [ 0, 'files' ],
	'pagesincategory_pages'   => [ 0, 'pages' ],
	'pagesincategory_subcats' => [ 0, 'subcats' ],
	'pagesinnamespace'        => [ 1, 'PAGESINNAMESPACE:', 'PAGESINNS:' ],
	'pagesize'                => [ 1, 'PAGESIZE' ],
	'plural'                  => [ 0, 'PLURAL:' ],
	'protectionexpiry'        => [ 1, 'PROTECTIONEXPIRY' ],
	'protectionlevel'         => [ 1, 'PROTECTIONLEVEL' ],
	'raw'                     => [ 0, 'RAW:' ],
	'rawsuffix'               => [ 1, 'R' ],
	'redirect'                => [ 0, '#REDIRECT' ],
	'revisionday'             => [ 1, 'REVISIONDAY' ],
	'revisionday2'            => [ 1, 'REVISIONDAY2' ],
	'revisionid'              => [ 1, 'REVISIONID' ],
	'revisionmonth'           => [ 1, 'REVISIONMONTH' ],
	'revisionmonth1'          => [ 1, 'REVISIONMONTH1' ],
	'revisionsize'            => [ 1, 'REVISIONSIZE' ],
	'revisiontimestamp'       => [ 1, 'REVISIONTIMESTAMP' ],
	'revisionuser'            => [ 1, 'REVISIONUSER' ],
	'revisionyear'            => [ 1, 'REVISIONYEAR' ],
	'rootpagename'            => [ 1, 'ROOTPAGENAME' ],
	'rootpagenamee'           => [ 1, 'ROOTPAGENAMEE' ],
	'safesubst'               => [ 0, 'SAFESUBST:' ],
	'scriptpath'              => [ 0, 'SCRIPTPATH' ],
	'server'                  => [ 0, 'SERVER' ],
	'servername'              => [ 0, 'SERVERNAME' ],
	'sitename'                => [ 1, 'SITENAME' ],
	'special'                 => [ 0, 'special' ],
	'speciale'                => [ 0, 'speciale' ],
	'staticredirect'          => [ 1, '__STATICREDIRECT__' ],
	'stylepath'               => [ 0, 'STYLEPATH' ],
	'subjectpagename'         => [ 1, 'SUBJECTPAGENAME', 'ARTICLEPAGENAME' ],
	'subjectpagenamee'        => [ 1, 'SUBJECTPAGENAMEE', 'ARTICLEPAGENAMEE' ],
	'subjectspace'            => [ 1, 'SUBJECTSPACE', 'ARTICLESPACE' ],
	'subjectspacee'           => [ 1, 'SUBJECTSPACEE', 'ARTICLESPACEE' ],
	'subpagename'             => [ 1, 'SUBPAGENAME' ],
	'subpagenamee'            => [ 1, 'SUBPAGENAMEE' ],
	'subst'                   => [ 0, 'SUBST:' ],
	'tag'                     => [ 0, 'tag' ],
	'talkpagename'            => [ 1, 'TALKPAGENAME' ],
	'talkpagenamee'           => [ 1, 'TALKPAGENAMEE' ],
	'talkspace'               => [ 1, 'TALKSPACE' ],
	'talkspacee'              => [ 1, 'TALKSPACEE' ],
	'toc'                     => [ 0, '__TOC__' ],
	'uc'                      => [ 0, 'UC:' ],
	'ucfirst'                 => [ 0, 'UCFIRST:' ],
	'urlencode'               => [ 0, 'URLENCODE:' ],
	'url_path'                => [ 0, 'PATH' ],
	'url_query'               => [ 0, 'QUERY' ],
	'url_wiki'                => [ 0, 'WIKI' ],
];
