'use strict';

/*!
 * VisualEditor Cite specific test cases including sub-references for the Converter.  The
 * normalizedBody in these tests should match the HTML for Parsoid of the html2wt tests
 * in visualEditorHtml2WtTests.txt
 *
 * @copyright 2011-2025 VisualEditor Team's Cite sub-team and others; see AUTHORS.txt
 * @license MIT
 */

ve.dm.ConverterSubReferenceTestCases = {};
ve.dm.ConverterSubReferenceTestCases.cases = {};

// Wikitext before:
// <ref details="page. 123" name="book">Miller</ref>
ve.dm.ConverterSubReferenceTestCases.simpleMainPlusDetails = {
	data: [
		{
			type: 'paragraph',
			internal: {
				whitespace: [
					undefined,
					undefined,
					undefined,
					'\n'
				]
			}
		},
		{
			type: 'mwReference',
			attributes: {
				mw: {
					name: 'ref',
					attrs: {
						details: 'page. 123'
					},
					body: {
						id: 'mw-reference-text-cite_note-2'
					},
					mainRef: 'book',
					mainBody: 'mw-reference-text-cite_note-book-1',
					isSubRefWithMainBody: 1
				},
				originalMw: '{"name":"ref","attrs":{"details":"page. 123"},"body":{"id":"mw-reference-text-cite_note-2"},"mainRef":"book","mainBody":"mw-reference-text-cite_note-book-1","isSubRefWithMainBody":1}',
				listIndex: 0,
				listGroup: 'mwReference/',
				listKey: 'auto/0',
				refGroup: '',
				contentsUsed: true,
				mainRefKey: 'literal/book',
				refListItemId: 'mw-reference-text-cite_note-2'
			}
		},
		{
			type: '/mwReference'
		},
		{
			type: '/paragraph'
		},
		{
			type: 'mwReferencesList',
			attributes: {
				mw: {
					name: 'references',
					attrs: {},
					autoGenerated: true,
					body: {
						html: "\n<sup typeof=\"mw:Extension/ref\" data-parsoid=\"{}\" data-mw='{\"name\":\"ref\",\"attrs\":{\"name\":\"book\",\"group\":\"\"},\"body\":{\"id\":\"mw-reference-text-cite_note-book-1\"},\"isSyntheticMainRef\":1}'>Miller</sup>"
					}
				},
				originalMw: "{\"name\":\"references\",\"attrs\":{},\"autoGenerated\":true,\"body\":{\"html\":\"\\n<sup typeof=\\\"mw:Extension/ref\\\" data-parsoid=\\\"{}\\\" data-mw='{\\\"name\\\":\\\"ref\\\",\\\"attrs\\\":{\\\"name\\\":\\\"book\\\",\\\"group\\\":\\\"\\\"},\\\"body\\\":{\\\"id\\\":\\\"mw-reference-text-cite_note-book-1\\\"},\\\"isSyntheticMainRef\\\":1}'>Miller</sup>\"}}",
				refGroup: '',
				listGroup: 'mwReference/',
				isResponsive: true,
				templateGenerated: false
			},
			internal: {
				whitespace: [
					'\n'
				]
			}
		},
		{
			type: 'paragraph',
			internal: {
				generated: 'wrapper',
				whitespace: [
					'\n'
				]
			}
		},
		{
			type: 'mwReference',
			attributes: {
				mw: {
					name: 'ref',
					attrs: {
						name: 'book',
						group: ''
					},
					body: {
						id: 'mw-reference-text-cite_note-book-1'
					},
					isSyntheticMainRef: 1
				},
				originalMw: '{"name":"ref","attrs":{"name":"book","group":""},"body":{"id":"mw-reference-text-cite_note-book-1"},"isSyntheticMainRef":1}',
				listIndex: 1,
				listGroup: 'mwReference/',
				listKey: 'literal/book',
				refGroup: '',
				contentsUsed: true,
				refListItemId: 'mw-reference-text-cite_note-book-1'
			}
		},
		{
			type: '/mwReference'
		},
		{
			type: '/paragraph'
		},
		{
			type: '/mwReferencesList'
		},
		{
			type: 'internalList'
		},
		{
			type: 'internalItem',
			attributes: {
				originalHtml: 'page. 123'
			}
		},
		{
			type: 'paragraph',
			internal: {
				generated: 'wrapper'
			}
		},
		'p',
		'a',
		'g',
		'e',
		'.',
		' ',
		'1',
		'2',
		'3',
		{
			type: '/paragraph'
		},
		{
			type: '/internalItem'
		},
		{
			type: 'internalItem',
			attributes: {
				originalHtml: 'Miller'
			}
		},
		{
			type: 'paragraph',
			internal: {
				generated: 'wrapper'
			}
		},
		'M',
		'i',
		'l',
		'l',
		'e',
		'r',
		{
			type: '/paragraph'
		},
		{
			type: '/internalItem'
		},
		{
			type: '/internalList'
		}
	],
	body:
		"<p id=\"mwAg\"><sup about=\"#mwt1\" class=\"mw-ref reference\" id=\"cite_ref-2\" rel=\"dc:references\" typeof=\"mw:Extension/ref\" data-mw=\"{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page. 123&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}\"><a href=\"./Example/MainPlusDetails#cite_note-2\" id=\"mwAw\"><span class=\"mw-reflink-text\" id=\"mwBA\"><span class=\"cite-bracket\" id=\"mwBQ\">[</span>1.1<span class=\"cite-bracket\" id=\"mwBg\">]</span></span></a></sup></p>\n<div class=\"mw-references-wrap\" typeof=\"mw:Extension/references\" about=\"#mwt2\" data-mw=\"{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-parsoid=\\&quot;{}\\&quot; data-mw='{\\&quot;name\\&quot;:\\&quot;ref\\&quot;,\\&quot;attrs\\&quot;:{\\&quot;name\\&quot;:\\&quot;book\\&quot;,\\&quot;group\\&quot;:\\&quot;\\&quot;},\\&quot;body\\&quot;:{\\&quot;id\\&quot;:\\&quot;mw-reference-text-cite_note-book-1\\&quot;},\\&quot;isSyntheticMainRef\\&quot;:1}'&gt;Miller&lt;/sup&gt;&quot;}}\" id=\"mwBw\"><ol class=\"mw-references references\" id=\"mwCA\"><li about=\"#cite_note-book-1\" id=\"cite_note-book-1\"><span rel=\"mw:referencedBy\" class=\"mw-cite-backlink\" id=\"mwCQ\"></span> <span id=\"mw-reference-text-cite_note-book-1\" class=\"mw-reference-text reference-text\">Miller</span><ol class=\"mw-subreference-list\" id=\"mwCg\"><li about=\"#cite_note-2\" id=\"cite_note-2\"><span class=\"mw-cite-backlink\" id=\"mwCw\"><a href=\"./Example/MainPlusDetails#cite_ref-2\" rel=\"mw:referencedBy\" id=\"mwDA\"><span class=\"mw-linkback-text\" id=\"mwDQ\">↑ </span></a></span> <span id=\"mw-reference-text-cite_note-2\" class=\"mw-reference-text reference-text\">page. 123</span></li>\n</ol></li>\n</ol></div>"
};

// Expect no Wikitext change
ve.dm.ConverterSubReferenceTestCases.cases[ 'Simple main ref including details' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.simpleMainPlusDetails.data,
	body: ve.dm.ConverterSubReferenceTestCases.simpleMainPlusDetails.body,
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page. 123&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page. 123</span></li></ol></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page. 123&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference" about="#mwt1" id="cite_ref-2" rel="dc:references"><a href="./Example/MainPlusDetails#cite_note-2" id="mwAw"><span class="mw-reflink-text" id="mwBA"><span class="cite-bracket" id="mwBQ">[</span>1.1<span class="cite-bracket" id="mwBg">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot; data-parsoid=\\&quot;{}\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page. 123</span></li></ol></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page. 123&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;,&quot;html&quot;:&quot;page. 123&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page. 123</p></span></div></span></li></ol></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page. 123&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;,&amp;quot;group&amp;quot;:&amp;quot;&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page. 123</p></span></div></span></li></ol></li></ol></div>',
	innerWhitespace:
	[
		undefined,
		undefined
	],
	preserveAnnotationDomElements:
		true
};

// Expected Wikitext after change:
// <ref details="page. 123 NEW" name="book">Miller NEW</ref>
ve.dm.ConverterSubReferenceTestCases.cases[ 'Simple main ref including details ( edits on main and details )' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.simpleMainPlusDetails.data,
	body: ve.dm.ConverterSubReferenceTestCases.simpleMainPlusDetails.body,
	modify:
		( model ) => {
			model.commit( ve.dm.Transaction.static.deserialize( [ 25, [ [ { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' } ], '' ], 2 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 11, [ [ { type: 'internalItem', attributes: { originalHtml: 'page. 123' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'p', 'a', 'g', 'e', '.', ' ', '1', '2', '3', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: '/internalItem' } ], [ { type: 'internalItem', attributes: { originalHtml: 'page. 123' } }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', '.', ' ', '1', '2', '3', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'M', 'i', 'l', 'l', 'e', 'r', ' ', 'N', 'E', 'W', { type: '/paragraph' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 12, [ [ { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', '.', ' ', '1', '2', '3', { type: '/paragraph' } ], '' ], 16 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 11, [ [ { type: 'internalItem', attributes: { originalHtml: 'page. 123' } }, { type: '/internalItem' }, { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'M', 'i', 'l', 'l', 'e', 'r', ' ', 'N', 'E', 'W', { type: '/paragraph' }, { type: '/internalItem' } ], [ { type: 'internalItem', attributes: { originalHtml: 'page. 123' } }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', '.', ' ', '1', '2', '3', ' ', 'N', 'E', 'W', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'M', 'i', 'l', 'l', 'e', 'r', ' ', 'N', 'E', 'W', { type: '/paragraph' }, { type: '/internalItem' } ] ], 1 ] ) );
		},
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page. 123&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;,&quot;html&quot;:&quot;page. 123 NEW&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller NEW&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller NEW</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page. 123 NEW</span></li></ol></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page. 123&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;,&quot;html&quot;:&quot;page. 123 NEW&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference" about="#mwt1" id="cite_ref-2" rel="dc:references"><a href="./Example/MainPlusDetails#cite_note-2" id="mwAw"><span class="mw-reflink-text" id="mwBA"><span class="cite-bracket" id="mwBQ">[</span>1.1<span class="cite-bracket" id="mwBg">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller NEW&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot; data-parsoid=\\&quot;{}\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller NEW</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page. 123 NEW</span></li></ol></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page. 123&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;,&quot;html&quot;:&quot;page. 123 NEW&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller NEW&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller NEW</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page. 123 NEW</p></span></div></span></li></ol></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page. 123&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;,&amp;quot;group&amp;quot;:&amp;quot;&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller NEW</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page. 123 NEW</p></span></div></span></li></ol></li></ol></div>'
};

// Wikitext before:
// <ref details="page 1" name="book" />
// <ref details="page 2" name="book">Miller</ref>
// <ref name="book" />
ve.dm.ConverterSubReferenceTestCases.movingMainContentFromSub = {
	data:
		[
			{
				type: 'paragraph',
				internal: {
					whitespace: [
						undefined,
						undefined,
						undefined,
						'\n'
					]
				}
			},
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							details: 'page 1'
						},
						mainRef: 'book',
						body: {
							id: 'mw-reference-text-cite_note-2'
						}
					},
					originalMw: '{"name":"ref","attrs":{"details":"page 1"},"mainRef":"book","body":{"id":"mw-reference-text-cite_note-2"}}',
					listIndex: 0,
					listGroup: 'mwReference/',
					listKey: 'auto/0',
					refGroup: '',
					contentsUsed: false,
					mainRefKey: 'literal/book',
					refListItemId: 'mw-reference-text-cite_note-2'
				}
			},
			{
				type: '/mwReference'
			},
			'\n',
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							details: 'page 2'
						},
						body: {
							id: 'mw-reference-text-cite_note-3'
						},
						mainRef: 'book',
						mainBody: 'mw-reference-text-cite_note-book-1',
						isSubRefWithMainBody: 1
					},
					originalMw: '{"name":"ref","attrs":{"details":"page 2"},"body":{"id":"mw-reference-text-cite_note-3"},"mainRef":"book","mainBody":"mw-reference-text-cite_note-book-1","isSubRefWithMainBody":1}',
					listIndex: 1,
					listGroup: 'mwReference/',
					listKey: 'auto/1',
					refGroup: '',
					contentsUsed: true,
					mainRefKey: 'literal/book',
					refListItemId: 'mw-reference-text-cite_note-3'
				}
			},
			{
				type: '/mwReference'
			},
			'\n',
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							name: 'book'
						}
					},
					originalMw: '{"name":"ref","attrs":{"name":"book"}}',
					listIndex: 2,
					listGroup: 'mwReference/',
					listKey: 'literal/book',
					refGroup: '',
					contentsUsed: false
				}
			},
			{
				type: '/mwReference'
			},
			{
				type: '/paragraph'
			},
			{
				type: 'mwReferencesList',
				attributes: {
					mw: {
						name: 'references',
						attrs: {},
						autoGenerated: true,
						body: {
							html: "\n<sup typeof=\"mw:Extension/ref\" data-parsoid=\"{}\" data-mw='{\"name\":\"ref\",\"attrs\":{\"name\":\"book\",\"group\":\"\"},\"body\":{\"id\":\"mw-reference-text-cite_note-book-1\"},\"isSyntheticMainRef\":1}'>Miller</sup>"
						}
					},
					originalMw: "{\"name\":\"references\",\"attrs\":{},\"autoGenerated\":true,\"body\":{\"html\":\"\\n<sup typeof=\\\"mw:Extension/ref\\\" data-parsoid=\\\"{}\\\" data-mw='{\\\"name\\\":\\\"ref\\\",\\\"attrs\\\":{\\\"name\\\":\\\"book\\\",\\\"group\\\":\\\"\\\"},\\\"body\\\":{\\\"id\\\":\\\"mw-reference-text-cite_note-book-1\\\"},\\\"isSyntheticMainRef\\\":1}'>Miller</sup>\"}}",
					refGroup: '',
					listGroup: 'mwReference/',
					isResponsive: true,
					templateGenerated: false
				},
				internal: {
					whitespace: [
						'\n'
					]
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper',
					whitespace: [
						'\n'
					]
				}
			},
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							name: 'book',
							group: ''
						},
						body: {
							id: 'mw-reference-text-cite_note-book-1'
						},
						isSyntheticMainRef: 1
					},
					originalMw: '{"name":"ref","attrs":{"name":"book","group":""},"body":{"id":"mw-reference-text-cite_note-book-1"},"isSyntheticMainRef":1}',
					listIndex: 2,
					listGroup: 'mwReference/',
					listKey: 'literal/book',
					refGroup: '',
					contentsUsed: true,
					refListItemId: 'mw-reference-text-cite_note-book-1'
				}
			},
			{
				type: '/mwReference'
			},
			{
				type: '/paragraph'
			},
			{
				type: '/mwReferencesList'
			},
			{
				type: 'internalList'
			},
			{
				type: 'internalItem',
				attributes: {
					originalHtml: 'page 1'
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper'
				}
			},
			'p',
			'a',
			'g',
			'e',
			' ',
			'1',
			{
				type: '/paragraph'
			},
			{
				type: '/internalItem'
			},
			{
				type: 'internalItem',
				attributes: {
					originalHtml: 'page 2'
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper'
				}
			},
			'p',
			'a',
			'g',
			'e',
			' ',
			'2',
			{
				type: '/paragraph'
			},
			{
				type: '/internalItem'
			},
			{
				type: 'internalItem',
				attributes: {
					originalHtml: 'Miller'
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper'
				}
			},
			'M',
			'i',
			'l',
			'l',
			'e',
			'r',
			{
				type: '/paragraph'
			},
			{
				type: '/internalItem'
			},
			{
				type: '/internalList'
			}
		],
	body:
		"<p id=\"mwAg\"><sup about=\"#mwt1\" class=\"mw-ref reference\" id=\"cite_ref-2\" rel=\"dc:references\" typeof=\"mw:Extension/ref\" data-mw=\"{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}\"><a href=\"./Example/MainPlusDetails#cite_note-2\" id=\"mwAw\"><span class=\"mw-reflink-text\" id=\"mwBA\"><span class=\"cite-bracket\" id=\"mwBQ\">[</span>1.1<span class=\"cite-bracket\" id=\"mwBg\">]</span></span></a></sup>\n<sup about=\"#mwt2\" class=\"mw-ref reference\" id=\"cite_ref-3\" rel=\"dc:references\" typeof=\"mw:Extension/ref\" data-mw=\"{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}\"><a href=\"./Example/MainPlusDetails#cite_note-3\" id=\"mwBw\"><span class=\"mw-reflink-text\" id=\"mwCA\"><span class=\"cite-bracket\" id=\"mwCQ\">[</span>1.2<span class=\"cite-bracket\" id=\"mwCg\">]</span></span></a></sup>\n<sup about=\"#mwt3\" class=\"mw-ref reference\" id=\"cite_ref-book_1-0\" rel=\"dc:references\" typeof=\"mw:Extension/ref\" data-mw=\"{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}\"><a href=\"./Example/MainPlusDetails#cite_note-book-1\" id=\"mwCw\"><span class=\"mw-reflink-text\" id=\"mwDA\"><span class=\"cite-bracket\" id=\"mwDQ\">[</span>1<span class=\"cite-bracket\" id=\"mwDg\">]</span></span></a></sup></p>\n<div class=\"mw-references-wrap\" typeof=\"mw:Extension/references\" about=\"#mwt4\" data-mw=\"{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-parsoid=\\&quot;{}\\&quot; data-mw='{\\&quot;name\\&quot;:\\&quot;ref\\&quot;,\\&quot;attrs\\&quot;:{\\&quot;name\\&quot;:\\&quot;book\\&quot;,\\&quot;group\\&quot;:\\&quot;\\&quot;},\\&quot;body\\&quot;:{\\&quot;id\\&quot;:\\&quot;mw-reference-text-cite_note-book-1\\&quot;},\\&quot;isSyntheticMainRef\\&quot;:1}'&gt;Miller&lt;/sup&gt;&quot;}}\" id=\"mwDw\"><ol class=\"mw-references references\" id=\"mwEA\"><li about=\"#cite_note-book-1\" id=\"cite_note-book-1\" data-mw-footnote-number=\"1\"><span class=\"mw-cite-backlink\" id=\"mwEQ\"><a href=\"./Example/MainPlusDetails#cite_ref-book_1-0\" rel=\"mw:referencedBy\" id=\"mwEg\"><span class=\"mw-linkback-text\" id=\"mwEw\">↑ </span></a></span> <span id=\"mw-reference-text-cite_note-book-1\" class=\"mw-reference-text reference-text\">Miller</span><ol class=\"mw-subreference-list\" id=\"mwFA\"><li about=\"#cite_note-2\" id=\"cite_note-2\" data-mw-footnote-number=\"1.1\"><span class=\"mw-cite-backlink\" id=\"mwFQ\"><a href=\"./Example/MainPlusDetails#cite_ref-2\" rel=\"mw:referencedBy\" id=\"mwFg\"><span class=\"mw-linkback-text\" id=\"mwFw\">↑ </span></a></span> <span id=\"mw-reference-text-cite_note-2\" class=\"mw-reference-text reference-text\">page 1</span></li>\n<li about=\"#cite_note-3\" id=\"cite_note-3\" data-mw-footnote-number=\"1.2\"><span class=\"mw-cite-backlink\" id=\"mwGA\"><a href=\"./Example/MainPlusDetails#cite_ref-3\" rel=\"mw:referencedBy\" id=\"mwGQ\"><span class=\"mw-linkback-text\" id=\"mwGg\">↑ </span></a></span> <span id=\"mw-reference-text-cite_note-3\" class=\"mw-reference-text reference-text\">page 2</span></li>\n</ol></li>\n</ol></div>"
};

// Expect no Wikitext change
ve.dm.ConverterSubReferenceTestCases.cases[ 'Moving main content from subref' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.movingMainContentFromSub.data,
	body: ve.dm.ConverterSubReferenceTestCases.movingMainContentFromSub.body,
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}"></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-3">page 2</span></li></ol></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup about="#mwt1" class="mw-ref reference" id="cite_ref-2" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}"><a href="./Example/MainPlusDetails#cite_note-2" id="mwAw"><span class="mw-reflink-text" id="mwBA"><span class="cite-bracket" id="mwBQ">[</span>1.1<span class="cite-bracket" id="mwBg">]</span></span></a></sup>\n<sup about="#mwt2" class="mw-ref reference" id="cite_ref-3" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}"><a href="./Example/MainPlusDetails#cite_note-3" id="mwBw"><span class="mw-reflink-text" id="mwCA"><span class="cite-bracket" id="mwCQ">[</span>1.2<span class="cite-bracket" id="mwCg">]</span></span></a></sup>\n<sup about="#mwt3" class="mw-ref reference" id="cite_ref-book_1-0" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}"><a href="./Example/MainPlusDetails#cite_note-book-1" id="mwCw"><span class="mw-reflink-text" id="mwDA"><span class="cite-bracket" id="mwDQ">[</span>1<span class="cite-bracket" id="mwDg">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot; data-parsoid=\\&quot;{}\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-3">page 2</span></li></ol></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;,&quot;html&quot;:&quot;page 1&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;,&quot;html&quot;:&quot;page 2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li><li style="--footnote-number: &quot;1.2.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 2</p></span></div></span></li></ol></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>↵<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup>↵<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;,&amp;quot;group&amp;quot;:&amp;quot;&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li><li style="--footnote-number: &quot;1.2.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 2</p></span></div></span></li></ol></li></ol></div>',
	innerWhitespace:
		[
			undefined,
			undefined
		],
	preserveAnnotationDomElements:
		true
};

// Expected Wikitext after change
// <ref details="page 1" name="book" />
//
// <ref name="book">Miller</ref>
ve.dm.ConverterSubReferenceTestCases.cases[ 'Moving main content from subref ( delete subref providing the main )' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.movingMainContentFromSub.data,
	body: ve.dm.ConverterSubReferenceTestCases.movingMainContentFromSub.body,
	modify:
		( model ) => {
			model.commit( ve.dm.Transaction.static.deserialize( [ 4, [ [ { type: 'mwReference', attributes: { mw: { name: 'ref', attrs: { details: 'page 2' }, body: { id: 'mw-reference-text-cite_note-3' }, mainRef: 'book', mainBody: 'mw-reference-text-cite_note-book-1', isSubRefWithMainBody: 1 }, originalMw: '{"name":"ref","attrs":{"details":"page 2"},"body":{"id":"mw-reference-text-cite_note-3"},"mainRef":"book","mainBody":"mw-reference-text-cite_note-book-1","isSubRefWithMainBody":1}', listIndex: 1, listGroup: 'mwReference/', listKey: 'auto/1', refGroup: '', contentsUsed: true, mainRefKey: 'literal/book', refListItemId: 'mw-reference-text-cite_note-3' }, originalDomElementsHash: 'h67fe10d1b207f7de' }, { type: '/mwReference' } ], '' ], 42 ] ) );
		},
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>\n\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;html&quot;:&quot;Miller&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li></ol></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}" class="mw-ref reference" about="#mwt1" id="cite_ref-2" rel="dc:references"><a href="./Example/MainPlusDetails#cite_note-2" id="mwAw"><span class="mw-reflink-text" id="mwBA"><span class="cite-bracket" id="mwBQ">[</span>1.1<span class="cite-bracket" id="mwBg">]</span></span></a></sup>\n\n<sup about="#mwt3" class="mw-ref reference" id="cite_ref-book_1-0" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;html&quot;:&quot;Miller&quot;}}"><a href="./Example/MainPlusDetails#cite_note-book-1" id="mwCw"><span class="mw-reflink-text" id="mwDA"><span class="cite-bracket" id="mwDQ">[</span>1<span class="cite-bracket" id="mwDg">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot; data-parsoid=\\&quot;{}\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li></ol></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;,&quot;html&quot;:&quot;page 1&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>\n\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;html&quot;:&quot;Miller&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li></ol></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>↵↵<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;,&amp;quot;group&amp;quot;:&amp;quot;&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li></ol></li></ol></div>',
	innerWhitespace:
		[
			undefined,
			undefined
		],
	preserveAnnotationDomElements:
		true
};

// Expected Wikitext after change
// <ref name="book">Miller</ref>
ve.dm.ConverterSubReferenceTestCases.cases[ 'Moving main content from subref ( delete all subrefs )' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.movingMainContentFromSub.data,
	body: ve.dm.ConverterSubReferenceTestCases.movingMainContentFromSub.body,
	modify:
		( model ) => {
			model.commit( ve.dm.Transaction.static.deserialize( [ 1, [ [ { type: 'mwReference', attributes: { mw: { name: 'ref', attrs: { details: 'page 1' }, mainRef: 'book', body: { id: 'mw-reference-text-cite_note-2' } }, originalMw: '{"name":"ref","attrs":{"details":"page 1"},"mainRef":"book","body":{"id":"mw-reference-text-cite_note-2"}}', listIndex: 0, listGroup: 'mwReference/', listKey: 'auto/0', refGroup: '', contentsUsed: true, mainRefKey: 'literal/book', refListItemId: 'mw-reference-text-cite_note-2' }, originalDomElementsHash: 'h048318195d003e3e' }, { type: '/mwReference' }, '\n', { type: 'mwReference', attributes: { mw: { name: 'ref', attrs: { details: 'page 2' }, body: { id: 'mw-reference-text-cite_note-3' }, mainRef: 'book', mainBody: 'mw-reference-text-cite_note-book-1', isSubRefWithMainBody: 1 }, originalMw: '{"name":"ref","attrs":{"details":"page 2"},"body":{"id":"mw-reference-text-cite_note-3"},"mainRef":"book","mainBody":"mw-reference-text-cite_note-book-1","isSubRefWithMainBody":1}', listIndex: 1, listGroup: 'mwReference/', listKey: 'auto/1', refGroup: '', contentsUsed: true, mainRefKey: 'literal/book', refListItemId: 'mw-reference-text-cite_note-3' }, originalDomElementsHash: 'h67fe10d1b207f7de' }, { type: '/mwReference' }, '\n' ], '' ], 41 ] ) );
		},
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;html&quot;:&quot;Miller&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;html&quot;:&quot;Miller&quot;}}" class="mw-ref reference" about="#mwt3" id="cite_ref-book_1-0" rel="dc:references"><a href="./Example/MainPlusDetails#cite_note-book-1" id="mwCw"><span class="mw-reflink-text" id="mwDA"><span class="cite-bracket" id="mwDQ">[</span>1<span class="cite-bracket" id="mwDg">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot; data-parsoid=\\&quot;{}\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;html&quot;:&quot;Miller&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;,&amp;quot;group&amp;quot;:&amp;quot;&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span></li></ol></div>',
	innerWhitespace:
		[
			undefined,
			undefined
		],
	preserveAnnotationDomElements:
		true
};

// Expected Wikitext after change
// <ref details="page 1" name="book">Miller</ref>
ve.dm.ConverterSubReferenceTestCases.cases[ 'Moving main content from subref ( delete subref providing the main and other reuse )' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.movingMainContentFromSub.data,
	body: ve.dm.ConverterSubReferenceTestCases.movingMainContentFromSub.body,
	modify:
		( model ) => {
			model.commit( ve.dm.Transaction.static.deserialize( [ 3, [ [ '\n', { type: 'mwReference', attributes: { mw: { name: 'ref', attrs: { details: 'page 2' }, body: { id: 'mw-reference-text-cite_note-3' }, mainRef: 'book', mainBody: 'mw-reference-text-cite_note-book-1', isSubRefWithMainBody: 1 }, originalMw: '{"name":"ref","attrs":{"details":"page 2"},"body":{"id":"mw-reference-text-cite_note-3"},"mainRef":"book","mainBody":"mw-reference-text-cite_note-book-1","isSubRefWithMainBody":1}', listIndex: 1, listGroup: 'mwReference/', listKey: 'auto/1', refGroup: '', contentsUsed: true, mainRefKey: 'literal/book', refListItemId: 'mw-reference-text-cite_note-3' }, originalDomElementsHash: 'h67fe10d1b207f7de' }, { type: '/mwReference' }, '\n', { type: 'mwReference', attributes: { mw: { name: 'ref', attrs: { name: 'book' } }, originalMw: '{"name":"ref","attrs":{"name":"book"}}', listIndex: 2, listGroup: 'mwReference/', listKey: 'literal/book', refGroup: '', contentsUsed: false }, originalDomElementsHash: 'hdeef8b6886d0e53f' }, { type: '/mwReference' } ], '' ], 39 ] ) );
		},
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li></ol></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}" class="mw-ref reference" about="#mwt1" id="cite_ref-2" rel="dc:references"><a href="./Example/MainPlusDetails#cite_note-2" id="mwAw"><span class="mw-reflink-text" id="mwBA"><span class="cite-bracket" id="mwBQ">[</span>1.1<span class="cite-bracket" id="mwBg">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot; data-parsoid=\\&quot;{}\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li></ol></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;,&quot;html&quot;:&quot;page 1&quot;},&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li></ol></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;,&amp;quot;group&amp;quot;:&amp;quot;&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li></ol></li></ol></div>',
	innerWhitespace:
		[
			undefined,
			undefined
		],
	preserveAnnotationDomElements:
		true
};

// Wikitext before:
// <ref name="book">Miller</ref>
// <ref name="book" details="page 1" />
ve.dm.ConverterSubReferenceTestCases.deleteMainUsedBySub = {
	data:
		[
			{
				type: 'paragraph',
				internal: {
					whitespace: [
						undefined,
						undefined,
						undefined,
						'\n'
					]
				}
			},
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							name: 'book'
						},
						body: {
							id: 'mw-reference-text-cite_note-book-1'
						}
					},
					originalMw: '{"name":"ref","attrs":{"name":"book"},"body":{"id":"mw-reference-text-cite_note-book-1"}}',
					listIndex: 0,
					listGroup: 'mwReference/',
					listKey: 'literal/book',
					refGroup: '',
					contentsUsed: true,
					refListItemId: 'mw-reference-text-cite_note-book-1'
				}
			},
			{
				type: '/mwReference'
			},
			'\n',
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							details: 'page 1'
						},
						mainRef: 'book',
						body: {
							id: 'mw-reference-text-cite_note-2'
						}
					},
					originalMw: '{"name":"ref","attrs":{"details":"page 1"},"mainRef":"book","body":{"id":"mw-reference-text-cite_note-2"}}',
					listIndex: 1,
					listGroup: 'mwReference/',
					listKey: 'auto/0',
					refGroup: '',
					contentsUsed: false,
					mainRefKey: 'literal/book',
					refListItemId: 'mw-reference-text-cite_note-2'
				}
			},
			{
				type: '/mwReference'
			},
			{
				type: '/paragraph'
			},
			{
				type: 'mwReferencesList',
				attributes: {
					mw: {
						name: 'references',
						attrs: {},
						autoGenerated: true,
						body: {
							html: "\n<sup typeof=\"mw:Extension/ref\" data-parsoid=\"{}\" data-mw='{\"name\":\"ref\",\"attrs\":{\"name\":\"book\",\"group\":\"\"},\"body\":{\"id\":\"mw-reference-text-cite_note-book-1\"},\"isSyntheticMainRef\":1}'>Miller</sup>"
						}
					},
					originalMw: "{\"name\":\"references\",\"attrs\":{},\"autoGenerated\":true,\"body\":{\"html\":\"\\n<sup typeof=\\\"mw:Extension/ref\\\" data-parsoid=\\\"{}\\\" data-mw='{\\\"name\\\":\\\"ref\\\",\\\"attrs\\\":{\\\"name\\\":\\\"book\\\",\\\"group\\\":\\\"\\\"},\\\"body\\\":{\\\"id\\\":\\\"mw-reference-text-cite_note-book-1\\\"},\\\"isSyntheticMainRef\\\":1}'>Miller</sup>\"}}",
					refGroup: '',
					listGroup: 'mwReference/',
					isResponsive: true,
					templateGenerated: false
				},
				internal: {
					whitespace: [
						'\n'
					]
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper',
					whitespace: [
						'\n'
					]
				}
			},
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							name: 'book',
							group: ''
						},
						body: {
							id: 'mw-reference-text-cite_note-book-1'
						},
						isSyntheticMainRef: 1
					},
					originalMw: '{"name":"ref","attrs":{"name":"book","group":""},"body":{"id":"mw-reference-text-cite_note-book-1"},"isSyntheticMainRef":1}',
					listIndex: 0,
					listGroup: 'mwReference/',
					listKey: 'literal/book',
					refGroup: '',
					contentsUsed: false,
					refListItemId: 'mw-reference-text-cite_note-book-1'
				}
			},
			{
				type: '/mwReference'
			},
			{
				type: '/paragraph'
			},
			{
				type: '/mwReferencesList'
			},
			{
				type: 'internalList'
			},
			{
				type: 'internalItem',
				attributes: {
					originalHtml: 'Miller'
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper'
				}
			},
			'M',
			'i',
			'l',
			'l',
			'e',
			'r',
			{
				type: '/paragraph'
			},
			{
				type: '/internalItem'
			},
			{
				type: 'internalItem',
				attributes: {
					originalHtml: 'page 1'
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper'
				}
			},
			'p',
			'a',
			'g',
			'e',
			' ',
			'1',
			{
				type: '/paragraph'
			},
			{
				type: '/internalItem'
			},
			{
				type: '/internalList'
			}
		],
	body:
		"<p id=\"mwAg\"><sup about=\"#mwt1\" class=\"mw-ref reference\" id=\"cite_ref-book_1-0\" rel=\"dc:references\" typeof=\"mw:Extension/ref\" data-mw=\"{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}}\"><a href=\"./Example/MainPlusDetails#cite_note-book-1\" id=\"mwAw\"><span class=\"mw-reflink-text\" id=\"mwBA\"><span class=\"cite-bracket\" id=\"mwBQ\">[</span>1<span class=\"cite-bracket\" id=\"mwBg\">]</span></span></a></sup>\n<sup about=\"#mwt2\" class=\"mw-ref reference\" id=\"cite_ref-2\" rel=\"dc:references\" typeof=\"mw:Extension/ref\" data-mw=\"{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}\"><a href=\"./Example/MainPlusDetails#cite_note-2\" id=\"mwBw\"><span class=\"mw-reflink-text\" id=\"mwCA\"><span class=\"cite-bracket\" id=\"mwCQ\">[</span>1.1<span class=\"cite-bracket\" id=\"mwCg\">]</span></span></a></sup></p>\n<div class=\"mw-references-wrap\" typeof=\"mw:Extension/references\" about=\"#mwt3\" data-mw=\"{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-parsoid=\\&quot;{}\\&quot; data-mw='{\\&quot;name\\&quot;:\\&quot;ref\\&quot;,\\&quot;attrs\\&quot;:{\\&quot;name\\&quot;:\\&quot;book\\&quot;,\\&quot;group\\&quot;:\\&quot;\\&quot;},\\&quot;body\\&quot;:{\\&quot;id\\&quot;:\\&quot;mw-reference-text-cite_note-book-1\\&quot;},\\&quot;isSyntheticMainRef\\&quot;:1}'&gt;Miller&lt;/sup&gt;&quot;}}\" id=\"mwCw\"><ol class=\"mw-references references\" id=\"mwDA\"><li about=\"#cite_note-book-1\" id=\"cite_note-book-1\" data-mw-footnote-number=\"1\"><span class=\"mw-cite-backlink\" id=\"mwDQ\"><a href=\"./Example/MainPlusDetails#cite_ref-book_1-0\" rel=\"mw:referencedBy\" id=\"mwDg\"><span class=\"mw-linkback-text\" id=\"mwDw\">↑ </span></a></span> <span id=\"mw-reference-text-cite_note-book-1\" class=\"mw-reference-text reference-text\">Miller</span><ol class=\"mw-subreference-list\" id=\"mwEA\"><li about=\"#cite_note-2\" id=\"cite_note-2\" data-mw-footnote-number=\"1.1\"><span class=\"mw-cite-backlink\" id=\"mwEQ\"><a href=\"./Example/MainPlusDetails#cite_ref-2\" rel=\"mw:referencedBy\" id=\"mwEg\"><span class=\"mw-linkback-text\" id=\"mwEw\">↑ </span></a></span> <span id=\"mw-reference-text-cite_note-2\" class=\"mw-reference-text reference-text\">page 1</span></li>\n</ol></li>\n</ol></div>"
};

// Expect no Wikitext change
ve.dm.ConverterSubReferenceTestCases.cases[ 'Delete main used by sub' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.deleteMainUsedBySub.data,
	body: ve.dm.ConverterSubReferenceTestCases.deleteMainUsedBySub.body,
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}}"></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li></ol></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup about="#mwt1" class="mw-ref reference" id="cite_ref-book_1-0" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}}"><a href="./Example/MainPlusDetails#cite_note-book-1" id="mwAw"><span class="mw-reflink-text" id="mwBA"><span class="cite-bracket" id="mwBQ">[</span>1<span class="cite-bracket" id="mwBg">]</span></span></a></sup>\n<sup about="#mwt2" class="mw-ref reference" id="cite_ref-2" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}"><a href="./Example/MainPlusDetails#cite_note-2" id="mwBw"><span class="mw-reflink-text" id="mwCA"><span class="cite-bracket" id="mwCQ">[</span>1.1<span class="cite-bracket" id="mwCg">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot; data-parsoid=\\&quot;{}\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li></ol></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;html&quot;:&quot;Miller&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;,&quot;html&quot;:&quot;page 1&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li></ol></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup>↵<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;,&amp;quot;group&amp;quot;:&amp;quot;&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li></ol></li></ol></div>',
	innerWhitespace:
		[
			undefined,
			undefined
		],
	preserveAnnotationDomElements:
		true
};

// Expected Wikitext after change:
// <ref details="page 1" name="book" >Miller</ref>
ve.dm.ConverterSubReferenceTestCases.cases[ 'Delete main used by sub ( delete main ref )' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.deleteMainUsedBySub.data,
	body: ve.dm.ConverterSubReferenceTestCases.deleteMainUsedBySub.body,
	modify:
		( model ) => {
			model.commit( ve.dm.Transaction.static.deserialize( [ 1, [ [ { type: 'mwReference', attributes: { mw: { name: 'ref', attrs: { name: 'book' }, body: { id: 'mw-reference-text-cite_note-book-1' } }, originalMw: '{"name":"ref","attrs":{"name":"book"},"body":{"id":"mw-reference-text-cite_note-book-1"}}', listIndex: 0, listGroup: 'mwReference/', listKey: 'literal/book', refGroup: '', contentsUsed: true, refListItemId: 'mw-reference-text-cite_note-book-1' }, originalDomElementsHash: 'h056858c4de1a1101' }, { type: '/mwReference' }, '\n' ], '' ], 31 ] ) );
		},
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li></ol></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}" class="mw-ref reference" about="#mwt2" id="cite_ref-2" rel="dc:references"><a href="./Example/MainPlusDetails#cite_note-2" id="mwBw"><span class="mw-reflink-text" id="mwCA"><span class="cite-bracket" id="mwCQ">[</span>1.1<span class="cite-bracket" id="mwCg">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot; data-parsoid=\\&quot;{}\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li></ol></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;,&quot;html&quot;:&quot;page 1&quot;},&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li></ol></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;,&amp;quot;group&amp;quot;:&amp;quot;&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li></ol></li></ol></div>',
	innerWhitespace:
		[
			undefined,
			undefined
		],
	preserveAnnotationDomElements:
		true
};

// Wikitext before:
// <ref details="page 1" name="book">Miller</ref>
// <ref details="page 2" name="book">Miller</ref>
ve.dm.ConverterSubReferenceTestCases.mainPlusDetailsWithDuplicateMainContent = {
	data:
		[
			{
				type: 'paragraph',
				internal: {
					whitespace: [
						undefined,
						undefined,
						undefined,
						'\n'
					]
				}
			},
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							details: 'page 1'
						},
						body: {
							id: 'mw-reference-text-cite_note-2'
						},
						mainRef: 'book',
						mainBody: 'mw-reference-text-cite_note-book-1',
						isSubRefWithMainBody: 1
					},
					originalMw: '{"name":"ref","attrs":{"details":"page 1"},"body":{"id":"mw-reference-text-cite_note-2"},"mainRef":"book","mainBody":"mw-reference-text-cite_note-book-1","isSubRefWithMainBody":1}',
					listIndex: 0,
					listGroup: 'mwReference/',
					listKey: 'auto/0',
					refGroup: '',
					contentsUsed: true,
					mainRefKey: 'literal/book',
					refListItemId: 'mw-reference-text-cite_note-2'
				}
			},
			{
				type: '/mwReference'
			},
			'\n',
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							details: 'page 2'
						},
						body: {
							id: 'mw-reference-text-cite_note-3'
						},
						mainRef: 'book',
						mainBody: 'mw-reference-text-cite_note-book-1',
						isSubRefWithMainBody: 1
					},
					originalMw: '{"name":"ref","attrs":{"details":"page 2"},"body":{"id":"mw-reference-text-cite_note-3"},"mainRef":"book","mainBody":"mw-reference-text-cite_note-book-1","isSubRefWithMainBody":1}',
					listIndex: 1,
					listGroup: 'mwReference/',
					listKey: 'auto/1',
					refGroup: '',
					contentsUsed: true,
					mainRefKey: 'literal/book',
					refListItemId: 'mw-reference-text-cite_note-3'
				}
			},
			{
				type: '/mwReference'
			},
			{
				type: '/paragraph'
			},
			{
				type: 'mwReferencesList',
				attributes: {
					mw: {
						name: 'references',
						attrs: {},
						autoGenerated: true,
						body: {
							html: "\n<sup typeof=\"mw:Extension/ref\" data-parsoid=\"{}\" data-mw='{\"name\":\"ref\",\"attrs\":{\"name\":\"book\",\"group\":\"\"},\"body\":{\"id\":\"mw-reference-text-cite_note-book-1\"},\"isSyntheticMainRef\":1}'>Miller</sup>"
						}
					},
					originalMw: "{\"name\":\"references\",\"attrs\":{},\"autoGenerated\":true,\"body\":{\"html\":\"\\n<sup typeof=\\\"mw:Extension/ref\\\" data-parsoid=\\\"{}\\\" data-mw='{\\\"name\\\":\\\"ref\\\",\\\"attrs\\\":{\\\"name\\\":\\\"book\\\",\\\"group\\\":\\\"\\\"},\\\"body\\\":{\\\"id\\\":\\\"mw-reference-text-cite_note-book-1\\\"},\\\"isSyntheticMainRef\\\":1}'>Miller</sup>\"}}",
					refGroup: '',
					listGroup: 'mwReference/',
					isResponsive: true,
					templateGenerated: false
				},
				internal: {
					whitespace: [
						'\n'
					]
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper',
					whitespace: [
						'\n'
					]
				}
			},
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							name: 'book',
							group: ''
						},
						body: {
							id: 'mw-reference-text-cite_note-book-1'
						},
						isSyntheticMainRef: 1
					},
					originalMw: '{"name":"ref","attrs":{"name":"book","group":""},"body":{"id":"mw-reference-text-cite_note-book-1"},"isSyntheticMainRef":1}',
					listIndex: 2,
					listGroup: 'mwReference/',
					listKey: 'literal/book',
					refGroup: '',
					contentsUsed: true,
					refListItemId: 'mw-reference-text-cite_note-book-1'
				}
			},
			{
				type: '/mwReference'
			},
			{
				type: '/paragraph'
			},
			{
				type: '/mwReferencesList'
			},
			{
				type: 'internalList'
			},
			{
				type: 'internalItem',
				attributes: {
					originalHtml: 'page 1'
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper'
				}
			},
			'p',
			'a',
			'g',
			'e',
			' ',
			'1',
			{
				type: '/paragraph'
			},
			{
				type: '/internalItem'
			},
			{
				type: 'internalItem',
				attributes: {
					originalHtml: 'page 2'
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper'
				}
			},
			'p',
			'a',
			'g',
			'e',
			' ',
			'2',
			{
				type: '/paragraph'
			},
			{
				type: '/internalItem'
			},
			{
				type: 'internalItem',
				attributes: {
					originalHtml: 'Miller'
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper'
				}
			},
			'M',
			'i',
			'l',
			'l',
			'e',
			'r',
			{
				type: '/paragraph'
			},
			{
				type: '/internalItem'
			},
			{
				type: '/internalList'
			}
		],
	body:
		"<p id=\"mwAg\"><sup about=\"#mwt1\" class=\"mw-ref reference\" id=\"cite_ref-2\" rel=\"dc:references\" typeof=\"mw:Extension/ref\" data-mw=\"{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}\"><a href=\"./MainPlusDetails#cite_note-2\" id=\"mwAw\"><span class=\"mw-reflink-text\" id=\"mwBA\"><span class=\"cite-bracket\" id=\"mwBQ\">[</span>1.1<span class=\"cite-bracket\" id=\"mwBg\">]</span></span></a></sup>\n<sup about=\"#mwt2\" class=\"mw-ref reference\" id=\"cite_ref-3\" rel=\"dc:references\" typeof=\"mw:Extension/ref\" data-mw=\"{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}\"><a href=\"./MainPlusDetails#cite_note-3\" id=\"mwBw\"><span class=\"mw-reflink-text\" id=\"mwCA\"><span class=\"cite-bracket\" id=\"mwCQ\">[</span>1.2<span class=\"cite-bracket\" id=\"mwCg\">]</span></span></a></sup></p>\n<div class=\"mw-references-wrap\" typeof=\"mw:Extension/references\" about=\"#mwt3\" data-mw=\"{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-parsoid=\\&quot;{}\\&quot; data-mw='{\\&quot;name\\&quot;:\\&quot;ref\\&quot;,\\&quot;attrs\\&quot;:{\\&quot;name\\&quot;:\\&quot;book\\&quot;,\\&quot;group\\&quot;:\\&quot;\\&quot;},\\&quot;body\\&quot;:{\\&quot;id\\&quot;:\\&quot;mw-reference-text-cite_note-book-1\\&quot;},\\&quot;isSyntheticMainRef\\&quot;:1}'&gt;Miller&lt;/sup&gt;&quot;}}\" id=\"mwCw\"><ol class=\"mw-references references\" id=\"mwDA\"><li about=\"#cite_note-book-1\" id=\"cite_note-book-1\"><span rel=\"mw:referencedBy\" class=\"mw-cite-backlink\" id=\"mwDQ\"></span> <span id=\"mw-reference-text-cite_note-book-1\" class=\"mw-reference-text reference-text\">Miller</span><ol class=\"mw-subreference-list\" id=\"mwDg\"><li about=\"#cite_note-2\" id=\"cite_note-2\"><span class=\"mw-cite-backlink\" id=\"mwDw\"><a href=\"./MainPlusDetails#cite_ref-2\" rel=\"mw:referencedBy\" id=\"mwEA\"><span class=\"mw-linkback-text\" id=\"mwEQ\">↑ </span></a></span> <span id=\"mw-reference-text-cite_note-2\" class=\"mw-reference-text reference-text\">page 1</span></li>\n<li about=\"#cite_note-3\" id=\"cite_note-3\"><span class=\"mw-cite-backlink\" id=\"mwEg\"><a href=\"./MainPlusDetails#cite_ref-3\" rel=\"mw:referencedBy\" id=\"mwEw\"><span class=\"mw-linkback-text\" id=\"mwFA\">↑ </span></a></span> <span id=\"mw-reference-text-cite_note-3\" class=\"mw-reference-text reference-text\">page 2</span></li>\n</ol></li>\n</ol></div>"
};

// Expect no Wikitext change
ve.dm.ConverterSubReferenceTestCases.cases[ 'Main plus details with duplicate main content' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.mainPlusDetailsWithDuplicateMainContent.data,
	body: ve.dm.ConverterSubReferenceTestCases.mainPlusDetailsWithDuplicateMainContent.body,
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-3">page 2</span></li></ol></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference" about="#mwt1" id="cite_ref-2" rel="dc:references"><a href="./MainPlusDetails#cite_note-2" id="mwAw"><span class="mw-reflink-text" id="mwBA"><span class="cite-bracket" id="mwBQ">[</span>1.1<span class="cite-bracket" id="mwBg">]</span></span></a></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference" about="#mwt2" id="cite_ref-3" rel="dc:references"><a href="./MainPlusDetails#cite_note-3" id="mwBw"><span class="mw-reflink-text" id="mwCA"><span class="cite-bracket" id="mwCQ">[</span>1.2<span class="cite-bracket" id="mwCg">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot; data-parsoid=\\&quot;{}\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-3">page 2</span></li></ol></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;,&quot;html&quot;:&quot;page 1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;,&quot;html&quot;:&quot;page 2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li><li style="--footnote-number: &quot;1.2.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 2</p></span></div></span></li></ol></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>↵<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;,&amp;quot;group&amp;quot;:&amp;quot;&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li><li style="--footnote-number: &quot;1.2.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 2</p></span></div></span></li></ol></li></ol></div>',
	innerWhitespace:
		[
			undefined,
			undefined
		],
	preserveAnnotationDomElements:
		true
};

// Expected Wikitext after change:
// <ref details="page 1" name="book">Miller NEW</ref>
// <ref details="page 2" name="book">Miller NEW</ref>
ve.dm.ConverterSubReferenceTestCases.cases[ 'Main plus details with duplicate main content ( edit main )' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.mainPlusDetailsWithDuplicateMainContent.data,
	body: ve.dm.ConverterSubReferenceTestCases.mainPlusDetailsWithDuplicateMainContent.body,
	modify:
		( model ) => {
			model.commit( ve.dm.Transaction.static.deserialize( [ 35, [ [ { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' } ], '' ], 2 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 14, [ [ { type: 'internalItem', attributes: { originalHtml: 'page 1' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'p', 'a', 'g', 'e', ' ', '1', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem', attributes: { originalHtml: 'page 2' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'p', 'a', 'g', 'e', ' ', '2', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: '/internalItem' } ], [ { type: 'internalItem', attributes: { originalHtml: 'page 1' } }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', ' ', '1', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem', attributes: { originalHtml: 'page 2' } }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', ' ', '2', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'M', 'i', 'l', 'l', 'e', 'r', ' ', 'N', 'E', 'W', { type: '/paragraph' }, { type: '/internalItem' } ] ], 1 ] ) );
		},
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller NEW&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller NEW</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-3">page 2</span></li></ol></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference" about="#mwt1" id="cite_ref-2" rel="dc:references"><a href="./MainPlusDetails#cite_note-2" id="mwAw"><span class="mw-reflink-text" id="mwBA"><span class="cite-bracket" id="mwBQ">[</span>1.1<span class="cite-bracket" id="mwBg">]</span></span></a></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference" about="#mwt2" id="cite_ref-3" rel="dc:references"><a href="./MainPlusDetails#cite_note-3" id="mwBw"><span class="mw-reflink-text" id="mwCA"><span class="cite-bracket" id="mwCQ">[</span>1.2<span class="cite-bracket" id="mwCg">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller NEW&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot; data-parsoid=\\&quot;{}\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller NEW</span><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-2">page 1</span></li><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-3">page 2</span></li></ol></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;,&quot;html&quot;:&quot;page 1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>\n<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;,&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;,&quot;html&quot;:&quot;page 2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller NEW&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller NEW</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li><li style="--footnote-number: &quot;1.2.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 2</p></span></div></span></li></ol></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 1&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-2&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup>↵<sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;details&quot;:&quot;page 2&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-3&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;isSubRefWithMainBody&quot;:1}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;\\n&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;,&amp;quot;group&amp;quot;:&amp;quot;&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:1}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller NEW</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li><li style="--footnote-number: &quot;1.2.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 2</p></span></div></span></li></ol></li></ol></div>',
	innerWhitespace:
		[
			undefined,
			undefined
		],
	preserveAnnotationDomElements:
		true
};

// Wikitext:
// <ref name="book" /><ref name="book">Miller</ref>
ve.dm.ConverterSubReferenceTestCases.twoMainRefsWithContent = {
	data:
		[
			{
				type: 'paragraph',
				internal: {
					whitespace: [
						undefined,
						undefined,
						undefined,
						'\n'
					]
				}
			},
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							name: 'book'
						}
					},
					originalMw: '{"name":"ref","attrs":{"name":"book"}}',
					listIndex: 0,
					listGroup: 'mwReference/',
					listKey: 'literal/book',
					refGroup: '',
					contentsUsed: false
				}
			},
			{
				type: '/mwReference'
			},
			{
				type: 'mwReference',
				attributes: {
					mw: {
						name: 'ref',
						attrs: {
							name: 'book'
						},
						body: {
							id: 'mw-reference-text-cite_note-book-1'
						}
					},
					originalMw: '{"name":"ref","attrs":{"name":"book"},"body":{"id":"mw-reference-text-cite_note-book-1"}}',
					listIndex: 0,
					listGroup: 'mwReference/',
					listKey: 'literal/book',
					refGroup: '',
					contentsUsed: true,
					refListItemId: 'mw-reference-text-cite_note-book-1'
				}
			},
			{
				type: '/mwReference'
			},
			{
				type: '/paragraph'
			},
			{
				type: 'mwReferencesList',
				attributes: {
					mw: {
						name: 'references',
						attrs: {},
						autoGenerated: true
					},
					originalMw: '{"name":"references","attrs":{},"autoGenerated":true}',
					refGroup: '',
					listGroup: 'mwReference/',
					isResponsive: true,
					templateGenerated: false
				},
				internal: {
					whitespace: [
						'\n'
					]
				}
			},
			{
				type: '/mwReferencesList'
			},
			{
				type: 'internalList'
			},
			{
				type: 'internalItem',
				attributes: {
					originalHtml: 'Miller'
				}
			},
			{
				type: 'paragraph',
				internal: {
					generated: 'wrapper'
				}
			},
			'M',
			'i',
			'l',
			'l',
			'e',
			'r',
			{
				type: '/paragraph'
			},
			{
				type: '/internalItem'
			},
			{
				type: '/internalList'
			}
		],
	body:
		'<p id="mwAg"><sup about="#mwt1" class="mw-ref reference" id="cite_ref-book_1-0" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}"><a href="./Example/MainPlusDetails#cite_note-book-1" id="mwAw"><span class="mw-reflink-text" id="mwBA"><span class="cite-bracket" id="mwBQ">[</span>1<span class="cite-bracket" id="mwBg">]</span></span></a></sup><sup about="#mwt2" class="mw-ref reference" id="cite_ref-book_1-1" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}}"><a href="./Example/MainPlusDetails#cite_note-book-1" id="mwBw"><span class="mw-reflink-text" id="mwCA"><span class="cite-bracket" id="mwCQ">[</span>1<span class="cite-bracket" id="mwCg">]</span></span></a></sup></p>\n<div class="mw-references-wrap" typeof="mw:Extension/references" about="#mwt3" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true}" id="mwCw"><ol class="mw-references references" id="mwDA"><li about="#cite_note-book-1" id="cite_note-book-1" data-mw-footnote-number="1"><span rel="mw:referencedBy" class="mw-cite-backlink" id="mwDQ"><a href="./Example/MainPlusDetails#cite_ref-book_1-0" id="mwDg"><span class="mw-linkback-text" id="mwDw">1 </span></a><a href="./Example/MainPlusDetails#cite_ref-book_1-1" id="mwEA"><span class="mw-linkback-text" id="mwEQ">2 </span></a></span> <span id="mw-reference-text-cite_note-book-1" class="mw-reference-text reference-text">Miller</span></li>\n</ol></div>'
};

// Expect no Wikitext change
ve.dm.ConverterSubReferenceTestCases.cases[ 'Two main refs with content' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.twoMainRefsWithContent.data,
	body: ve.dm.ConverterSubReferenceTestCases.twoMainRefsWithContent.body,
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}"></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}}"></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup about="#mwt1" class="mw-ref reference" id="cite_ref-book_1-0" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}"><a href="./Example/MainPlusDetails#cite_note-book-1" id="mwAw"><span class="mw-reflink-text" id="mwBA"><span class="cite-bracket" id="mwBQ">[</span>1<span class="cite-bracket" id="mwBg">]</span></span></a></sup><sup about="#mwt2" class="mw-ref reference" id="cite_ref-book_1-1" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}}"><a href="./Example/MainPlusDetails#cite_note-book-1" id="mwBw"><span class="mw-reflink-text" id="mwCA"><span class="cite-bracket" id="mwCQ">[</span>1<span class="cite-bracket" id="mwCg">]</span></span></a></sup></p>\n<div class="mw-references-wrap" typeof="mw:Extension/references" about="#mwt3" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true}" id="mwCw"><ol class="mw-references references" id="mwDA"><li about="#cite_note-book-1" id="cite_note-book-1" data-mw-footnote-number="1"><span rel="mw:referencedBy" class="mw-cite-backlink" id="mwDQ"><a href="./Example/MainPlusDetails#cite_ref-book_1-0" id="mwDg"><span class="mw-linkback-text" id="mwDw">1 </span></a><a href="./Example/MainPlusDetails#cite_ref-book_1-1" id="mwEA"><span class="mw-linkback-text" id="mwEQ">2 </span></a></span> <span id="mw-reference-text-cite_note-book-1" class="mw-reference-text reference-text">Miller</span></li>\n</ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;html&quot;:&quot;Miller&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"><a><span class="mw-linkback-text">1 </span></a><a><span class="mw-linkback-text">2 </span></a></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"><a><span class="mw-linkback-text">1 </span></a><a><span class="mw-linkback-text">2 </span></a></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span></li></ol></div>',
	innerWhitespace:
		[
			undefined,
			undefined
		],
	preserveAnnotationDomElements:
		true
};

// Expected Wikitext after change:
// <ref details="page 1" name="book" /><ref details="page 2" name="book">Miller</ref>
ve.dm.ConverterSubReferenceTestCases.cases[ 'Two main refs with content ( convert both to sub-refs )' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.twoMainRefsWithContent.data,
	body: ve.dm.ConverterSubReferenceTestCases.twoMainRefsWithContent.body,
	modify:
		( model ) => {
			model.commit( ve.dm.Transaction.static.deserialize( [ 7, { type: 'replace', remove: [], insert: [ { type: 'paragraph', internal: { generated: 'wrapper' } }, { type: 'mwReference', attributes: { mw: { name: 'ref', attrs: { name: 'book' }, body: { id: 'mw-reference-text-cite_note-book-1' }, isSyntheticMainRef: true }, originalMw: '{"name":"ref","attrs":{"name":"book"},"body":{"id":"mw-reference-text-cite_note-book-1"}}', listIndex: 0, listGroup: 'mwReference/', listKey: 'literal/book', refGroup: '', contentsUsed: true, refListItemId: 'mw-reference-text-cite_note-book-1' }, originalDomElementsHash: 0.06432979342051748 }, { type: '/mwReference' }, { type: '/paragraph' } ], insertedDataOffset: 1, insertedDataLength: 2 }, 13 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 3, [ [ { type: 'mwReference', attributes: { mw: { name: 'ref', attrs: { name: 'book' }, body: { id: 'mw-reference-text-cite_note-book-1' } }, originalMw: '{"name":"ref","attrs":{"name":"book"},"body":{"id":"mw-reference-text-cite_note-book-1"}}', listIndex: 0, listGroup: 'mwReference/', listKey: 'literal/book', refGroup: '', contentsUsed: true, refListItemId: 'mw-reference-text-cite_note-book-1' }, originalDomElementsHash: 'h228a23fdc392523a' }, { type: '/mwReference' } ], '' ], 19 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 21, [ '', [ { type: 'internalItem' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 11, [ [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: '/internalItem' } ], [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', ' ', '2', { type: '/paragraph' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 3, [ '', [ { type: 'mwReference', attributes: { mainRefKey: 'literal/book', listKey: 'auto/0', listGroup: 'mwReference/', listIndex: 1, refGroup: '', contentsUsed: true }, originalDomElementsHash: 0.041667351849856704 }, { type: '/mwReference' } ] ], 29 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 1, [ [ { type: 'mwReference', attributes: { mw: { name: 'ref', attrs: { name: 'book' } }, originalMw: '{"name":"ref","attrs":{"name":"book"}}', listIndex: 0, listGroup: 'mwReference/', listKey: 'literal/book', refGroup: '', contentsUsed: false }, originalDomElementsHash: 'hdd53161d4c3c6168' }, { type: '/mwReference' } ], '' ], 31 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 31, [ '', [ { type: 'internalItem' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 11, [ [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', ' ', '2', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: '/internalItem' } ], [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', ' ', '2', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', ' ', '1', { type: '/paragraph' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 1, [ '', [ { type: 'mwReference', attributes: { mainRefKey: 'literal/book', listKey: 'auto/1', listGroup: 'mwReference/', listIndex: 2, refGroup: '' }, originalDomElementsHash: 0.8122960516933909 }, { type: '/mwReference' } ] ], 41 ] ) );
		},
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 1&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 2&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:true}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref">page 1</span></li><li><span typeof="mw:Extension/ref">page 2</span></li></ol></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 1&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 2&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:true}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span><ol><li><span typeof="mw:Extension/ref">page 1</span></li><li><span typeof="mw:Extension/ref">page 2</span></li></ol></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 1&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;book&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 2&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;,&amp;quot;html&amp;quot;:&amp;quot;Miller&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:true}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li><li style="--footnote-number: &quot;1.2.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 2</p></span></div></span></li></ol></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;book&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;id&amp;quot;:&amp;quot;mw-reference-text-cite_note-book-1&amp;quot;},&amp;quot;isSyntheticMainRef&amp;quot;:true}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;1&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span><ol><li style="--footnote-number: &quot;1.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 1</p></span></div></span></li><li style="--footnote-number: &quot;1.2.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 2</p></span></div></span></li></ol></li></ol></div>',
	innerWhitespace:
		[
			undefined,
			undefined
		],
	preserveAnnotationDomElements:
		true
};

// Expected Wikitext after change:
// <ref name="book" /><ref name="book">Miller</ref><ref name=":0" details="page 3">Smith</ref><ref name=":0" details="page 4" />
ve.dm.ConverterSubReferenceTestCases.cases[ 'Two main refs with content ( adding two fresh sub-refs )' ] = {
	data: ve.dm.ConverterSubReferenceTestCases.twoMainRefsWithContent.data,
	body: ve.dm.ConverterSubReferenceTestCases.twoMainRefsWithContent.body,
	modify:
		( model ) => {
			model.commit( ve.dm.Transaction.static.deserialize( [ 19, [ '', [ { type: 'internalItem' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 9, [ [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: '/internalItem' } ], [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'S', 'm', 'i', 't', 'h', { type: '/paragraph' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 5, [ '', [ { type: 'mwReference', attributes: { mainRefKey: null, listKey: 'auto/1', listGroup: 'mwReference/', listIndex: 1, refGroup: '' }, originalDomElementsHash: 0.9518735179220084 }, { type: '/mwReference' } ] ], 24 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 30, [ '', [ { type: 'internalItem' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 11, [ [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'S', 'm', 'i', 't', 'h', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: '/internalItem' } ], [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'S', 'm', 'i', 't', 'h', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, { type: '/paragraph' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 7, [ '', [ { type: 'mwReference', attributes: { mainRefKey: null, listKey: 'auto/2', listGroup: 'mwReference/', listIndex: 2, refGroup: '', placeholder: true }, originalDomElementsHash: 0.08294908238257814 }, { type: '/mwReference' } ] ], 28 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 7, [ [ { type: 'mwReference', attributes: { mainRefKey: null, listKey: 'auto/2', listGroup: 'mwReference/', listIndex: 2, refGroup: '', placeholder: true }, originalDomElementsHash: 0.08294908238257814 }, { type: '/mwReference' } ], '' ], 28 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 7, [ '', [ { type: 'mwReference', attributes: { mainRefKey: null, listKey: 'auto/1', listGroup: 'mwReference/', listIndex: 1, refGroup: '' }, originalDomElementsHash: 0.8304465083774507 }, { type: '/mwReference' } ] ], 28 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 11, { type: 'replace', remove: [], insert: [ { type: 'paragraph', internal: { generated: 'wrapper' } }, { type: 'mwReference', attributes: { mainRefKey: null, listKey: 'auto/1', listGroup: 'mwReference/', listIndex: 1, refGroup: '', mw: { isSyntheticMainRef: true }, contentsUsed: true, refListItemId: 'cite_note-mwReference/-auto/1-1' }, originalDomElementsHash: 0.7602596705852241 }, { type: '/mwReference' }, { type: '/paragraph' } ], insertedDataOffset: 1, insertedDataLength: 2 }, 26 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 7, [ [ { type: 'mwReference', attributes: { mainRefKey: null, listKey: 'auto/1', listGroup: 'mwReference/', listIndex: 1, refGroup: '' }, originalDomElementsHash: 0.8304465083774507 }, { type: '/mwReference' } ], '' ], 32 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 38, [ '', [ { type: 'internalItem' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 15, [ [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'S', 'm', 'i', 't', 'h', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: '/internalItem' } ], [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'S', 'm', 'i', 't', 'h', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', ' ', '4', { type: '/paragraph' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 7, [ '', [ { type: 'mwReference', attributes: { mainRefKey: 'auto/1', listKey: 'auto/3', listGroup: 'mwReference/', listIndex: 3, refGroup: '' }, originalDomElementsHash: 0.5643696383981799 }, { type: '/mwReference' } ] ], 42 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 5, [ [ { type: 'mwReference', attributes: { mainRefKey: null, listKey: 'auto/1', listGroup: 'mwReference/', listIndex: 1, refGroup: '' }, originalDomElementsHash: 0.9518735179220084 }, { type: '/mwReference' } ], '' ], 44 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 48, [ '', [ { type: 'internalItem' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 15, [ [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'S', 'm', 'i', 't', 'h', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', ' ', '4', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: '/internalItem' } ], [ { type: 'internalItem', attributes: { originalHtml: 'Miller' } }, { type: 'paragraph', internal: { generated: 'wrapper', metaItems: [] } }, 'M', 'i', 'l', 'l', 'e', 'r', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'S', 'm', 'i', 't', 'h', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', ' ', '4', { type: '/paragraph' }, { type: '/internalItem' }, { type: 'internalItem' }, { type: 'paragraph', internal: { generated: 'wrapper' } }, 'p', 'a', 'g', 'e', ' ', '3', { type: '/paragraph' }, { type: '/internalItem' } ] ], 1 ] ) );
			model.commit( ve.dm.Transaction.static.deserialize( [ 5, [ '', [ { type: 'mwReference', attributes: { mainRefKey: 'auto/1', listKey: 'auto/4', listGroup: 'mwReference/', listIndex: 4, refGroup: '' }, originalDomElementsHash: 0.3327912724505754 }, { type: '/mwReference' } ] ], 54 ] ) );
		},
	fromDataBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}"></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}}"></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;:0&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;:0&quot;,&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;cite_note-mwReference/-auto/1-1&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 3&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>2.1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;:0&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;:0&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 4&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>2.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;isSyntheticMainRef&amp;quot;:true,&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;:0&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;html&amp;quot;:&amp;quot;Smith&amp;quot;}}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;2&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span></li><li><span typeof="mw:Extension/ref" id="cite_note-mwReference/-auto/1-1">Smith</span><ol><li><span typeof="mw:Extension/ref">page 3</span></li><li><span typeof="mw:Extension/ref">page 4</span></li></ol></li></ol></div>',
	normalizedBody:
		'<p id="mwAg"><sup about="#mwt1" class="mw-ref reference" id="cite_ref-book_1-0" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}"><a href="./Example/MainPlusDetails#cite_note-book-1" id="mwAw"><span class="mw-reflink-text" id="mwBA"><span class="cite-bracket" id="mwBQ">[</span>1<span class="cite-bracket" id="mwBg">]</span></span></a></sup><sup about="#mwt2" class="mw-ref reference" id="cite_ref-book_1-1" rel="dc:references" typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}}"><a href="./Example/MainPlusDetails#cite_note-book-1" id="mwBw"><span class="mw-reflink-text" id="mwCA"><span class="cite-bracket" id="mwCQ">[</span>1<span class="cite-bracket" id="mwCg">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;:0&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;:0&quot;,&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;cite_note-mwReference/-auto/1-1&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 3&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>2.1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;:0&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;:0&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 4&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>2.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;isSyntheticMainRef&amp;quot;:true,&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;:0&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;html&amp;quot;:&amp;quot;Smith&amp;quot;}}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;2&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol><li><span typeof="mw:Extension/ref" id="mw-reference-text-cite_note-book-1">Miller</span></li><li><span typeof="mw:Extension/ref" id="cite_note-mwReference/-auto/1-1">Smith</span><ol><li><span typeof="mw:Extension/ref">page 3</span></li><li><span typeof="mw:Extension/ref">page 4</span></li></ol></li></ol></div>',
	clipboardBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;,&quot;html&quot;:&quot;Miller&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;:0&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;:0&quot;,&quot;isSubRefWithMainBody&quot;:&quot;1&quot;,&quot;mainBody&quot;:&quot;cite_note-mwReference/-auto/1-1&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 3&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>2.1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;:0&quot;,&quot;details&quot;:&quot;1&quot;},&quot;mainRef&quot;:&quot;:0&quot;,&quot;body&quot;:{&quot;html&quot;:&quot;page 4&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>2.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;isSyntheticMainRef&amp;quot;:true,&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;,&amp;quot;attrs&amp;quot;:{&amp;quot;name&amp;quot;:&amp;quot;:0&amp;quot;},&amp;quot;body&amp;quot;:{&amp;quot;html&amp;quot;:&amp;quot;Smith&amp;quot;}}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;2&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"><a><span class="mw-linkback-text">1 </span></a><a><span class="mw-linkback-text">2 </span></a></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span></li><li style="--footnote-number: &quot;2.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Smith</p></span></div></span><ol><li style="--footnote-number: &quot;2.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 3</p></span></div></span></li><li style="--footnote-number: &quot;2.2.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 4</p></span></div></span></li></ol></li></ol></div>',
	previewBody:
		'<p><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;,&quot;attrs&quot;:{&quot;name&quot;:&quot;book&quot;},&quot;body&quot;:{&quot;id&quot;:&quot;mw-reference-text-cite_note-book-1&quot;}}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>2.1<span class="cite-bracket">]</span></span></a></sup><sup typeof="mw:Extension/ref" data-mw="{&quot;name&quot;:&quot;ref&quot;}" class="mw-ref reference"><a><span class="mw-reflink-text"><span class="cite-bracket">[</span>2.2<span class="cite-bracket">]</span></span></a></sup></p>\n<div typeof="mw:Extension/references" data-mw="{&quot;name&quot;:&quot;references&quot;,&quot;attrs&quot;:{},&quot;autoGenerated&quot;:true,&quot;body&quot;:{&quot;html&quot;:&quot;&lt;sup typeof=\\&quot;mw:Extension/ref\\&quot; data-mw=\\&quot;{&amp;quot;isSyntheticMainRef&amp;quot;:true,&amp;quot;name&amp;quot;:&amp;quot;ref&amp;quot;}\\&quot; class=\\&quot;mw-ref reference\\&quot;&gt;&lt;a&gt;&lt;span class=\\&quot;mw-reflink-text\\&quot;&gt;&lt;span class=\\&quot;cite-bracket\\&quot;&gt;[&lt;/span&gt;2&lt;span class=\\&quot;cite-bracket\\&quot;&gt;]&lt;/span&gt;&lt;/span&gt;&lt;/a&gt;&lt;/sup&gt;&quot;}}"><ol class="mw-references references"><li style="--footnote-number: &quot;1.&quot;;"><span rel="mw:referencedBy"><a><span class="mw-linkback-text">1 </span></a><a><span class="mw-linkback-text">2 </span></a></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Miller</p></span></div></span></li><li style="--footnote-number: &quot;2.&quot;;"><span rel="mw:referencedBy"></span> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">Smith</p></span></div></span><ol><li style="--footnote-number: &quot;2.1.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 3</p></span></div></span></li><li style="--footnote-number: &quot;2.2.&quot;;"><a rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span class="reference-text"><div class="mw-content-ltr ve-ui-previewElement ve-ui-mwPreviewElement mw-body-content mw-parser-output"><span class="ve-ce-branchNode ve-ce-internalItemNode"><p class="ve-ce-branchNode ve-ce-contentBranchNode ve-ce-paragraphNode ve-ce-generated-wrapper">page 4</p></span></div></span></li></ol></li></ol></div>',
	innerWhitespace:
		[
			undefined,
			undefined
		],
	preserveAnnotationDomElements:
		true
};
