;; DFA scheduling description of the Synopsys DesignWare ARC600 cpu
;; for GNU C compiler
;; Copyright (C) 2007-2026 Free Software Foundation, Inc.
;; Contributor: Joern Rennecke <joern.rennecke@embecosm.com>
;;              on behalf of Synopsys Inc.

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.

;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_automaton "ARC600")

(define_cpu_unit "issue_600" "ARC600")
(define_cpu_unit "mul64_600" "ARC600")

; latency from flag-setting insns to branches is 3.
(define_insn_reservation "compare_600" 3
  (and (eq_attr "tune" "arc600")
       (eq_attr "type" "compare"))
  "issue_600")

(define_insn_reservation "load_DI_600" 4
  (and (eq_attr "tune" "arc600")
       (eq_attr "type" "load")
       (match_operand:DI 0 "" ""))
  "issue_600")

(define_insn_reservation "load_600" 3
  (and (eq_attr "tune" "arc600")
       (eq_attr "type" "load")
       (not (match_operand:DI 0 "" "")))
  "issue_600")

(define_insn_reservation "mul_600_fast" 3
  (and (eq_attr "tune" "arc600")
       (match_test "arc_multcost < COSTS_N_INSNS (7)")
       (eq_attr "type" "multi,umulti"))
  "mul64_600*3")

(define_insn_reservation "mul_600_slow" 8
  (and (eq_attr "tune" "arc600")
       (match_test "arc_multcost >= COSTS_N_INSNS (7)")
       (eq_attr "type" "multi,umulti"))
  "mul64_600*8")

(define_insn_reservation "mul_mac_600" 3
  (and (eq_attr "tune" "arc600")
       (eq_attr "type" "mulmac_600"))
  "nothing*3")

(define_bypass 1 "mul_mac_600" "mul_mac_600")
