/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// TripSegment : trip segment between two stops to show a trip on a map
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct TripSegment {
    #[serde(rename = "trips")]
    pub trips: Vec<models::TripInfo>,
    #[serde(rename = "routeColor", skip_serializing_if = "Option::is_none")]
    pub route_color: Option<String>,
    /// Transport mode for this leg
    #[serde(rename = "mode")]
    pub mode: models::Mode,
    /// distance in meters
    #[serde(rename = "distance")]
    pub distance: f64,
    #[serde(rename = "from")]
    pub from: Box<models::Place>,
    #[serde(rename = "to")]
    pub to: Box<models::Place>,
    /// departure time
    #[serde(rename = "departure")]
    pub departure: String,
    /// arrival time
    #[serde(rename = "arrival")]
    pub arrival: String,
    /// scheduled departure time
    #[serde(rename = "scheduledDeparture")]
    pub scheduled_departure: String,
    /// scheduled arrival time
    #[serde(rename = "scheduledArrival")]
    pub scheduled_arrival: String,
    /// Whether there is real-time data about this leg
    #[serde(rename = "realTime")]
    pub real_time: bool,
    /// Google polyline encoded coordinate sequence (with precision 5) where the trip travels on this segment.
    #[serde(rename = "polyline")]
    pub polyline: String,
}

impl TripSegment {
    /// trip segment between two stops to show a trip on a map
    pub fn new(trips: Vec<models::TripInfo>, mode: models::Mode, distance: f64, from: models::Place, to: models::Place, departure: String, arrival: String, scheduled_departure: String, scheduled_arrival: String, real_time: bool, polyline: String) -> TripSegment {
        TripSegment {
            trips,
            route_color: None,
            mode,
            distance,
            from: Box::new(from),
            to: Box::new(to),
            departure,
            arrival,
            scheduled_departure,
            scheduled_arrival,
            real_time,
            polyline,
        }
    }
}

