# 9.0 Migration Notes {: #\9.0}

## Overview

There are many new features that come with 9.0, and a little housecleaning as well. This guide will touch on migration
concerns related to removals, deprecations, and/or breaking changes.

In general, there should be no breaking changes in 9.0 unless you were still using old, already deprecated features.

## Gone \& Deprecated

Removed deprecated features:

-   Highlight's `legacy_no_wrap_code` option was removed. This used to allow people to output code blocks in Pygments'
    original way, which simply inserted code in a `#!html <pre>` block. This was added all the way back in 6.3 and was
    only added to help transition people to the new output which is HTML5 compatible and wraps code in
    `#!html <pre><code>` blocks. If you have styling or logic that depending on this old, deprecated option, you will
    have to update said styles and/or script logic to account for the new output.

-   Highlight's `highlight_code` option has formally been removed. This option as been a NOOP for a long time and was
    just left around in order to not break people's usage of Highlight. It has now been removed. If it was still hanging
    around in your config, it should simply be removed. Nothing functionally will change.

-   SuperFences, in 7.0, changed up the format of the custom fences. When custom fences were added, a full vision of how
    they would/should be used had not fully cemented, so unfortunately they have been revised occasionally, 7.0 being
    the most recent time. To help transition people, a fallback was left in with a warning. This fallback code has now
    been removed. Information regarding how to upgrade the format is available in the
    [7.0 release guide](./7.0.md#superfences-configurable-classes-and-ids).

As far as deprecated functions and features are concerned:

-   Arithmatex has deprecated all of its SuperFences custom fence functions and instead has replaced it with two
    configurable methods. MkDocs users may have some concerns that these will not work in the YAML configuration, but
    fear not as things work just fine. Check out [Arithmatex Custom Fences](#arithmatex) for more info.

-   PyMdown Extensions provided a number of slugify functions which, like with Arithmatex, have been consolidated into a
    single configurable function. With this consolidation, two new options have been added that allow applying Python's
    default case folding on slugs and allow configuring Unicode normalization. Personally, we feel NFC is the way to go,
    but if others disagree, this is now configurable. Check out
    [One Slugify to Rule Them All](#one-slugify-to-rule-them-all). Much like the new Arithmatex formatters, these slugs,
    even though they are configurable, will work with MkDocs just fine.

## Arithmatex

Arithmatex now as two new custom fences that can be used for InlineHilite and SuperFences: `arithmatex_inline_format`
and `arithmatex_fenced_format` respectively. They can do everything the old methods can do and are configurable. The old
formatters are still available, but have been deprecated.

`arithmatex_inline_format` is meant for InlineHilite and replaces all other inline formatters. The table below shows how
to migrate:

Name                            | Migration
------------------------------- | ---------
`inline_mathjax_preview_format` | `#!py arithmatex_inline_format(mode="mathjax", preview=True)`
`inline_mathjax_format`         | `#!py arithmatex_inline_format(mode="mathjax")`
`inline_generic_format`         | `#!py arithmatex_inline_format(mode="generic")`

`arithmatex_fenced_format` is meant for SuperFences and replaces all related fenced style formatters.

Name                           | Migration
------------------------------ | ---------
`fence_mathjax_preview_format` | `#!py arithmatex_fenced_format(mode="mathjax", preview=True)`
`_inline_mathjax_format`       | `#!py arithmatex_fenced_format(mode="mathjax")`
`inline_generic_format`        | `#!py arithmatex_fenced_format(mode="generic")`

These new, custom fences also add some new features, like being able to change the wrapper element. If you happen to
use MkDocs with Arithmatex, and happen to use `mkdocs-minify-plugin`, you may notice that some math blocks don't render
proper. This is because the plugin butchers white space in the wrapper `#!html <div>` element. Now you can wrap your
math in a `#!html <pre>` and move on :smile:. This is configurable as an Arithmatex option called `block_tag` and
`inline_tag`. The custom fences and formatters also have a `tag` option where this can be configured.

/// note | MkDocs Users
Fear not, this works for MkDocs as well! Using the following syntax can allow you to specify the function with
keyword arguments:

```yaml
markdown_extensions:
  - pymdownx.superfences:
    custom_fences:
      - name: math
        class: arithmatex
        format: !!python/object/apply:pymdownx.arithmatex.arithmatex_fenced_format {kwds: {mode: generic, tag: pre}}
```

While the above is a personal preference as it keeps the arguments on the same line as the function, you can also
specify them in this way which some may find cleaner:

```yaml
markdown_extensions:
  - pymdownx.superfences:
    custom_fences:
      - name: math
        class: arithmatex
        format: !!python/object/apply:pymdownx.arithmatex.arithmatex_fenced_format
          kwds:
            mode: generic
            tag: pre
```
///

## One Slugify to Rule Them All

Previously, the `slug` module provided numerous slugify functions, they have all been reduced to one configurable
function. Migration is shown below:

Name                     | Migration
------------------------ | ---------
`uslugify`               | `#!py slugify(case="lower", percent_encode=True)`
`uslugify_encoded`       | `#!py slugify(case="lower", )`
`uslugify_cased`         | `#!py slugify(percent_encode=True)`
`uslugify_cased_encoded` | `#!py slugify()`
`gfm`                    | `#!py slugify(case="lower-ascii", percent_encode=True)`
`gfm_encoded`            | `#!py slugify(case="lower-ascii")`

Additionally, you can now set `case="fold"` to use Python's default case folding and set `normalize` to different
Unicode normalization modes (`NFC` is default).

/// note | MkDocs Users
Fear not, this works for MkDocs as well! Using the following syntax can allow you to specify the function with
keyword arguments:

```yaml
markdown_extensions:
  - markdown.extensions.toc:
      slugify: !!python/object/apply:pymdownx.slugs.slugify {kwds: {case: lower}}
```

While the above is a personal preference as it keeps the arguments on the same line as the function, you can also
specify them in this way which some may find cleaner:

```yaml
markdown_extensions:
  - markdown.extensions.toc:
      slugify: !!python/object/apply:pymdownx.slugs.slugify
        kwds:
          case: lower
```
///
