/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ig extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nauru";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ban = "Balinese";
        final String metaValue_bug = "Buginese";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_jv = "Javanese";
        final String metaValue_ja = "Japanese";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korean";
        final String metaValue_lo = "Lao";
        final String metaValue_la = "Latin";
        final String metaValue_mak = "Makasar";
        final String metaValue_men = "Mende";
        final String metaValue_ml = "Malayalam";
        final String metaValue_nqo = "N’Ko";
        final String metaValue_osa = "Osage";
        final String metaValue_si = "Sinhala";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_bo = "Tibetan";
        final String metaValue_type_ca_islamic = "Kalenda Hijri";
        final Object[][] data = new Object[][] {
            { "001", "Uwa" },
            { "002", "Afrika" },
            { "003", "Mpaghara Ugwu Amerịka" },
            { "005", "Mpaghara Mgbada Ugwu America" },
            { "009", "Oceania" },
            { "011", "Mpaghara Ọdịda Anyanwụ Afrịka" },
            { "013", "Etiti America" },
            { "014", "Mpaghara Ọwụwa Anyanwụ Afrịka" },
            { "015", "Mpaghara Ugwu Afrịka" },
            { "017", "Etiti Afrịka" },
            { "018", "Mpaghara Mgbada Ugwu Afrịka" },
            { "019", "Amerịka" },
            { "021", "Mpaghara Ugwu America" },
            { "029", "Caribbean" },
            { "030", "Mpaghara Ọwụwa Anyanwụ Asia" },
            { "034", "Mpaghara Mgbada Ugwu Asia" },
            { "035", "Mpaghara Mgbada Ugwu Asia dị na Ọwụwa Anyanwụ" },
            { "039", "Mpaghara Mgbada Ugwu Europe" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Mpaghara Micronesian" },
            { "061", "Polynesia" },
            { "142", "Asia" },
            { "143", "Etiti Asia" },
            { "145", "Mpaghara Ọdịda Anyanwụ Asia" },
            { "150", "Europe" },
            { "151", "Mpaghara Ọwụwa Anyanwụ Europe" },
            { "154", "Mpaghara Ugwu Europe" },
            { "155", "Mpaghara Ọdịda Anyanwụ Europe" },
            { "202", "Sub-Saharan Afrịka" },
            { "419", "Latin America" },
            { "AC", "Ascension Island" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua na Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "American Samoa" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Åland Islands" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia & Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthélemy" },
            { "BM", "Bemuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet Island" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Agwaetiti Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Central African Republik" },
            { "CG", "Congo" },
            { "CH", "Switzerland" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Agwaetiti Cook" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Agwaetiti Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Kosta Rika" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Kurakao" },
            { "CX", "Agwaetiti Christmas" },
            { "CY", "Cyprus" },
            { "CZ", "Czechia" },
            { "DE", "Germany" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denmark" },
            { "DM", "Dominica" },
            { "DO", "Dominican Republik" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta & Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egypt" },
            { "EH", "Ọdịda Anyanwụ Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Spain" },
            { "ET", "Ethiopia" },
            { "EU", "Otu nzukọ mba Europe" },
            { "EZ", "Gburugburu Euro" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "FO", "Faroe Islands" },
            { "FR", "France" },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "French Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "GR", "Greece" },
            { "GS", "South Georgia & South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Agwaetiti Heard na Agwaetiti McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "HT", "Haiti" },
            { "HU", "Hungary" },
            { "IC", "Canary Islands" },
            { "ID", "Indonesia" },
            { "IE", "Ireland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "IT", "Italy" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "St. Kitts & Nevis" },
            { "KP", "North Korea" },
            { "KR", "South Korea" },
            { "KW", "Kuwait" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "LY", "Libia" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagascar" },
            { "MH", "Agwaetiti Marshall" },
            { "MK", "North Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Macao SAR China" },
            { "MP", "Agwaetiti Northern Mariana" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldivesa" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Agwaetiti Norfolk" },
            { "NG", "Naịjịrịa" },
            { "NI", "Nicaragua" },
            { "NL", "Netherlands" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "PM", "St. Pierre & Miquelon" },
            { "PN", "Agwaetiti Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Mpaghara ndị Palestine" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Outlying Oceania" },
            { "RE", "Réunion" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Rwanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Agwaetiti Solomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Sweden" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "South Sudan" },
            { "ST", "São Tomé & Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks & Caicos Islands" },
            { "TD", "Chad" },
            { "TF", "Ụmụ ngalaba Frenchi Southern" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Türkiye" },
            { "TT", "Trinidad na Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "Obere Agwaetiti Dị Na Mpụga U.S" },
            { "UN", "Mba Ụwa Jikọrọ Ọnụ" },
            { "US", "United States" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatican City" },
            { "VC", "St. Vincent & Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis & Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-Accents" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "South Africa" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Mpaghara A na-amaghị" },
            { "aa", "Afar" },
            { "ab", "Abkaziani" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Asụsụ Amariikị" },
            { "an", "Aragonisị" },
            { "ar", "Asụsụ Arabiikị" },
            { "as", "Asụsụ Asamisị" },
            { "av", "Avarịk" },
            { "ay", "Aymara" },
            { "az", "Azerbaijani" },
            { "ba", "Bashkir" },
            { "be", "Belarusian" },
            { "bg", "Bulgarian" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bangla" },
            { "bo", metaValue_bo },
            { "br", "Breton" },
            { "bs", "Bosnian" },
            { "ca", "Catalan" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Corsican" },
            { "cs", "Czech" },
            { "cu", "Church slavic" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "da", "Danish" },
            { "de", "German" },
            { "dv", "Divehi" },
            { "dz", "Dọzngọka" },
            { "ee", "Ewe" },
            { "el", "Grik" },
            { "en", "Bekee" },
            { "eo", "Esperanto" },
            { "es", "Spanish" },
            { "et", "Estonian" },
            { "eu", "Basque" },
            { "fa", "Asụsụ Persia" },
            { "ff", "Fula" },
            { "fi", "Finnish" },
            { "fj", "Fijanị" },
            { "fo", "Faroese" },
            { "fr", "French" },
            { "fy", "Ọdịda anyanwụ Frisian" },
            { "ga", "Irish" },
            { "gd", "Asụsụ Scottish Gaelic" },
            { "gl", "Galician" },
            { "gn", "Guarani" },
            { "gu", "Gujarati" },
            { "gv", "Mansị" },
            { "ha", "Hausa" },
            { "he", "Hebrew" },
            { "hi", "Hindi" },
            { "hr", "Croatian" },
            { "ht", "Haịtịan ndị Cerọle" },
            { "hu", "Hungarian" },
            { "hy", "Asụsụ Armenianị" },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesian" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "io", "Ido" },
            { "is", "Icelandic" },
            { "it", "Italian" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", "Georgian" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Asụsụ Kurmanji" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kyrgyz" },
            { "la", metaValue_la },
            { "lb", "Luxembourgish" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "lt", "Lithuanian" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvian" },
            { "mg", "Malagasy" },
            { "mh", "Marshallese" },
            { "mi", "Māori" },
            { "mk", "Macedonian" },
            { "ml", metaValue_ml },
            { "mn", "Mọngolịan" },
            { "mr", "Asụsụ Marathi" },
            { "ms", "Malay" },
            { "mt", "Asụsụ Malta" },
            { "my", "Burmese" },
            { "na", metaValue_NR },
            { "nb", "Norwegian Bokmål" },
            { "nd", "North Ndebele" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "nl", "Dutch" },
            { "nn", "Norwegian Nynorsk" },
            { "no", "Norwegian" },
            { "nr", "South Ndebele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Asụsụ Osịtan" },
            { "om", "Oromo" },
            { "or", "Ọdịa" },
            { "os", "Ossetic" },
            { "pa", "Punjabi" },
            { "pl", "Asụsụ Polish" },
            { "ps", "Pashọ" },
            { "pt", "Pọrtụgụese" },
            { "qu", "Asụsụ Quechua" },
            { "rm", "Asụsụ Romansh" },
            { "rn", "Rundi" },
            { "ro", "Asụsụ Romanian" },
            { "ru", "Asụsụ Russia" },
            { "rw", "Kinyarwanda" },
            { "sa", "Asụsụ Sanskrit" },
            { "sc", "Asụsụ Sardini" },
            { "sd", "Asụsụ Sindhi" },
            { "se", "Northern Sami" },
            { "sg", "Sango" },
            { "si", metaValue_si },
            { "sk", "Asụsụ Slovak" },
            { "sl", "Asụsụ Slovenia" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "Asụsụ Albania" },
            { "sr", "Asụsụ Serbia" },
            { "ss", "Swati" },
            { "st", "Southern Sotho" },
            { "su", "Asụsụ Sundan" },
            { "sv", "Sụwidiishi" },
            { "sw", "Asụsụ Swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tajik" },
            { "th", "Thai" },
            { "ti", "Tigrinya" },
            { "tk", "Turkmen" },
            { "tn", "Tswana" },
            { "to", "Tongan" },
            { "tr", "Turkish" },
            { "ts", "Tsonga" },
            { "tt", "Asụsụ Tatar" },
            { "ty", "Tahitian" },
            { "ug", "Uyghur" },
            { "uk", "Asụsụ Ukrain" },
            { "ur", "Urdu" },
            { "uz", "Uzbek" },
            { "ve", "Venda" },
            { "vi", "Vietnamese" },
            { "vo", "Volapük" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "Chaịniiz" },
            { "zu", "Zulu" },
            { "ace", "Achinisi" },
            { "ada", "Adangme" },
            { "ady", "Adigi" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "ale", "Aleut" },
            { "alt", "Southern Altai" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "apc", "apcc" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "ars", "Najdi Arabikị" },
            { "asa", "Asụ" },
            { "ast", "Asụsụ Asturianị" },
            { "atj", "Atikamekw" },
            { "awa", "Awadhi" },
            { "bal", "Baluchi" },
            { "ban", metaValue_ban },
            { "bas", "Basaà" },
            { "bem", "Bembà" },
            { "bew", "Betawi" },
            { "bez", "Bena" },
            { "bgc", "Haryanvi" },
            { "bgn", "Western Balochi" },
            { "bho", "Bojpuri" },
            { "bin", "Bini" },
            { "bla", "Siksikà" },
            { "blo", "Anii" },
            { "blt", "Tai Dam" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bug", metaValue_bug },
            { "byn", "Blin" },
            { "cad", "Caddo" },
            { "cay", "Cayuga" },
            { "cch", "Atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chk", "Chuukese" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyene" },
            { "cic", "Chickasaw" },
            { "ckb", "Central Kurdish" },
            { "clc", "Chilcotin" },
            { "crg", "Michif" },
            { "crj", "Southern East Cree" },
            { "crk", "Plains Cree" },
            { "crl", "Northern East Cree" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina Algonquian" },
            { "csw", "Asụsụ Swampy Kree" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "dgr", "Dogrib" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Lower Sorbian" },
            { "dua", "Duala" },
            { "dyo", "Jola-Fonyi" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "eka", "Ekajuk" },
            { "ewo", "Ewondo" },
            { "fil", "Filipino" },
            { "fon", "Fon" },
            { "frc", "Cajun French" },
            { "frr", "Northern Frisian" },
            { "fur", "Friulian" },
            { "gaa", "Ga" },
            { "gez", "Geez" },
            { "gil", "Gilbertese" },
            { "gor", "Gorontalo" },
            { "gsw", "German Swiss" },
            { "guz", "Gusii" },
            { "gwi", "Gwichʼin" },
            { "hai", "Haida" },
            { "haw", "Hawaịlịan" },
            { "hax", "Southern Haida" },
            { "hil", "Hiligayanon" },
            { "hmn", "Hmong" },
            { "hnj", "Hmong Njua" },
            { "hsb", "Upper Sorbian" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Westarn Canadian Inuktitut" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "kaa", "Kara-Kalpak" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kbd", "Kabadian" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabụverdịanụ" },
            { "ken", "Kenyang" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "khq", "Koyra Chiini" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "kok", "Konkani" },
            { "kpe", "Kpelle" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Karelian" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Bafịa" },
            { "ksh", "Colognian" },
            { "kum", "Kumik" },
            { "kwk", "Kwakʼwala" },
            { "kxv", "Kuvi" },
            { "lad", "Ladino" },
            { "lag", "Langị" },
            { "lez", "Lezghian" },
            { "lij", "Ligurian" },
            { "lil", "Liloetị" },
            { "lkt", "Lakota" },
            { "lld", "ID" },
            { "lmo", "Lombard" },
            { "lou", "Louisiana Creole" },
            { "loz", "Lozi" },
            { "lrc", "Northern Luri" },
            { "lsm", "Saamia" },
            { "ltg", "Latgalian" },
            { "lua", "Luba-Lulua" },
            { "lun", "Lunda" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "mad", "Madurese" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", metaValue_mak },
            { "mas", "Masai" },
            { "mdf", "Moksha" },
            { "men", metaValue_men },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta" },
            { "mhn", "mhnn" },
            { "mic", "Mi'kmaw" },
            { "min", "Minangkabau" },
            { "mni", "Asụsụ Manipuri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "Ọtụtụ asụsụ" },
            { "mus", "Muscogee" },
            { "mwl", "Mirandese" },
            { "myv", "Erzya" },
            { "mzn", "Mazanderani" },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "nds", "Low German" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Niuean" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "Northern Sotho" },
            { "nus", "Nuer" },
            { "nyn", "Nyankole" },
            { "ojb", "Northwestern Ojibwa" },
            { "ojc", "Central Ojibwa" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Westarn Ojibwa" },
            { "oka", "Okanagan" },
            { "osa", metaValue_osa },
            { "pag", "Pangasinan" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palauan" },
            { "pcm", "Pidgin ndị Naijirịa" },
            { "pis", "Pijin" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Prụssịan" },
            { "quc", "Kʼicheʼ" },
            { "raj", "Rajastani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongan" },
            { "rhg", "Rohingya" },
            { "rif", "Riffian" },
            { "rof", "Rombo" },
            { "rup", "Aromanian" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Yakut" },
            { "saq", "Samburu" },
            { "sat", "Asụsụ Santali" },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sicilian" },
            { "sco", "Scots" },
            { "sdh", "Southern Kurdish" },
            { "seh", "Sena" },
            { "ses", "Koyraboro Senni" },
            { "shi", "Tachịkịt" },
            { "shn", "Shan" },
            { "sid", "Sidamo" },
            { "skr", "skrr" },
            { "slh", "Southern Lushootseed" },
            { "sma", "Southern Sami" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt sami" },
            { "snk", "Soninke" },
            { "srn", "Sranan Tongo" },
            { "ssy", "Saho" },
            { "str", "Straits Salish" },
            { "suk", "Sukuma" },
            { "swb", "Comorian" },
            { "syr", "Sirịak" },
            { "szl", "Asụsụ Sileshia" },
            { "tce", "Southern Tutchone" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "tet", "Tetum" },
            { "tgx", "Tagish" },
            { "tht", "Tahitan" },
            { "tig", "Tigre" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok pisin" },
            { "trv", "Taroko" },
            { "trw", "Torwali" },
            { "ttm", "Northern Tutchone" },
            { "tum", "Tumbuka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinian" },
            { "tzm", "Central Atlas Tamazight" },
            { "udm", "Udmurt" },
            { "umb", "Umbundu" },
            { "und", "Asụsụ a na-amaghị" },
            { "vec", "Asụsụ Veneshia" },
            { "vmw", "Makhuwa" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu Chinese" },
            { "xal", "Kalmyk" },
            { "xnr", "Kangri" },
            { "xog", "Soga" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Asụsụ Nheengatu" },
            { "yue", "Cantonese" },
            { "zgh", "Standard Moroccan Tamazight" },
            { "zun", "Zuni" },
            { "zxx", "Enweghị asụsụ dịnaya" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Aghb", "Caucasian Albanian" },
            { "Arab", "Mkpụrụ Okwu Arabic" },
            { "Aran", "Nastaliq" },
            { "Armi", "Imperial Aramaic" },
            { "Armn", "Mkpụrụ ọkwụ Armenịan" },
            { "Avst", "Avestan" },
            { "Bali", metaValue_ban },
            { "Bamu", "Bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batak" },
            { "Beng", "Mkpụrụ ọkwụ Bangla" },
            { "Bhks", "Bhaiksuki" },
            { "Bopo", "Mkpụrụ ọkwụ Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Unified Canadian Aboriginal Syllabics" },
            { "Cari", "Carian" },
            { "Cher", metaValue_chr },
            { "Chrs", "Chorasmian" },
            { "Copt", "Coptic" },
            { "Cpmn", "Cypro-Minoan" },
            { "Cprt", "Cypriot" },
            { "Cyrl", "Cyrillic" },
            { "Cyrs", "Old Church Slavonic Cyrillic" },
            { "Deva", "Mkpụrụ ọkwụ Devangarị" },
            { "Diak", "Dives Akuru" },
            { "Dogr", "Dogra" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Duployan shorthand" },
            { "Egyp", "Egyptian hieroglyphs" },
            { "Elba", "Elbasan" },
            { "Elym", "Elymaic" },
            { "Ethi", "Mkpụrụ ọkwụ Etọpịa" },
            { "Gara", "Garay" },
            { "Geor", "Mkpụrụ ọkwụ Geọjịan" },
            { "Glag", "Glagolitic" },
            { "Gong", "Gunjala Gondi" },
            { "Gonm", "Masaram Gondi" },
            { "Goth", "Gothic" },
            { "Gran", "Grantha" },
            { "Grek", "Mkpụrụ ọkwụ grịk" },
            { "Gujr", "Mkpụrụ ọkwụ Gụjaratị" },
            { "Gukh", "Gurung Khema" },
            { "Guru", "Mkpụrụ ọkwụ Gụrmụkị" },
            { "Hanb", "Han na Bopomofo" },
            { "Hang", "Mkpụrụ ọkwụ Hangụl" },
            { "Hani", "Mkpụrụ ọkwụ Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Nke dị mfe" },
            { "Hant", "Omenala" },
            { "Hatr", "Hatran" },
            { "Hebr", "Mkpụrụ ọkwụ Hebrew" },
            { "Hira", "Mkpụrụ okwụ Hịragana" },
            { "Hluw", "Anatolian Hieroglyphs" },
            { "Hmng", "Pahawh Hmong" },
            { "Hmnp", "Nyiakeng Puachue Hmong" },
            { "Hrkt", "mkpụrụ ọkwụ Japanịsị" },
            { "Hung", "Old Hungarian" },
            { "Ital", "Old Italic" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Kawi", "KAWI" },
            { "Khar", "Kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Kits", "Khitan small script" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Krai", "Kirat Rai" },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "Fraktur Latin" },
            { "Latg", "Gaelic Latin" },
            { "Latn", metaValue_la },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lisu", "Fraser" },
            { "Lyci", "Lycian" },
            { "Lydi", "Lydian" },
            { "Mahj", "Mahajani" },
            { "Maka", metaValue_mak },
            { "Mand", "Mandaean" },
            { "Mani", "Manichaean" },
            { "Marc", "Marchen" },
            { "Medf", "Medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "Meroitic Cursive" },
            { "Mero", "Meroitic" },
            { "Mlym", metaValue_ml },
            { "Mong", "Mongolian" },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei Mayek" },
            { "Mult", "Multani" },
            { "Mymr", "Myanmar" },
            { "Nagm", "Nag Mundari" },
            { "Nand", "Nandinagari" },
            { "Narb", "Old North Arabian" },
            { "Nbat", "Nabataean" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "Nüshu" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Onao", "Ol Onal" },
            { "Orkh", "Orkhon" },
            { "Orya", "Odia" },
            { "Osge", metaValue_osa },
            { "Osma", "Osmanya" },
            { "Ougr", "Old Uyghur" },
            { "Palm", "Palmyrene" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Old Permic" },
            { "Phag", "Phags-pa" },
            { "Phli", "Inscriptional Pahlavi" },
            { "Phlp", "Psalter Pahlavi" },
            { "Phnx", "Phoenician" },
            { "Plrd", "Pollard Phonetic" },
            { "Prti", "Inscriptional Parthian" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi" },
            { "Runr", "Runic" },
            { "Samr", "Samaritan" },
            { "Sarb", "Old South Arabian" },
            { "Saur", "Saurashtra" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "Shavian" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "Sogdian" },
            { "Sogo", "Old Sogdian" },
            { "Sora", "Sora Sompeng" },
            { "Soyo", "Soyombo" },
            { "Sund", "Sundanese" },
            { "Sunu", "Sunuwar" },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", "Siriak" },
            { "Syre", "Estrangelo Syriac" },
            { "Syrj", "Western Syriac" },
            { "Syrn", "Eastern Syriac" },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "New Tai Lue" },
            { "Taml", metaValue_ta },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Telu", metaValue_te },
            { "Tfng", "Tifinagh" },
            { "Tglg", "Tagalog" },
            { "Thaa", "Thaana" },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Tnsa", "Tangsa" },
            { "Todr", "Todhri" },
            { "Tutg", "Tulu-Tigalari" },
            { "Ugar", "Ugaritic" },
            { "Vaii", "Vai" },
            { "Vith", "Vithkuqi" },
            { "Wara", "Varang Kshiti" },
            { "Wcho", "Wancho" },
            { "Xpeo", "Old Persian" },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "Yezi", "Yezidi" },
            { "Yiii", "Yi" },
            { "Zanb", "Zanabazar Square" },
            { "Zinh", "Inherited" },
            { "Zmth", "Mkpụrụ ọkwụ Mgbakọ" },
            { "Zsye", "Emoji" },
            { "Zsym", "Akara" },
            { "Zxxx", "A na-edeghị ede" },
            { "Zyyy", "Common" },
            { "Zzzz", "Edemede a na-amaghi" },
            { "de_AT", "Austrian German" },
            { "de_CH", "Swiss High German" },
            { "en_AU", "Bekee ndị Australia" },
            { "en_CA", "Bekee ndị Canada" },
            { "en_GB", "Bekee ndị United Kingdom" },
            { "en_US", "Bekee ndị America" },
            { "es_ES", "Spanish ndị Europe" },
            { "es_MX", "Spanish ndị Mexico" },
            { "fa_AF", "Dari" },
            { "fr_CA", "Canadian French" },
            { "fr_CH", "Swiss French" },
            { "nl_BE", "Flemish" },
            { "pt_BR", "Asụsụ Portugese ndị Brazil" },
            { "pt_PT", "Asụsụ Portuguese ndị Europe" },
            { "ro_MD", "Moldavian" },
            { "ar_001", "Ụdị Arabiikị nke oge a" },
            { "es_419", "Spanish ndị Latin America" },
            { "key.ca", "Kalenda" },
            { "key.cf", "Ụsọrọ egọ" },
            { "key.co", "Ụsọrọ Nhazị" },
            { "key.cu", "Egọ" },
            { "key.em", "Ngosiputa Emoji" },
            { "key.hc", "Okịrịkịrị Awa (12 vs 24)" },
            { "key.lb", "Akara akanka nkwụsị" },
            { "key.lw", "Nkwụsị Ahịrị n’ime Okwu" },
            { "key.ms", "Ụsọrọ Mmeshọ" },
            { "key.nu", "Nọmba" },
            { "key.ss", "Nkwụsị ahịrịokwu mgbe nkenke gasịrị" },
            { "nds_NL", "Low Saxon" },
            { "zh_Hans", "Asụsụ Chaịniiz dị mfe" },
            { "zh_Hant", "Asụsụ ọdịnala Chaịniiz" },
            { "type.ca.roc", "Kalenda repụblic nke China" },
            { "type.hc.h11", "Ụsọrọ Okịrịkịrị awa iri na abụọ (0–11)" },
            { "type.hc.h12", "Ụsọrọ Okịrịkịrị awa iri na abụọ (0–12)" },
            { "type.hc.h23", "Ụsọrọ Okịrịkịrị (0–23)" },
            { "type.hc.h24", "Ụsọrọ Okịrịkịrị (1–24)" },
            { "type.nu.ahom", "Ọnụ ọgụgụ Ahom" },
            { "type.nu.arab", "Ọnụ ọgụgụ Arab na Indị" },
            { "type.nu.armn", "Ọnụ ọgụgụ Armenịa" },
            { "type.nu.bali", "Balinese Digits" },
            { "type.nu.beng", "Ọnụ ọgụgụ Bangla" },
            { "type.nu.brah", "Brahmi Digits" },
            { "type.nu.cakm", "Ọnụ ọgụgụ Chakma" },
            { "type.nu.cham", "Cham Digits" },
            { "type.nu.cyrl", "Ọnụ ọgụgụ Cyrillic" },
            { "type.nu.deva", "Ọnụ ọgụgụ Devanagarị" },
            { "type.nu.diak", "Ọnụ ọgụgụ Dives Akuru" },
            { "type.nu.ethi", "Ọnụ ọgụgụ Etọpịa" },
            { "type.nu.gara", "Ọnụ ọgụgụ Garay" },
            { "type.nu.geor", "Ọnụ ọgụgụ Georgian" },
            { "type.nu.gong", "Ọnụ ọgụgụ Gunjala Gondi" },
            { "type.nu.gonm", "Ọnụ ọgụgụ Masaram Gondi" },
            { "type.nu.grek", "Ọnụ ọgụgụ Grik" },
            { "type.nu.gujr", "Ọnụ ọgụgụ Gụjaratị" },
            { "type.nu.gukh", "Ọnụ ọgụgụ Gurung Khema" },
            { "type.nu.guru", "Onụ ọgụgụ Gụmụkh" },
            { "type.nu.hans", "Ọnụ ọgụgụ mfe Chịnese" },
            { "type.nu.hant", "Ọnụ ọgụgụ ọdinala chinese" },
            { "type.nu.hebr", "Ọnụ ọgụgụ Hebrew" },
            { "type.nu.hmng", "Ọnụ ọgụgụ Pahawh Hmong" },
            { "type.nu.hmnp", "Ọnụ ọgụgụ Nyiakeng Puachue Hmong" },
            { "type.nu.java", "Ọnụ ọgụgụ Javanịsị" },
            { "type.nu.jpan", "Ọnụ ọgụgụ Japanese" },
            { "type.nu.kali", "Ọnụ ọgụgụ Kayah Li" },
            { "type.nu.kawi", "Ọnụ ọgụgụ Kawi" },
            { "type.nu.khmr", "Ọnụ ọgụgụ Khmer" },
            { "type.nu.knda", "Ọnụ ọgụgụ Kannada" },
            { "type.nu.krai", "Ọnụ ọgụgụ Kirat Rai" },
            { "type.nu.lana", "Ọnụ ọgụgụ Tai Tham Hora" },
            { "type.nu.laoo", "Ọnụ ọgụgụ Lao" },
            { "type.nu.latn", "Ọnụ Ọgụgụ Mpaghara Ọdịda Anyanwụ" },
            { "type.nu.lepc", "Ọnụ ọgụgụ Lepcha" },
            { "type.nu.limb", "Ọnụ ọgụgụ Limbu" },
            { "type.nu.mlym", "Ọnụ ọgụgụ Malayala" },
            { "type.nu.modi", "Ọnụ ọgụgụ Modi" },
            { "type.nu.mong", "Ọnụ ọgụgụ Mongolian" },
            { "type.nu.mroo", "Ọnụ ọgụgụ Mro" },
            { "type.nu.mtei", "Ọnụ ọgụgụ Meetei Mayek" },
            { "type.nu.mymr", "Ọnụ ọgụgụ Myamar" },
            { "type.nu.nagm", "Ọnụ ọgụgụ Nag Mundari" },
            { "type.nu.nkoo", "Ọnụ ọgụgụ N’Ko" },
            { "type.nu.olck", "Ọnụ ọgụgụ Ochiki" },
            { "type.nu.onao", "Ọnụ ọgụgụ Ol Onal" },
            { "type.nu.orya", "Ọnụ ọgụgụ Ọdịa" },
            { "type.nu.osma", "Ọnụ ọgụgụ Osmanya" },
            { "type.nu.rohg", "Ọnụ ọgụgụ Hanifi Rohingya" },
            { "type.nu.saur", "Ọnụ ọgụgụ Saurashtra" },
            { "type.nu.shrd", "Ọnụ ọgụgụ Sharada" },
            { "type.nu.sind", "Ọnụ ọgụgụ Khudawadi" },
            { "type.nu.sinh", "Ọnụ ọgụgụ Sinhala Lith" },
            { "type.nu.sora", "Ọnụ ọgụgụ Sora Sompeng" },
            { "type.nu.sund", "Ọnụ ọgụgụ Sundanese" },
            { "type.nu.sunu", "Ọnụ ọgụgụ Sunuwar" },
            { "type.nu.takr", "Ọnụ ọgụgụ Takri" },
            { "type.nu.talu", "Ọnụ ọgụgụ New Tai Lue" },
            { "type.nu.taml", "Ọnụ ọgụgụ ọdịnala Tamịl" },
            { "type.nu.telu", "Ọnụ ọgụgụ Telụgụ" },
            { "type.nu.thai", "Ọnụ ọgụgụ Taị" },
            { "type.nu.tibt", "Ọnụ ọgụgụ Tịbeta" },
            { "type.nu.tirh", "Ọnụ ọgụgụ Tirhuta" },
            { "type.nu.tnsa", "Ọnụ ọgụgụ Tangsa" },
            { "type.nu.vaii", "Ọnụ ọgụgụ Vai" },
            { "type.nu.wara", "Ọnụ ọgụgụ Warang Citi" },
            { "type.nu.wcho", "Ọnụ ọgụgụ Wancho" },
            { "type.ca.dangi", "Kalenda Dang" },
            { "type.co.ducet", "Default Unicode ụsọrọ nhazị" },
            { "type.lb.loose", "Akara akanka nkwụsị esịghị ịke" },
            { "type.nu.roman", "Ọnụ ọgụgụ Roman" },
            { "type.ca.coptic", "Kalenda Koptic" },
            { "type.ca.hebrew", "Kalenda Hebrew" },
            { "type.ca.indian", "Kalenda India" },
            { "type.co.pinyin", "Pinyin ụsọrọ nhazị" },
            { "type.co.search", "Ọchụchụ nịle" },
            { "type.lb.normal", "Akara akanka nkwụsị kwesịrị" },
            { "type.lb.strict", "Akara akanka nkwụsị sịrị ịke" },
            { "type.ms.metric", "Ụsọrọ Metric" },
            { "type.ca.chinese", "Kalenda Chinese" },
            { "type.ca.islamic", metaValue_type_ca_islamic },
            { "type.ca.iso8601", "Kalenda ISO-8601" },
            { "type.ca.persian", "Kalenda Persian" },
            { "type.cf.account", "Ụsọrọ akantụ egọ" },
            { "type.nu.arabext", "Ọnụ ọgụgụ Arab na Indị agbatịrị" },
            { "type.nu.armnlow", "ọbere ọnụ ọgụgụ Armenịa" },
            { "type.nu.greklow", "Ọbere ọnụ ọgụgụ Grik" },
            { "type.nu.hanidec", "Ọnụ ọgụgụ ntụpọ Chịnese" },
            { "type.nu.hansfin", "Ọnụ ọgụgụ akantụ mfe nke Chinese" },
            { "type.nu.hantfin", "Ọnụ ọgụgụ akantụ ọdịnala Chinese" },
            { "type.nu.jpanfin", "Ọnụ ọgụgụ akantụ Japanese" },
            { "type.nu.mathdbl", "Ọnụ ọgụgụ Mathematical Double-Struck" },
            { "type.nu.mymrpao", "Ọnụ ọgụgụ Myanmar Pao" },
            { "type.nu.tamldec", "Ọnụ ọgụgụ Tamị" },
            { "type.ca.buddhist", "Kalenda Bụddịst" },
            { "type.ca.ethiopic", "Kalenda Etopịa" },
            { "type.ca.japanese", "Kalenda Japanese" },
            { "type.cf.standard", "Ụsọrọ egọ nzụgbe" },
            { "type.co.standard", "Usoro Nhazi" },
            { "type.ms.uksystem", "Ụsọrọ Mmeshọ ịmperịa" },
            { "type.ms.ussystem", "Ụsọrọ Mmeshọ US" },
            { "type.nu.fullwide", "Ọnụ ọgụgụ ọbọsara" },
            { "type.nu.lanatham", "Ọnụ ọgụgụ Tai Tham Tham" },
            { "type.nu.mathbold", "Ọnụ ọgụgụ Mathematical Bold" },
            { "type.nu.mathmono", "Ọnụ ọgụgụ Mathematical Monospace" },
            { "type.nu.mathsanb", "Ọnụ ọgụgụ Mathematical Sans-Serif Bold" },
            { "type.nu.mathsans", "Ọnụ ọgụgụ Mathematical Sans-Serif" },
            { "type.nu.mymrepka", "Ọnụ ọgụgụ Myanmar Eastern Pwo Karen" },
            { "type.nu.mymrshan", "Ọnụ ọgụgụ Myanmar Shan" },
            { "type.nu.mymrtlng", "Ọnụ ọgụgụ Myanmar Tai Laing" },
            { "type.nu.outlined", "Ọnụ ọgụgụ Outlined" },
            { "type.nu.romanlow", "Ọbere Ọnụ ọgụgụ Roman" },
            { "type.ca.gregorian", "Kalenda Gregory" },
            { "type.co.phonebook", "Nhazị akwụkwọ ebe a na-ede nọmba fon" },
            { "type.ca.islamic-rgsa", "Kalenda Hijri (Saudi Arabia, sighting)" },
            { "type.ca.islamic-tbla", "Kalenda Hijri (tabular, astronomical epoch)" },
            { "type.ca.islamic-civil", metaValue_type_ca_islamic },
            { "type.ca.islamic-umalqura", "Kalenda Hijri (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Etiopic Amete Alem Kalenda" },
        };
        return data;
    }
}
