/*
    SPDX-FileCopyrightText: 2019 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#include "loadercontrollerfactory.hpp"

// lib
#include "loadercontroller.hpp"

namespace Kasten {

LoaderControllerFactory::LoaderControllerFactory(AbstractDocumentStrategy* documentStrategy)
    : m_documentStrategy(documentStrategy)
{
}

LoaderControllerFactory::~LoaderControllerFactory() = default;

std::unique_ptr<AbstractXmlGuiController> LoaderControllerFactory::create(KXMLGUIClient* guiClient) const
{
    return std::make_unique<LoaderController>(m_documentStrategy, guiClient);
}

}
