/*
    SPDX-FileCopyrightText: 2010 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_INFOTOOLVIEWFACTORY_HPP
#define KASTEN_INFOTOOLVIEWFACTORY_HPP

// lib
#include "oktetakastencontrollers_export.hpp"
// Kasten gui
#include <Kasten/AbstractToolViewFactory>

namespace Kasten {

class OKTETAKASTENCONTROLLERS_EXPORT InfoToolViewFactory : public AbstractToolViewFactory
{
public:
    InfoToolViewFactory();
    InfoToolViewFactory(const InfoToolViewFactory&) = delete;
    InfoToolViewFactory(InfoToolViewFactory&&) = delete;

    ~InfoToolViewFactory() override;

    InfoToolViewFactory& operator=(const InfoToolViewFactory&) = delete;
    InfoToolViewFactory& operator=(InfoToolViewFactory&&) = delete;

public: // AbstractToolViewFactory API
    [[nodiscard]]
    std::unique_ptr<AbstractToolView> create(AbstractTool* tool) const override;

    [[nodiscard]]
    QString iconName() const override;
    [[nodiscard]]
    QString title() const override;
    [[nodiscard]]
    QString id() const override;
    [[nodiscard]]
    SidePosition defaultPosition() const override;
};

}

#endif
