/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DB2DataSourceProvider
extends JDBCDataSourceProvider {
    private static Map<String, String> connectionsProps = new HashMap<String, String>();

    public static Map<String, String> getConnectionsProps() {
        return connectionsProps;
    }

    protected String getConnectionPropertyDefaultValue(String name, String value) {
        String ovrValue = connectionsProps.get(name);
        return ovrValue != null ? ovrValue : super.getConnectionPropertyDefaultValue(name, value);
    }

    public long getFeatures() {
        return 2L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        Map properties;
        boolean traceEnabled;
        if (connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL) {
            return connectionInfo.getUrl();
        }
        StringBuilder url = new StringBuilder(128);
        url.append("jdbc:db2://").append(connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            url.append(":").append(connectionInfo.getHostPort());
        }
        url.append("/");
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            url.append(connectionInfo.getDatabaseName());
        }
        if (traceEnabled = CommonUtils.getBoolean((String)((String)(properties = connectionInfo.getProviderProperties()).get("@dbeaver-trace.enabled")), (boolean)false)) {
            url.append(":traceDirectory=").append(CommonUtils.toString(properties.get("@dbeaver-trace.folder")));
            url.append(";traceFile=").append(CommonUtils.escapeFileName((String)CommonUtils.toString(properties.get("@dbeaver-trace.file"))));
            url.append(";traceFileAppend=").append(CommonUtils.getBoolean((String)((String)properties.get("@dbeaver-trace.append")), (boolean)false));
            url.append(";traceLevel=").append(CommonUtils.toInt(properties.get("@dbeaver-trace.level"), (int)-1));
            url.append(";");
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new DB2DataSource(monitor, container);
    }
}

