// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct PutBucketAnalyticsConfigurationInput {
    /// <p>The name of the bucket to which an analytics configuration is stored.</p>
    pub bucket: ::std::option::Option<::std::string::String>,
    /// <p>The ID that identifies the analytics configuration.</p>
    pub id: ::std::option::Option<::std::string::String>,
    /// <p>The configuration and any analyses for the analytics filter.</p>
    pub analytics_configuration: ::std::option::Option<crate::types::AnalyticsConfiguration>,
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub expected_bucket_owner: ::std::option::Option<::std::string::String>,
}
impl PutBucketAnalyticsConfigurationInput {
    /// <p>The name of the bucket to which an analytics configuration is stored.</p>
    pub fn bucket(&self) -> ::std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The ID that identifies the analytics configuration.</p>
    pub fn id(&self) -> ::std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The configuration and any analyses for the analytics filter.</p>
    pub fn analytics_configuration(&self) -> ::std::option::Option<&crate::types::AnalyticsConfiguration> {
        self.analytics_configuration.as_ref()
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn expected_bucket_owner(&self) -> ::std::option::Option<&str> {
        self.expected_bucket_owner.as_deref()
    }
}
impl PutBucketAnalyticsConfigurationInput {
    /// Creates a new builder-style object to manufacture [`PutBucketAnalyticsConfigurationInput`](crate::operation::put_bucket_analytics_configuration::PutBucketAnalyticsConfigurationInput).
    pub fn builder() -> crate::operation::put_bucket_analytics_configuration::builders::PutBucketAnalyticsConfigurationInputBuilder {
        crate::operation::put_bucket_analytics_configuration::builders::PutBucketAnalyticsConfigurationInputBuilder::default()
    }
}

/// A builder for [`PutBucketAnalyticsConfigurationInput`](crate::operation::put_bucket_analytics_configuration::PutBucketAnalyticsConfigurationInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct PutBucketAnalyticsConfigurationInputBuilder {
    pub(crate) bucket: ::std::option::Option<::std::string::String>,
    pub(crate) id: ::std::option::Option<::std::string::String>,
    pub(crate) analytics_configuration: ::std::option::Option<crate::types::AnalyticsConfiguration>,
    pub(crate) expected_bucket_owner: ::std::option::Option<::std::string::String>,
}
impl PutBucketAnalyticsConfigurationInputBuilder {
    /// <p>The name of the bucket to which an analytics configuration is stored.</p>
    /// This field is required.
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.bucket = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the bucket to which an analytics configuration is stored.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.bucket = input;
        self
    }
    /// <p>The name of the bucket to which an analytics configuration is stored.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        &self.bucket
    }
    /// <p>The ID that identifies the analytics configuration.</p>
    /// This field is required.
    pub fn id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID that identifies the analytics configuration.</p>
    pub fn set_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.id = input;
        self
    }
    /// <p>The ID that identifies the analytics configuration.</p>
    pub fn get_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.id
    }
    /// <p>The configuration and any analyses for the analytics filter.</p>
    /// This field is required.
    pub fn analytics_configuration(mut self, input: crate::types::AnalyticsConfiguration) -> Self {
        self.analytics_configuration = ::std::option::Option::Some(input);
        self
    }
    /// <p>The configuration and any analyses for the analytics filter.</p>
    pub fn set_analytics_configuration(mut self, input: ::std::option::Option<crate::types::AnalyticsConfiguration>) -> Self {
        self.analytics_configuration = input;
        self
    }
    /// <p>The configuration and any analyses for the analytics filter.</p>
    pub fn get_analytics_configuration(&self) -> &::std::option::Option<crate::types::AnalyticsConfiguration> {
        &self.analytics_configuration
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn expected_bucket_owner(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.expected_bucket_owner = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn set_expected_bucket_owner(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.expected_bucket_owner = input;
        self
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn get_expected_bucket_owner(&self) -> &::std::option::Option<::std::string::String> {
        &self.expected_bucket_owner
    }
    /// Consumes the builder and constructs a [`PutBucketAnalyticsConfigurationInput`](crate::operation::put_bucket_analytics_configuration::PutBucketAnalyticsConfigurationInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_bucket_analytics_configuration::PutBucketAnalyticsConfigurationInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(
            crate::operation::put_bucket_analytics_configuration::PutBucketAnalyticsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                analytics_configuration: self.analytics_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            },
        )
    }
}
