/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.tasks.nativetool.ExportSettingsExtension;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeImportExportWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;

public abstract class AbstractNativeExportWizard<SETTINGS extends AbstractImportExportSettings<DBSObject>, INFO>
extends AbstractNativeImportExportWizard<SETTINGS, DBSObject> {
    protected AbstractNativeExportWizard(Collection<DBSObject> objects, String title) {
        super(objects, title);
    }

    protected AbstractNativeExportWizard(DBTTask task) {
        super(task);
    }

    @Override
    public boolean performFinish() {
        AbstractImportExportSettings settings = (AbstractImportExportSettings)this.getSettings();
        for (Object info : ((ExportSettingsExtension)settings).getExportObjects()) {
            Path file;
            block9: {
                try {
                    Path dir = DBFUtils.resolvePathFromString((DBRRunnableContext)this.getRunnableContext(), (DBPProject)this.getProject(), (String)((ExportSettingsExtension)settings).getOutputFolder(info));
                    if (!Files.exists(dir, new LinkOption[0])) {
                        try {
                            Files.createDirectories(dir, new FileAttribute[0]);
                        }
                        catch (IOException e) {
                            this.logPage.setMessage("Can't create directory '" + dir.toString() + "': " + e.getMessage(), 3);
                            this.getContainer().updateMessage();
                            continue;
                        }
                    }
                    if (!Files.exists(file = DBFUtils.resolvePathFromString((DBRRunnableContext)this.getRunnableContext(), (DBPProject)this.getProject(), (String)((ExportSettingsExtension)settings).getOutputFile(info)), new LinkOption[0]) || Files.isDirectory(file, new LinkOption[0])) continue;
                    boolean deleteFile = UIUtils.confirmAction((String)TaskNativeUIMessages.tools_db_export_wizard_file_already_exists_title, (String)TaskNativeUIMessages.tools_db_export_wizard_file_already_exists_message);
                    if (deleteFile) break block9;
                    return false;
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Error resolving file", "Error during output file resolution", (Throwable)e);
                    return false;
                }
            }
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                DBWorkbench.getPlatformUI().showError(TaskNativeUIMessages.tools_db_export_wizard_file_have_not_been_deleted_title, TaskNativeUIMessages.tools_db_export_wizard_file_have_not_been_deleted_message, (Throwable)e);
                return false;
            }
        }
        return super.performFinish();
    }
}

