/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.validation.checkers.IrElementChecker;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/declaration/IrPropertyAccessorsChecker;", "Lorg/jetbrains/kotlin/ir/validation/checkers/IrElementChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "<init>", "()V", "check", "", "element", "context", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;", "ir.validation"})
public final class IrPropertyAccessorsChecker
extends IrElementChecker<IrProperty> {
    @NotNull
    public static final IrPropertyAccessorsChecker INSTANCE = new IrPropertyAccessorsChecker();

    private IrPropertyAccessorsChecker() {
        super(Reflection.getOrCreateKotlinClass(IrProperty.class));
    }

    @Override
    public void check(@NotNull IrProperty element, @NotNull CheckerContext context2) {
        block3: {
            IrSimpleFunction it;
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(context2, "context");
            IrSimpleFunction irSimpleFunction = element.getGetter();
            if (irSimpleFunction != null) {
                it = irSimpleFunction;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getCorrespondingPropertySymbol(), element.getSymbol())) {
                    context2.error(INSTANCE, element, "Getter of property '" + RenderIrElementKt.render$default(element, null, 1, null) + "' has an inconsistent corresponding property symbol.");
                }
            }
            IrSimpleFunction irSimpleFunction2 = element.getSetter();
            if (irSimpleFunction2 == null) break block3;
            it = irSimpleFunction2;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getCorrespondingPropertySymbol(), element.getSymbol())) {
                context2.error(INSTANCE, element, "Setter of property '" + RenderIrElementKt.render$default(element, null, 1, null) + "' has an inconsistent corresponding property symbol.");
            }
        }
    }
}

