/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBGrant;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBPrivilege;
import org.jkiss.dbeaver.ext.iotdb.ui.internal.IoTDBUiMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomCheckboxCellEditor;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PrivilegeTableControl
extends Composite {
    private TableViewer tableViewer;
    private ViewerColumnController<Object, Object> columnsController;
    private Table privTable;
    private List<IoTDBPrivilege> privileges;
    private List<IoTDBObjectPrivilege> currentPrivileges = new ArrayList<IoTDBObjectPrivilege>();

    public PrivilegeTableControl(Composite parent, String title) {
        super(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.setLayout((Layout)gl);
        Group privsGroup = UIUtils.createControlGroup((Composite)this, (String)title, (int)1, (int)1808, (int)0);
        GridData gd = (GridData)privsGroup.getLayoutData();
        gd.horizontalSpan = 2;
        this.tableViewer = new TableViewer((Composite)privsGroup, 68352);
        this.privTable = this.tableViewer.getTable();
        this.privTable.setHeaderVisible(true);
        this.privTable.setLinesVisible(true);
        gd = new GridData(1808);
        gd.minimumWidth = 300;
        this.privTable.setLayoutData((Object)gd);
        this.columnsController = new ViewerColumnController("IoTDBPrivilegesEditor", (ColumnViewer)this.tableViewer);
        this.initColumns();
        this.columnsController.createColumns(false);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        Composite buttonsPanel = UIUtils.createComposite((Composite)privsGroup, (int)3);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        this.createCheckAllButton(buttonsPanel);
        this.createClearAllButton(buttonsPanel);
    }

    private void initColumns() {
        this.addPrivilegeNameColumn();
        this.addPrivilegeEnabledColumn();
        this.addPrivilegeGrantColumn();
    }

    private void addPrivilegeNameColumn() {
        this.columnsController.addColumn(IoTDBUiMessages.controls_privilege_table_column_privilege_name, IoTDBUiMessages.controls_privilege_table_column_privilege_name_tip, 16384, true, true, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof IoTDBObjectPrivilege) {
                    cell.setText(((IoTDBObjectPrivilege)element).privilege.getName());
                }
            }
        });
    }

    private void addPrivilegeEnabledColumn() {
        this.columnsController.addBooleanColumn(IoTDBUiMessages.controls_privilege_table_column_privilege_status, IoTDBUiMessages.controls_privilege_table_column_privilege_status_tip, 0x1000000, true, true, item -> {
            if (item instanceof IoTDBObjectPrivilege) {
                return ((IoTDBObjectPrivilege)item).enabled;
            }
            return false;
        }, new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomCheckboxCellEditor((Composite)PrivilegeTableControl.this.tableViewer.getTable(), true);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                if (element instanceof IoTDBObjectPrivilege) {
                    return ((IoTDBObjectPrivilege)element).enabled;
                }
                return false;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof IoTDBObjectPrivilege) {
                    IoTDBObjectPrivilege elementPriv = (IoTDBObjectPrivilege)element;
                    boolean prevC = elementPriv.enabled;
                    if (elementPriv.enabled != Boolean.TRUE.equals(value)) {
                        elementPriv.enabled = Boolean.TRUE.equals(value);
                        if (!elementPriv.enabled) {
                            elementPriv.withGrantOption = false;
                        }
                    }
                    boolean newC = elementPriv.enabled;
                    boolean newG = elementPriv.withGrantOption;
                    PrivilegeTableControl.this.notifyPrivilegeCheck(elementPriv.privilege, prevC, newC, newG);
                }
            }
        });
    }

    private void addPrivilegeGrantColumn() {
        this.columnsController.addBooleanColumn(IoTDBUiMessages.controls_privilege_table_column_privilege_grant, IoTDBUiMessages.controls_privilege_table_column_privilege_grant_tip, 0x1000000, true, true, item -> {
            if (item instanceof IoTDBObjectPrivilege) {
                return ((IoTDBObjectPrivilege)item).withGrantOption;
            }
            return false;
        }, new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomCheckboxCellEditor((Composite)PrivilegeTableControl.this.tableViewer.getTable(), true);
            }

            protected boolean canEdit(Object element) {
                if (element instanceof IoTDBObjectPrivilege) {
                    return ((IoTDBObjectPrivilege)element).enabled;
                }
                return false;
            }

            protected Object getValue(Object element) {
                if (element instanceof IoTDBObjectPrivilege) {
                    return ((IoTDBObjectPrivilege)element).withGrantOption;
                }
                return false;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof IoTDBObjectPrivilege) {
                    IoTDBObjectPrivilege elementPriv = (IoTDBObjectPrivilege)element;
                    boolean prevC = elementPriv.enabled;
                    if (elementPriv.withGrantOption != Boolean.TRUE.equals(value)) {
                        elementPriv.withGrantOption = Boolean.TRUE.equals(value);
                    }
                    boolean newG = elementPriv.withGrantOption;
                    PrivilegeTableControl.this.notifyPrivilegeCheck(elementPriv.privilege, prevC, prevC, newG);
                }
            }
        });
    }

    private void createCheckAllButton(Composite buttonsPanel) {
        UIUtils.createPushButton((Composite)buttonsPanel, (String)IoTDBUiMessages.controls_privilege_table_push_button_check_all, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (IoTDBObjectPrivilege userPrivilege : CommonUtils.safeCollection(PrivilegeTableControl.this.currentPrivileges)) {
                    userPrivilege.enabled = true;
                    userPrivilege.withGrantOption = true;
                    PrivilegeTableControl.this.notifyPrivilegeCheck(userPrivilege.privilege, true, true, true);
                }
                PrivilegeTableControl.this.drawColumns(PrivilegeTableControl.this.currentPrivileges);
            }
        });
    }

    private void createClearAllButton(Composite buttonsPanel) {
        UIUtils.createPushButton((Composite)buttonsPanel, (String)IoTDBUiMessages.controls_privilege_table_push_button_clear_all, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (IoTDBObjectPrivilege userPrivilege : CommonUtils.safeCollection(PrivilegeTableControl.this.currentPrivileges)) {
                    userPrivilege.enabled = false;
                    userPrivilege.withGrantOption = false;
                    PrivilegeTableControl.this.notifyPrivilegeCheck(userPrivilege.privilege, true, false, false);
                }
                PrivilegeTableControl.this.drawColumns(PrivilegeTableControl.this.currentPrivileges);
            }
        });
    }

    private void notifyPrivilegeCheck(IoTDBPrivilege privilege, boolean prevC, boolean checked, boolean withGrantOption) {
        Event event = new Event();
        event.detail = checked && withGrantOption ? 2 : (!checked && !withGrantOption ? 3 : (prevC ? 0 : 1));
        event.widget = this;
        event.data = privilege;
        super.notifyListeners(24, event);
    }

    public void fillPrivileges(@NotNull List<IoTDBPrivilege> tempPrivileges) {
        this.privileges = new ArrayList<IoTDBPrivilege>(tempPrivileges);
    }

    public void fillGrants(List<IoTDBGrant> grants, boolean editable) {
        this.privTable.setEnabled(editable);
        this.fillGrants(grants);
    }

    public void fillGrants(List<IoTDBGrant> grants) {
        if (CommonUtils.isEmpty(this.privileges)) {
            return;
        }
        this.currentPrivileges = new ArrayList<IoTDBObjectPrivilege>();
        if (CommonUtils.isEmpty(grants)) {
            for (IoTDBPrivilege privilege : this.privileges) {
                this.currentPrivileges.add(new IoTDBObjectPrivilege(privilege, false, false));
            }
            this.drawColumns(this.currentPrivileges);
            return;
        }
        for (IoTDBPrivilege privilege : this.privileges) {
            boolean privilegeEnabled = false;
            boolean privilegeGranted = false;
            for (IoTDBGrant grant : grants) {
                if (!ArrayUtils.contains((Object[])grant.getPrivileges(), (Object)privilege)) continue;
                privilegeEnabled = true;
                if (!grant.isGranted()) continue;
                privilegeGranted = true;
            }
            this.currentPrivileges.add(new IoTDBObjectPrivilege(privilege, privilegeEnabled, privilegeGranted));
        }
        this.drawColumns(this.currentPrivileges);
    }

    private void drawColumns(List<?> objects) {
        this.tableViewer.setInput(objects);
        this.tableViewer.refresh();
        this.columnsController.repackColumns();
    }

    public void checkPrivilege(IoTDBPrivilege privilege, boolean grant) {
        for (IoTDBObjectPrivilege basePrivilege : this.currentPrivileges) {
            if (basePrivilege.privilege != privilege) continue;
            basePrivilege.enabled = grant;
        }
        this.drawColumns(this.currentPrivileges);
    }

    private static class IoTDBObjectPrivilege {
        private IoTDBPrivilege privilege;
        private boolean enabled;
        private boolean withGrantOption;

        IoTDBObjectPrivilege(IoTDBPrivilege privilege, boolean enabled, boolean withGrantOption) {
            this.privilege = privilege;
            this.enabled = enabled;
            this.withGrantOption = withGrantOption;
        }
    }
}

