/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.temporal.DifferenceZonedDateTimeNode;
import com.oracle.truffle.js.nodes.temporal.RoundRelativeDurationNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TemporalDurationWithTotalRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

@ImportStatic(value={TemporalConstants.class})
public abstract class DifferenceZonedDateTimeWithRoundingNode
extends JavaScriptBaseNode {
    protected DifferenceZonedDateTimeWithRoundingNode() {
    }

    public abstract TemporalDurationWithTotalRecord execute(BigInt var1, BigInt var2, TruffleString var3, TruffleString var4, JSTemporalPlainDateTimeObject var5, TemporalUtil.Unit var6, int var7, TemporalUtil.Unit var8, TemporalUtil.RoundingMode var9);

    @Specialization
    static TemporalDurationWithTotalRecord differenceZonedDateTimeWithRounding(BigInt ns1, BigInt ns2, TruffleString calendar, TruffleString timeZone, JSTemporalPlainDateTimeObject precalculatedPlainDateTime, TemporalUtil.Unit largestUnit, int roundingIncrement, TemporalUtil.Unit smallestUnit, TemporalUtil.RoundingMode roundingMode, @Cached DifferenceZonedDateTimeNode differenceZonedDateTime, @Cached RoundRelativeDurationNode roundRelativeDuration) {
        boolean roundingGranularityIsNoop;
        if (!largestUnit.isCalendarUnit() && largestUnit != TemporalUtil.Unit.DAY) {
            TemporalUtil.NormalizedTimeDurationWithTotalRecord diffRecord = TemporalUtil.differenceInstant(ns1, ns2, roundingIncrement, smallestUnit, roundingMode);
            BigInt norm = diffRecord.normalizedTimeDuration();
            TimeDurationRecord result = TemporalUtil.balanceTimeDuration(norm, largestUnit);
            JSTemporalDurationRecord durationRecord = JSTemporalDurationRecord.createWeeks(0.0, 0.0, 0.0, 0.0, result.hours(), result.minutes(), result.seconds(), result.milliseconds(), result.microseconds(), result.nanoseconds());
            return new TemporalDurationWithTotalRecord(durationRecord, diffRecord.total());
        }
        NormalizedDurationRecord difference = differenceZonedDateTime.execute(ns1, ns2, timeZone, calendar, largestUnit, precalculatedPlainDateTime);
        boolean bl = roundingGranularityIsNoop = smallestUnit == TemporalUtil.Unit.NANOSECOND && roundingIncrement == 1;
        if (roundingGranularityIsNoop) {
            TimeDurationRecord timeResult = TemporalUtil.balanceTimeDuration(difference.normalizedTimeTotalNanoseconds(), TemporalUtil.Unit.HOUR);
            double total = difference.normalizedTimeTotalNanoseconds().doubleValue();
            JSTemporalDurationRecord durationRecord = JSTemporalDurationRecord.createWeeks(difference.years(), difference.months(), difference.weeks(), difference.days(), timeResult.hours(), timeResult.minutes(), timeResult.seconds(), timeResult.milliseconds(), timeResult.microseconds(), timeResult.nanoseconds());
            return new TemporalDurationWithTotalRecord(durationRecord, total);
        }
        ISODateTimeRecord dateTime = new ISODateTimeRecord(precalculatedPlainDateTime.getYear(), precalculatedPlainDateTime.getMonth(), precalculatedPlainDateTime.getDay(), precalculatedPlainDateTime.getHour(), precalculatedPlainDateTime.getMinute(), precalculatedPlainDateTime.getSecond(), precalculatedPlainDateTime.getMillisecond(), precalculatedPlainDateTime.getMicrosecond(), precalculatedPlainDateTime.getNanosecond());
        return roundRelativeDuration.execute(difference, ns2, dateTime, calendar, timeZone, largestUnit, roundingIncrement, smallestUnit, roundingMode);
    }
}

