/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.InternalResource;
import java.io.IOException;
import java.nio.file.Path;

@InternalResource.Id(value="libnfi")
final class LibNFIResource
implements InternalResource {
    static final String ID = "libnfi";

    LibNFIResource() {
    }

    public void unpackFiles(InternalResource.Env env, Path targetDirectory) throws IOException {
        if (env.inNativeImageBuild() && !env.inContextPreinitialization()) {
            return;
        }
        Path base = LibNFIResource.basePath(env);
        env.unpackResourceFiles(base.resolve("files"), targetDirectory, base);
    }

    public String versionHash(InternalResource.Env env) throws IOException {
        Path base = LibNFIResource.basePath(env);
        return (String)env.readResourceLines(base.resolve("sha256")).get(0);
    }

    private static Path basePath(InternalResource.Env env) {
        return Path.of("META-INF", "resources", "nfi-native", ID, env.getOS().toString(), env.getCPUArchitecture().toString());
    }
}

