/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractNoOffsetLimitHandler;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class FetchLimitHandler
extends AbstractNoOffsetLimitHandler {
    public static final FetchLimitHandler INSTANCE = new FetchLimitHandler(false);

    public FetchLimitHandler(boolean variableLimit) {
        super(variableLimit);
    }

    @Override
    protected String limitClause() {
        return " fetch first ? rows only";
    }

    @Override
    protected String limitClause(int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        return " fetch first " + parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null) + " rows only";
    }

    @Override
    protected String insert(String fetch, String sql) {
        return this.insertBeforeForUpdate(fetch, sql);
    }

    @Override
    public boolean bindLimitParametersFirst() {
        return false;
    }

    @Override
    public boolean processSqlMutatesState() {
        return false;
    }
}

