/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public class BigArrays {
    protected BigArrays() {
    }

    public static int segment(long index) {
        return (int)(index >>> 27);
    }

    public static int displacement(long index) {
        return (int)(index & 0x7FFFFFFL);
    }

    public static long start(int segment) {
        return (long)segment << 27;
    }

    public static void ensureLength(long bigArrayLength) {
        if (bigArrayLength < 0L) {
            throw new IllegalArgumentException("Negative big-array size: " + bigArrayLength);
        }
        if (bigArrayLength >= 288230376017494016L) {
            throw new IllegalArgumentException("Big-array size too big: " + bigArrayLength);
        }
    }

    public static void set(int[][] array, long index, int value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    public static long length(int[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    public static void copy(int[][] srcArray, long srcPos, int[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                if (l == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                int l;
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                if ((l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl))) == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static int[][] forceCapacity(int[][] array, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array.length - (array.length == 0 || array.length > 0 && array[array.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        int[][] base = (int[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = valid; i < baseLength - 1; ++i) {
                base[i] = new int[0x8000000];
            }
            base[baseLength - 1] = new int[residual];
        } else {
            for (int i = valid; i < baseLength; ++i) {
                base[i] = new int[0x8000000];
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            BigArrays.copy(array, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static int[][] ensureCapacity(int[][] array, long length, long preserve) {
        return length > BigArrays.length(array) ? BigArrays.forceCapacity(array, length, preserve) : array;
    }

    public static int[][] grow(int[][] array, long length) {
        long oldLength = BigArrays.length(array);
        return length > oldLength ? BigArrays.grow(array, length, oldLength) : array;
    }

    public static int[][] grow(int[][] array, long length, long preserve) {
        long oldLength = BigArrays.length(array);
        return length > oldLength ? BigArrays.ensureCapacity(array, Math.max(oldLength + (oldLength >> 1), length), preserve) : array;
    }

    public static int[][] trim(int[][] array, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        int[][] base = (int[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = IntArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static boolean equals(int[][] a1, int[][] a2) {
        if (BigArrays.length(a1) != BigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            int[] t = a1[i];
            int[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static <K> void set(K[][] array, long index, K value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    public static <K> long length(K[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    public static <K> void copy(K[][] srcArray, long srcPos, K[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                if (l == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                int l;
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                if ((l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl))) == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static <K> K[][] forceCapacity(K[][] array, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array.length - (array.length == 0 || array.length > 0 && array[array.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        Object[][] base = (Object[][])Arrays.copyOf(array, baseLength);
        Class<?> componentType = array.getClass().getComponentType();
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = valid; i < baseLength - 1; ++i) {
                base[i] = (Object[])Array.newInstance(componentType.getComponentType(), 0x8000000);
            }
            base[baseLength - 1] = (Object[])Array.newInstance(componentType.getComponentType(), residual);
        } else {
            for (int i = valid; i < baseLength; ++i) {
                base[i] = (Object[])Array.newInstance(componentType.getComponentType(), 0x8000000);
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            BigArrays.copy(array, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static <K> K[][] ensureCapacity(K[][] array, long length, long preserve) {
        return length > BigArrays.length(array) ? BigArrays.forceCapacity(array, length, preserve) : array;
    }

    public static <K> K[][] grow(K[][] array, long length) {
        long oldLength = BigArrays.length(array);
        return length > oldLength ? BigArrays.grow(array, length, oldLength) : array;
    }

    public static <K> K[][] grow(K[][] array, long length, long preserve) {
        long oldLength = BigArrays.length(array);
        return length > oldLength ? BigArrays.ensureCapacity(array, Math.max(oldLength + (oldLength >> 1), length), preserve) : array;
    }

    public static <K> K[][] trim(K[][] array, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        Object[][] base = (Object[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = ObjectArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static <K> boolean equals(K[][] a1, K[][] a2) {
        if (BigArrays.length(a1) != BigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            K[] t = a1[i];
            K[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (Objects.equals(t[j], u[j])) continue;
                return false;
            }
        }
        return true;
    }
}

