/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.openapi.util.Comparing;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.GraphColorGetter;
import com.intellij.vcs.log.graph.api.printer.GraphPrintElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementPresentationManager;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eB%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0012\u001a\u00020\u000e2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u0014J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u00020\u00152\n\u0010\u001d\u001a\u00060\u0015j\u0002`\u0016H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/log/graph/impl/facade/PrintElementPresentationManagerImpl;", "CommitId", "Lcom/intellij/vcs/log/graph/api/printer/PrintElementPresentationManager;", "permanentGraphInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "linearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "colorGetter", "Lcom/intellij/vcs/log/graph/api/printer/GraphColorGetter;", "<init>", "(Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;Lcom/intellij/vcs/log/graph/api/LinearGraph;Lcom/intellij/vcs/log/graph/api/printer/GraphColorGetter;)V", "selection", "Lcom/intellij/vcs/log/graph/impl/facade/PrintElementPresentationManagerImpl$Selection;", "isSelected", "", "printElement", "Lcom/intellij/vcs/log/graph/api/printer/GraphPrintElement;", "setSelectedElement", "setSelectedElements", "selectedNodeId", "", "", "Lcom/intellij/vcs/log/graph/api/permanent/VcsLogGraphNodeId;", "setSelection", "newSelection", "getColorId", "element", "Lcom/intellij/vcs/log/graph/api/elements/GraphElement;", "getLayoutIndex", "nodeId", "Selection", "intellij.platform.vcs.log.graph.impl"})
public final class PrintElementPresentationManagerImpl<CommitId>
implements PrintElementPresentationManager {
    @NotNull
    private final PermanentGraphInfo<CommitId> permanentGraphInfo;
    @NotNull
    private final LinearGraph linearGraph;
    @NotNull
    private final GraphColorGetter colorGetter;
    @NotNull
    private Selection selection;

    public PrintElementPresentationManagerImpl(@NotNull PermanentGraphInfo<CommitId> permanentGraphInfo, @NotNull LinearGraph linearGraph, @NotNull GraphColorGetter colorGetter) {
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        Intrinsics.checkNotNullParameter((Object)linearGraph, (String)"linearGraph");
        Intrinsics.checkNotNullParameter((Object)colorGetter, (String)"colorGetter");
        this.permanentGraphInfo = permanentGraphInfo;
        this.linearGraph = linearGraph;
        this.colorGetter = colorGetter;
        this.selection = new Selection.FromNodeIds(this.linearGraph, SetsKt.emptySet());
    }

    @Override
    public boolean isSelected(@NotNull GraphPrintElement printElement) {
        Intrinsics.checkNotNullParameter((Object)printElement, (String)"printElement");
        return this.selection.isSelected(printElement);
    }

    public final boolean setSelectedElement(@NotNull GraphPrintElement printElement) {
        Intrinsics.checkNotNullParameter((Object)printElement, (String)"printElement");
        return this.setSelection(new Selection.FromPrintElement(printElement));
    }

    public final boolean setSelectedElements(@NotNull Set<Integer> selectedNodeId) {
        Intrinsics.checkNotNullParameter(selectedNodeId, (String)"selectedNodeId");
        return this.setSelection(new Selection.FromNodeIds(this.linearGraph, selectedNodeId));
    }

    private final boolean setSelection(Selection newSelection) {
        if (Intrinsics.areEqual((Object)newSelection, (Object)this.selection)) {
            return false;
        }
        this.selection = newSelection;
        return true;
    }

    @Override
    public int getColorId(@NotNull GraphElement element) {
        int downLayoutIndex;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof GraphNode) {
            int nodeId = this.linearGraph.getNodeId(((GraphNode)element).getNodeIndex());
            return this.colorGetter.getNodeColor(nodeId, this.getLayoutIndex(nodeId));
        }
        GraphEdge edge = (GraphEdge)element;
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge == null) {
            int nodeId = this.linearGraph.getNodeId(LinearGraphUtils.getNotNullNodeIndex(edge));
            return this.colorGetter.getNodeColor(nodeId, this.getLayoutIndex(nodeId));
        }
        int upNodeId = this.linearGraph.getNodeId(normalEdge.up);
        int downNodeId = this.linearGraph.getNodeId(normalEdge.down);
        int upLayoutIndex = this.getLayoutIndex(upNodeId);
        if (upLayoutIndex >= (downLayoutIndex = this.getLayoutIndex(downNodeId))) {
            return this.colorGetter.getNodeColor(upNodeId, upLayoutIndex);
        }
        return this.colorGetter.getNodeColor(downNodeId, downLayoutIndex);
    }

    private final int getLayoutIndex(int nodeId) {
        return nodeId < 0 ? nodeId : this.permanentGraphInfo.getPermanentGraphLayout().getLayoutIndex(nodeId);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/graph/impl/facade/PrintElementPresentationManagerImpl$Selection;", "", "<init>", "()V", "isSelected", "", "printElement", "Lcom/intellij/vcs/log/graph/api/printer/GraphPrintElement;", "FromPrintElement", "FromNodeIds", "Lcom/intellij/vcs/log/graph/impl/facade/PrintElementPresentationManagerImpl$Selection$FromNodeIds;", "Lcom/intellij/vcs/log/graph/impl/facade/PrintElementPresentationManagerImpl$Selection$FromPrintElement;", "intellij.platform.vcs.log.graph.impl"})
    public static abstract class Selection {
        private Selection() {
        }

        public abstract boolean isSelected(@NotNull GraphPrintElement var1);

        public /* synthetic */ Selection(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/log/graph/impl/facade/PrintElementPresentationManagerImpl$Selection$FromNodeIds;", "Lcom/intellij/vcs/log/graph/impl/facade/PrintElementPresentationManagerImpl$Selection;", "linearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "selectedNodeIds", "", "", "Lcom/intellij/vcs/log/graph/api/permanent/VcsLogGraphNodeId;", "<init>", "(Lcom/intellij/vcs/log/graph/api/LinearGraph;Ljava/util/Set;)V", "isSelected", "", "printElement", "Lcom/intellij/vcs/log/graph/api/printer/GraphPrintElement;", "equals", "other", "", "hashCode", "intellij.platform.vcs.log.graph.impl"})
        public static final class FromNodeIds
        extends Selection {
            @NotNull
            private final LinearGraph linearGraph;
            @NotNull
            private final Set<Integer> selectedNodeIds;

            public FromNodeIds(@NotNull LinearGraph linearGraph, @NotNull Set<Integer> selectedNodeIds) {
                Intrinsics.checkNotNullParameter((Object)linearGraph, (String)"linearGraph");
                Intrinsics.checkNotNullParameter(selectedNodeIds, (String)"selectedNodeIds");
                super(null);
                this.linearGraph = linearGraph;
                this.selectedNodeIds = selectedNodeIds;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean isSelected(@NotNull GraphPrintElement printElement) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)printElement, (String)"printElement");
                    graphElement = printElement.getGraphElement();
                    if (graphElement instanceof GraphNode) {
                        nodeId = this.linearGraph.getNodeId(((GraphNode)graphElement).getNodeIndex());
                        return this.selectedNodeIds.contains(nodeId);
                    }
                    if (!(graphElement instanceof GraphEdge)) break block5;
                    v0 = selected = ((GraphEdge)graphElement).getTargetId() == null || CollectionsKt.contains((Iterable)this.selectedNodeIds, (Object)((GraphEdge)graphElement).getTargetId()) != false;
                    if (((GraphEdge)graphElement).getUpNodeIndex() == null) ** GOTO lbl-1000
                    v1 = ((GraphEdge)graphElement).getUpNodeIndex();
                    Intrinsics.checkNotNull((Object)v1);
                    if (this.selectedNodeIds.contains(this.linearGraph.getNodeId(v1))) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else {
                        v2 = false;
                    }
                    selected &= v2;
                    if (((GraphEdge)graphElement).getDownNodeIndex() == null) ** GOTO lbl-1000
                    v3 = ((GraphEdge)graphElement).getDownNodeIndex();
                    Intrinsics.checkNotNull((Object)v3);
                    if (this.selectedNodeIds.contains(this.linearGraph.getNodeId(v3))) lbl-1000:
                    // 2 sources

                    {
                        v4 = true;
                    } else {
                        v4 = false;
                    }
                    return selected &= v4;
                }
                return false;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FromNodeIds)) {
                    return false;
                }
                return Comparing.haveEqualElements((Collection)this.selectedNodeIds, (Collection)((FromNodeIds)other).selectedNodeIds);
            }

            public int hashCode() {
                return Comparing.unorderedHashcode((Collection)this.selectedNodeIds);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/log/graph/impl/facade/PrintElementPresentationManagerImpl$Selection$FromPrintElement;", "Lcom/intellij/vcs/log/graph/impl/facade/PrintElementPresentationManagerImpl$Selection;", "selectedPrintElement", "Lcom/intellij/vcs/log/graph/api/printer/GraphPrintElement;", "<init>", "(Lcom/intellij/vcs/log/graph/api/printer/GraphPrintElement;)V", "isSelected", "", "printElement", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.platform.vcs.log.graph.impl"})
        public static final class FromPrintElement
        extends Selection {
            @NotNull
            private final GraphPrintElement selectedPrintElement;

            public FromPrintElement(@NotNull GraphPrintElement selectedPrintElement) {
                Intrinsics.checkNotNullParameter((Object)selectedPrintElement, (String)"selectedPrintElement");
                super(null);
                this.selectedPrintElement = selectedPrintElement;
            }

            @Override
            public boolean isSelected(@NotNull GraphPrintElement printElement) {
                Intrinsics.checkNotNullParameter((Object)printElement, (String)"printElement");
                return Intrinsics.areEqual((Object)printElement, (Object)this.selectedPrintElement);
            }

            private final GraphPrintElement component1() {
                return this.selectedPrintElement;
            }

            @NotNull
            public final FromPrintElement copy(@NotNull GraphPrintElement selectedPrintElement) {
                Intrinsics.checkNotNullParameter((Object)selectedPrintElement, (String)"selectedPrintElement");
                return new FromPrintElement(selectedPrintElement);
            }

            public static /* synthetic */ FromPrintElement copy$default(FromPrintElement fromPrintElement, GraphPrintElement graphPrintElement, int n, Object object) {
                if ((n & 1) != 0) {
                    graphPrintElement = fromPrintElement.selectedPrintElement;
                }
                return fromPrintElement.copy(graphPrintElement);
            }

            @NotNull
            public String toString() {
                return "FromPrintElement(selectedPrintElement=" + this.selectedPrintElement + ")";
            }

            public int hashCode() {
                return this.selectedPrintElement.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FromPrintElement)) {
                    return false;
                }
                FromPrintElement fromPrintElement = (FromPrintElement)other;
                return Intrinsics.areEqual((Object)this.selectedPrintElement, (Object)fromPrintElement.selectedPrintElement);
            }
        }
    }
}

