/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.WarningLevel;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.BaseDiagnosticRendererFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B5\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\b\u0010\u001f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u0082\u0001\u0005 !\"#$\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKtDiagnosticFactory;", "", "name", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "defaultPositioningStrategy", "Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;", "psiType", "Lkotlin/reflect/KClass;", "rendererFactory", "Lorg/jetbrains/kotlin/diagnostics/rendering/BaseDiagnosticRendererFactory;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;Lkotlin/reflect/KClass;Lorg/jetbrains/kotlin/diagnostics/rendering/BaseDiagnosticRendererFactory;)V", "getName", "()Ljava/lang/String;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "getDefaultPositioningStrategy", "()Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;", "getPsiType", "()Lkotlin/reflect/KClass;", "getRendererFactory", "()Lorg/jetbrains/kotlin/diagnostics/rendering/BaseDiagnosticRendererFactory;", "ktRenderer", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "getKtRenderer", "()Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "getEffectiveSeverity", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "toString", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory2;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory4;", "frontend.common"})
public abstract class AbstractKtDiagnosticFactory {
    @NotNull
    private final String name;
    @NotNull
    private final Severity severity;
    @NotNull
    private final AbstractSourceElementPositioningStrategy defaultPositioningStrategy;
    @NotNull
    private final KClass<?> psiType;
    @NotNull
    private final BaseDiagnosticRendererFactory rendererFactory;

    private AbstractKtDiagnosticFactory(String name2, Severity severity, AbstractSourceElementPositioningStrategy defaultPositioningStrategy, KClass<?> psiType, BaseDiagnosticRendererFactory rendererFactory) {
        this.name = name2;
        this.severity = severity;
        this.defaultPositioningStrategy = defaultPositioningStrategy;
        this.psiType = psiType;
        this.rendererFactory = rendererFactory;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Severity getSeverity() {
        return this.severity;
    }

    @NotNull
    public final AbstractSourceElementPositioningStrategy getDefaultPositioningStrategy() {
        return this.defaultPositioningStrategy;
    }

    @NotNull
    public final KClass<?> getPsiType() {
        return this.psiType;
    }

    @NotNull
    public final BaseDiagnosticRendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    @NotNull
    public final KtDiagnosticRenderer getKtRenderer() {
        KtDiagnosticRenderer ktDiagnosticRenderer = this.rendererFactory.getMAP().get(this);
        if (ktDiagnosticRenderer == null) {
            throw new IllegalStateException(("Renderer is not found for factory " + this + " inside " + this.rendererFactory.getMAP().getName() + " renderer map").toString());
        }
        return ktDiagnosticRenderer;
    }

    @Nullable
    protected final Severity getEffectiveSeverity(@NotNull LanguageVersionSettings languageVersionSettings) {
        Severity severity;
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        WarningLevel warningLevel = languageVersionSettings.getFlag(AnalysisFlags.INSTANCE.getWarningLevels()).get(this.name);
        switch (warningLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[warningLevel.ordinal()]) {
            case 1: {
                severity = Severity.ERROR;
                break;
            }
            case 2: {
                severity = Severity.FIXED_WARNING;
                break;
            }
            case 3: {
                severity = null;
                break;
            }
            case -1: {
                severity = this.severity;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return severity;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public /* synthetic */ AbstractKtDiagnosticFactory(String name2, Severity severity, AbstractSourceElementPositioningStrategy defaultPositioningStrategy, KClass psiType, BaseDiagnosticRendererFactory rendererFactory, DefaultConstructorMarker $constructor_marker) {
        this(name2, severity, defaultPositioningStrategy, psiType, rendererFactory);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WarningLevel.values().length];
            try {
                nArray[WarningLevel.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarningLevel.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarningLevel.Disabled.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

