/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeComparator;
import org.gradle.internal.Cast;

public final class NodeSets {
    public static Set<Node> newSortedNodeSet() {
        return new LazySortedReferenceHashSet<Node>(NodeComparator.INSTANCE);
    }

    public static List<Node> sortedListOf(Set<Node> nodes) {
        ArrayList<Node> sorted = new ArrayList<Node>(nodes);
        sorted.sort(NodeComparator.INSTANCE);
        return sorted;
    }

    private NodeSets() {
    }

    static final class LazySortedReferenceHashSet<E>
    extends AbstractSet<E> {
        private final Comparator<? super E> comparator;
        private final ReferenceOpenHashSet<E> set = new ReferenceOpenHashSet();
        private Object[] array = NO_ELEMENTS;
        private int size = 0;
        private int version = 0;
        private static final int INITIAL_CAPACITY = 8;
        private static final Object[] NO_ELEMENTS = new Object[0];

        public LazySortedReferenceHashSet(Comparator<? super E> comparator) {
            this.comparator = comparator;
        }

        @Override
        public boolean add(E e) {
            if (!this.set.add(e)) {
                return false;
            }
            if (this.size >= this.array.length) {
                this.array = LazySortedReferenceHashSet.growArray(this.array);
            }
            this.array[this.size++] = e;
            this.version = Math.abs(this.version) + 1;
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            if (this.set.remove(o)) {
                this.removeIndex(this.indexOf(o));
                return true;
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.size == 0) {
                return ObjectIterators.emptyIterator();
            }
            this.sort();
            return new Iterator<E>(){
                int iteratorVersion;
                int index;
                {
                    this.iteratorVersion = version;
                    this.index = 0;
                }

                @Override
                public void remove() {
                    Object e = Cast.uncheckedCast((Object)array[this.index - 1]);
                    if (!set.remove(e)) {
                        throw new ConcurrentModificationException();
                    }
                    this.removeIndex(this.index - 1);
                    --this.index;
                    this.iteratorVersion = version;
                }

                @Override
                public boolean hasNext() {
                    return this.index < size;
                }

                @Override
                public E next() {
                    if (version != this.iteratorVersion) {
                        throw new ConcurrentModificationException();
                    }
                    return Cast.uncheckedCast((Object)array[this.index++]);
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int hashCode() {
            return this.set.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            return this.set.equals(o);
        }

        private void sort() {
            if (this.version <= 0) {
                return;
            }
            Arrays.sort((Object[])Cast.uncheckedCast((Object)this.array), 0, this.size, this.comparator);
            this.version = -this.version;
        }

        private int indexOf(Object o) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.array[i] != o) continue;
                return i;
            }
            return -1;
        }

        private void removeIndex(int index) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index);
            --this.size;
            this.version = this.version < 0 ? this.version - 1 : this.version + 1;
        }

        private static Object[] growArray(Object[] array) {
            Object[] grow = new Object[Math.max(8, array.length * 3 / 2)];
            System.arraycopy(array, 0, grow, 0, array.length);
            return grow;
        }
    }
}

