﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/config/ConfigServiceRequest.h>
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/config/model/DescribeConfigRulesFilters.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace ConfigService {
namespace Model {

/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRulesRequest">AWS
 * API Reference</a></p>
 */
class DescribeConfigRulesRequest : public ConfigServiceRequest {
 public:
  AWS_CONFIGSERVICE_API DescribeConfigRulesRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeConfigRules"; }

  AWS_CONFIGSERVICE_API Aws::String SerializePayload() const override;

  AWS_CONFIGSERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The names of the Config rules for which you want details. If you do not
   * specify any names, Config returns details for all your rules.</p>
   */
  inline const Aws::Vector<Aws::String>& GetConfigRuleNames() const { return m_configRuleNames; }
  inline bool ConfigRuleNamesHasBeenSet() const { return m_configRuleNamesHasBeenSet; }
  template <typename ConfigRuleNamesT = Aws::Vector<Aws::String>>
  void SetConfigRuleNames(ConfigRuleNamesT&& value) {
    m_configRuleNamesHasBeenSet = true;
    m_configRuleNames = std::forward<ConfigRuleNamesT>(value);
  }
  template <typename ConfigRuleNamesT = Aws::Vector<Aws::String>>
  DescribeConfigRulesRequest& WithConfigRuleNames(ConfigRuleNamesT&& value) {
    SetConfigRuleNames(std::forward<ConfigRuleNamesT>(value));
    return *this;
  }
  template <typename ConfigRuleNamesT = Aws::String>
  DescribeConfigRulesRequest& AddConfigRuleNames(ConfigRuleNamesT&& value) {
    m_configRuleNamesHasBeenSet = true;
    m_configRuleNames.emplace_back(std::forward<ConfigRuleNamesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>nextToken</code> string returned on a previous page that you use to
   * get the next page of results in a paginated response.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeConfigRulesRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Returns a list of Detective or Proactive Config rules. By default, this API
   * returns an unfiltered list. For more information on Detective or Proactive
   * Config rules, see <a
   * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config-rules.html">
   * <b>Evaluation Mode</b> </a> in the <i>Config Developer Guide</i>.</p>
   */
  inline const DescribeConfigRulesFilters& GetFilters() const { return m_filters; }
  inline bool FiltersHasBeenSet() const { return m_filtersHasBeenSet; }
  template <typename FiltersT = DescribeConfigRulesFilters>
  void SetFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters = std::forward<FiltersT>(value);
  }
  template <typename FiltersT = DescribeConfigRulesFilters>
  DescribeConfigRulesRequest& WithFilters(FiltersT&& value) {
    SetFilters(std::forward<FiltersT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_configRuleNames;
  bool m_configRuleNamesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  DescribeConfigRulesFilters m_filters;
  bool m_filtersHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConfigService
}  // namespace Aws
