
use builtin;
use str;

set edit:completion:arg-completer[ruff] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'ruff'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'ruff'= {
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand check 'Run Ruff on the given files or directories'
            cand rule 'Explain a rule (or all rules)'
            cand config 'List or describe the available configuration options'
            cand linter 'List all supported upstream linters'
            cand clean 'Clear any caches in the current directory and any subdirectories'
            cand generate-shell-completion 'Generate shell completion'
            cand format 'Run the Ruff formatter on the given files or directories'
            cand server 'Run the language server'
            cand analyze 'Run analysis over Python source code'
            cand version 'Display Ruff''s version'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ruff;check'= {
            cand --output-format 'Output serialization format for violations. The default serialization format is "full"'
            cand -o 'Specify file to write the linter output to (default: stdout)'
            cand --output-file 'Specify file to write the linter output to (default: stdout)'
            cand --target-version 'The minimum Python version that should be supported'
            cand --select 'Comma-separated list of rule codes to enable (or ALL, to enable all rules)'
            cand --ignore 'Comma-separated list of rule codes to disable'
            cand --extend-select 'Like --select, but adds additional rule codes on top of those already specified'
            cand --extend-ignore 'Like --ignore. (Deprecated: You can just use --ignore instead.)'
            cand --per-file-ignores 'List of mappings from file pattern to code to exclude'
            cand --extend-per-file-ignores 'Like `--per-file-ignores`, but adds additional ignores on top of those already specified'
            cand --exclude 'List of paths, used to omit files and/or directories from analysis'
            cand --extend-exclude 'Like --exclude, but adds additional files and directories on top of those already excluded'
            cand --fixable 'List of rule codes to treat as eligible for fix. Only applicable when fix itself is enabled (e.g., via `--fix`)'
            cand --unfixable 'List of rule codes to treat as ineligible for fix. Only applicable when fix itself is enabled (e.g., via `--fix`)'
            cand --extend-fixable 'Like --fixable, but adds additional rule codes on top of those already specified'
            cand --extend-unfixable 'Like --unfixable. (Deprecated: You can just use --unfixable instead.)'
            cand --line-length 'Set the line-length for length-associated rules and automatic formatting'
            cand --dummy-variable-rgx 'Regular expression matching the name of dummy variables'
            cand --cache-dir 'Path to the cache directory'
            cand --stdin-filename 'The name of the file when passing it through stdin'
            cand --extension 'List of mappings from file extension to language (one of `python`, `ipynb`, `pyi`). For example, to treat `.ipy` files as IPython notebooks, use `--extension ipy:ipynb`'
            cand --add-noqa 'Enable automatic additions of `noqa` directives to failing lines. Optionally provide a reason to append after the codes'
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand --fix 'Apply fixes to resolve lint violations. Use `--no-fix` to disable or `--unsafe-fixes` to include unsafe fixes'
            cand --no-fix 'no-fix'
            cand --unsafe-fixes 'Include fixes that may not retain the original intent of the code. Use `--no-unsafe-fixes` to disable'
            cand --no-unsafe-fixes 'no-unsafe-fixes'
            cand --show-fixes 'Show an enumeration of all fixed lint violations. Use `--no-show-fixes` to disable'
            cand --no-show-fixes 'no-show-fixes'
            cand --diff 'Avoid writing any fixed files back; instead, output a diff for each changed file to stdout, and exit 0 if there are no diffs. Implies `--fix-only`'
            cand -w 'Run in watch mode by re-running whenever files change'
            cand --watch 'Run in watch mode by re-running whenever files change'
            cand --fix-only 'Apply fixes to resolve lint violations, but don''t report on, or exit non-zero for, leftover violations. Implies `--fix`. Use `--no-fix-only` to disable or `--unsafe-fixes` to include unsafe fixes'
            cand --no-fix-only 'no-fix-only'
            cand --ignore-noqa 'Ignore any `# noqa` comments'
            cand --preview 'Enable preview mode; checks will include unstable rules and fixes. Use `--no-preview` to disable'
            cand --no-preview 'no-preview'
            cand --respect-gitignore 'Respect file exclusions via `.gitignore` and other standard ignore files. Use `--no-respect-gitignore` to disable'
            cand --no-respect-gitignore 'no-respect-gitignore'
            cand --force-exclude 'Enforce exclusions, even for paths passed to Ruff directly on the command-line. Use `--no-force-exclude` to disable'
            cand --no-force-exclude 'no-force-exclude'
            cand -n 'Disable cache reads'
            cand --no-cache 'Disable cache reads'
            cand -e 'Exit with status code "0", even upon detecting lint violations'
            cand --exit-zero 'Exit with status code "0", even upon detecting lint violations'
            cand --exit-non-zero-on-fix 'Exit with a non-zero status code if any files were modified via fix, even if no lint violations remain'
            cand --statistics 'Show counts for every rule with at least one violation'
            cand --show-files 'See the files Ruff will be run against with the current settings'
            cand --show-settings 'See the settings Ruff will use to lint a given Python file'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ruff;rule'= {
            cand --output-format 'Output format'
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand --all 'Explain all rules'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ruff;config'= {
            cand --output-format 'Output format'
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ruff;linter'= {
            cand --output-format 'Output format'
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ruff;clean'= {
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ruff;generate-shell-completion'= {
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ruff;format'= {
            cand --cache-dir 'Path to the cache directory'
            cand --exclude 'List of paths, used to omit files and/or directories from analysis'
            cand --line-length 'Set the line-length'
            cand --stdin-filename 'The name of the file when passing it through stdin'
            cand --extension 'List of mappings from file extension to language (one of `python`, `ipynb`, `pyi`). For example, to treat `.ipy` files as IPython notebooks, use `--extension ipy:ipynb`'
            cand --target-version 'The minimum Python version that should be supported'
            cand --range 'When specified, Ruff will try to only format the code in the given range. It might be necessary to extend the start backwards or the end forwards, to fully enclose a logical line. The `<RANGE>` uses the format `<start_line>:<start_column>-<end_line>:<end_column>`.'
            cand --output-format 'Output serialization format for violations, when used with `--check`. The default serialization format is "full"'
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand --check 'Avoid writing any formatted files back; instead, exit with a non-zero status code if any files would have been modified, and zero otherwise'
            cand --diff 'Avoid writing any formatted files back; instead, exit with a non-zero status code and the difference between the current file and how the formatted file would look like'
            cand -n 'Disable cache reads'
            cand --no-cache 'Disable cache reads'
            cand --respect-gitignore 'Respect file exclusions via `.gitignore` and other standard ignore files. Use `--no-respect-gitignore` to disable'
            cand --no-respect-gitignore 'no-respect-gitignore'
            cand --force-exclude 'Enforce exclusions, even for paths passed to Ruff directly on the command-line. Use `--no-force-exclude` to disable'
            cand --no-force-exclude 'no-force-exclude'
            cand --preview 'Enable preview mode; enables unstable formatting. Use `--no-preview` to disable'
            cand --no-preview 'no-preview'
            cand --exit-non-zero-on-format 'Exit with a non-zero status code if any files were modified via format, even if all files were formatted successfully'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ruff;server'= {
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand --preview 'Enable preview mode. Use `--no-preview` to disable'
            cand --no-preview 'no-preview'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ruff;analyze'= {
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help'
            cand --help 'Print help'
            cand graph 'Generate a map of Python file dependencies or dependents'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ruff;analyze;graph'= {
            cand --direction 'The direction of the import map. By default, generates a dependency map, i.e., a map from file to files that it depends on. Use `--direction dependents` to generate a map from file to files that depend on it'
            cand --min-dots 'The minimum number of dots in a string import to consider it a valid import'
            cand --target-version 'The minimum Python version that should be supported'
            cand --python 'Path to a virtual environment to use for resolving additional dependencies'
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand --detect-string-imports 'Attempt to detect imports from string literals'
            cand --preview 'Enable preview mode. Use `--no-preview` to disable'
            cand --no-preview 'no-preview'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ruff;analyze;help'= {
            cand graph 'Generate a map of Python file dependencies or dependents'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ruff;analyze;help;graph'= {
        }
        &'ruff;analyze;help;help'= {
        }
        &'ruff;version'= {
            cand --output-format 'output-format'
            cand --config 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`'
            cand -v 'Enable verbose logging'
            cand --verbose 'Enable verbose logging'
            cand -q 'Print diagnostics, but nothing else'
            cand --quiet 'Print diagnostics, but nothing else'
            cand -s 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --silent 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
            cand --isolated 'Ignore all configuration files'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ruff;help'= {
            cand check 'Run Ruff on the given files or directories'
            cand rule 'Explain a rule (or all rules)'
            cand config 'List or describe the available configuration options'
            cand linter 'List all supported upstream linters'
            cand clean 'Clear any caches in the current directory and any subdirectories'
            cand generate-shell-completion 'Generate shell completion'
            cand format 'Run the Ruff formatter on the given files or directories'
            cand server 'Run the language server'
            cand analyze 'Run analysis over Python source code'
            cand version 'Display Ruff''s version'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ruff;help;check'= {
        }
        &'ruff;help;rule'= {
        }
        &'ruff;help;config'= {
        }
        &'ruff;help;linter'= {
        }
        &'ruff;help;clean'= {
        }
        &'ruff;help;generate-shell-completion'= {
        }
        &'ruff;help;format'= {
        }
        &'ruff;help;server'= {
        }
        &'ruff;help;analyze'= {
            cand graph 'Generate a map of Python file dependencies or dependents'
        }
        &'ruff;help;analyze;graph'= {
        }
        &'ruff;help;version'= {
        }
        &'ruff;help;help'= {
        }
    ]
    $completions[$command]
}
