/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.VcsLogSharedSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0005\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0001\u001a\u001a\u0010\f\u001a\u00020\n*\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000fH\u0000\u001a\u001e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0002\"\u0015\u0010\u0013\u001a\u00020\u0001*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"isIndexingPausedFor", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isScheduledForIndexing", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "needIndexing", "isIndexingPaused", "isIndexingScheduled", "toggleIndexing", "", "Lcom/intellij/vcs/log/data/index/VcsLogModifiableIndex;", "resumeIndexing", "roots", "", "Lcom/intellij/vcs/log/data/VcsLogData;", "enableIndexing", "project", "Lcom/intellij/openapi/project/Project;", "isIndexingEnabled", "(Lcom/intellij/openapi/project/Project;)Z", "intellij.platform.vcs.log.impl"})
@JvmName(name="VcsLogIndexUtils")
@SourceDebugExtension(value={"SMAP\nVcsLogIndexUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogIndexUtils.kt\ncom/intellij/vcs/log/data/index/VcsLogIndexUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,93:1\n774#2:94\n865#2,2:95\n774#2:97\n865#2,2:98\n1740#2,3:100\n1761#2,3:103\n774#2:106\n865#2,2:107\n1869#2,2:109\n774#2:111\n865#2,2:112\n1869#2,2:114\n30#3,2:116\n*S KotlinDebug\n*F\n+ 1 VcsLogIndexUtils.kt\ncom/intellij/vcs/log/data/index/VcsLogIndexUtils\n*L\n23#1:94\n23#1:95,2\n24#1:97\n24#1:98,2\n33#1:100,3\n40#1:103,3\n49#1:106\n49#1:107,2\n49#1:109,2\n52#1:111\n52#1:112,2\n84#1:114,2\n86#1:116,2\n*E\n"})
public final class VcsLogIndexUtils {
    public static final boolean isIndexingPausedFor(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return VcsLogBigRepositoriesList.getInstance().isBig(root);
    }

    public static final boolean isScheduledForIndexing(@NotNull VcsLogIndex $this$isScheduledForIndexing, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)$this$isScheduledForIndexing, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return $this$isScheduledForIndexing.isIndexingEnabled(root) && !$this$isScheduledForIndexing.isIndexed(root);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean needIndexing(@NotNull VcsLogIndex $this$needIndexing) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$needIndexing, (String)"<this>");
        Set<VirtualFile> set = $this$needIndexing.getIndexingRoots();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getIndexingRoots(...)");
        Set<VirtualFile> rootsForIndexing = set;
        if (rootsForIndexing.isEmpty()) {
            return false;
        }
        Iterable $this$filter$iv = rootsForIndexing;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!VcsLogIndexUtils.isScheduledForIndexing($this$needIndexing, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List rootsScheduledForIndexing = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = rootsForIndexing;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!VcsLogIndexUtils.isIndexingPausedFor(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List rootsWithPausedIndexing = (List)destination$iv$iv2;
        return !((Collection)rootsWithPausedIndexing).isEmpty() || !((Collection)rootsScheduledForIndexing).isEmpty();
    }

    public static final boolean isIndexingPaused(@NotNull VcsLogIndex $this$isIndexingPaused) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isIndexingPaused, (String)"<this>");
            Set<VirtualFile> set = $this$isIndexingPaused.getIndexingRoots();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getIndexingRoots(...)");
            Iterable $this$all$iv = set;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (VcsLogIndexUtils.isIndexingPausedFor(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isIndexingScheduled(@NotNull VcsLogIndex $this$isIndexingScheduled) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isIndexingScheduled, (String)"<this>");
            Set<VirtualFile> set = $this$isIndexingScheduled.getIndexingRoots();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getIndexingRoots(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!VcsLogIndexUtils.isScheduledForIndexing($this$isIndexingScheduled, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static final void toggleIndexing(@NotNull VcsLogModifiableIndex $this$toggleIndexing) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleIndexing, (String)"<this>");
        if (VcsLogIndexUtils.isIndexingScheduled($this$toggleIndexing)) {
            Iterator $this$filterTo$iv$iv;
            Set<VirtualFile> set = $this$toggleIndexing.getIndexingRoots();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getIndexingRoots(...)");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(!VcsLogIndexUtils.isIndexingPausedFor(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                VcsLogBigRepositoriesList.getInstance().addRepository(it);
            }
        } else {
            void $this$filter$iv;
            Set<VirtualFile> set = $this$toggleIndexing.getIndexingRoots();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getIndexingRoots(...)");
            Iterable $this$forEach$iv = set;
            VcsLogModifiableIndex vcsLogModifiableIndex = $this$toggleIndexing;
            boolean $i$f$filter = false;
            void $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!VcsLogIndexUtils.isIndexingPausedFor(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            VcsLogIndexUtils.resumeIndexing(vcsLogModifiableIndex, (List)destination$iv$iv);
        }
    }

    private static final void resumeIndexing(VcsLogModifiableIndex $this$resumeIndexing, Collection<? extends VirtualFile> roots) {
        boolean resumed = false;
        for (VirtualFile virtualFile : roots) {
            resumed |= VcsLogBigRepositoriesList.getInstance().removeRepository(virtualFile);
        }
        if (resumed) {
            $this$resumeIndexing.scheduleIndex(true);
        }
    }

    public static final void toggleIndexing(@NotNull VcsLogData $this$toggleIndexing) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleIndexing, (String)"<this>");
        Project project = $this$toggleIndexing.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (VcsLogIndexUtils.enableIndexing(project, (Collection<? extends VirtualFile>)VcsLogPersistentIndex.getAvailableIndexers($this$toggleIndexing.getLogProviders()).keySet())) {
            return;
        }
        VcsLogIndex vcsLogIndex = $this$toggleIndexing.getIndex();
        VcsLogModifiableIndex vcsLogModifiableIndex = vcsLogIndex instanceof VcsLogModifiableIndex ? (VcsLogModifiableIndex)vcsLogIndex : null;
        if (vcsLogModifiableIndex == null) {
            return;
        }
        VcsLogModifiableIndex index = vcsLogModifiableIndex;
        if (index.getIndexingRoots().isEmpty()) {
            return;
        }
        VcsLogIndexUtils.toggleIndexing(index);
    }

    private static final boolean enableIndexing(Project project, Collection<? extends VirtualFile> roots) {
        if (VcsLogIndexUtils.isIndexingEnabled(project)) {
            return false;
        }
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            VcsLogBigRepositoriesList.getInstance().removeRepository(it);
        }
        VcsLogData.getIndexingRegistryValue().setValue(true);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<VcsLogSharedSettings> serviceClass$iv = VcsLogSharedSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((VcsLogSharedSettings)object).setIndexSwitchedOn(true);
        return true;
    }

    public static final boolean isIndexingEnabled(@NotNull Project $this$isIndexingEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isIndexingEnabled, (String)"<this>");
        return VcsLogData.isIndexSwitchedOnInRegistry() && VcsLogSharedSettings.isIndexSwitchedOn($this$isIndexingEnabled);
    }
}

