/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.SslEntityReaderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class SslEntityReader {
    private static SslEntityReader ourInstance;

    @NotNull
    public static SslEntityReader getInstance() {
        SslEntityReader res = ourInstance;
        if (res == null) {
            ourInstance = res = new SslEntityReaderImpl();
        }
        SslEntityReader sslEntityReader = res;
        if (sslEntityReader == null) {
            SslEntityReader.$$$reportNull$$$0(0);
        }
        return sslEntityReader;
    }

    @Nullable
    public static SslEntityReader setInstance(@Nullable SslEntityReader reader) {
        SslEntityReader prev = ourInstance;
        ourInstance = reader;
        return prev;
    }

    @NotNull
    public abstract List<? extends Entity> read(@NotNull InputStream var1) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslEntityReader", "getInstance"));
    }

    public static interface UnencryptedPrivateKeyEntity
    extends PrivateKeyEntity {
        public PrivateKey get() throws IOException;
    }

    public static interface EncryptedPrivateKeyEntity
    extends PrivateKeyEntity {
        public PrivateKey get(char[] var1) throws IOException;
    }

    public static interface CertificateEntity
    extends Entity {
        public X509Certificate get() throws IOException;
    }

    public static interface PrivateKeyEntity
    extends Entity {
    }

    public static interface Entity {
    }
}

