/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.markup.CustomHighlighterOrder;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.ui.GradientTextureCache;
import org.jetbrains.plugins.terminal.block.ui.TerminalBlockBackgroundRendererKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/block/ui/TerminalBlockBackgroundRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "backgroundKey", "Lcom/intellij/openapi/editor/colors/ColorKey;", "gradientCache", "Lorg/jetbrains/plugins/terminal/block/ui/GradientTextureCache;", "<init>", "(Lcom/intellij/openapi/editor/colors/ColorKey;Lorg/jetbrains/plugins/terminal/block/ui/GradientTextureCache;)V", "(Lcom/intellij/openapi/editor/colors/ColorKey;)V", "(Lorg/jetbrains/plugins/terminal/block/ui/GradientTextureCache;)V", "getOrder", "Lcom/intellij/openapi/editor/markup/CustomHighlighterOrder;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "intellij.terminal"})
public final class TerminalBlockBackgroundRenderer
implements CustomHighlighterRenderer {
    @Nullable
    private final ColorKey backgroundKey;
    @Nullable
    private final GradientTextureCache gradientCache;

    private TerminalBlockBackgroundRenderer(ColorKey backgroundKey, GradientTextureCache gradientCache) {
        this.backgroundKey = backgroundKey;
        this.gradientCache = gradientCache;
    }

    public TerminalBlockBackgroundRenderer(@NotNull ColorKey backgroundKey) {
        Intrinsics.checkNotNullParameter((Object)backgroundKey, (String)"backgroundKey");
        this(backgroundKey, null);
    }

    public TerminalBlockBackgroundRenderer(@NotNull GradientTextureCache gradientCache) {
        Intrinsics.checkNotNullParameter((Object)gradientCache, (String)"gradientCache");
        this(null, gradientCache);
    }

    @NotNull
    public CustomHighlighterOrder getOrder() {
        return CustomHighlighterOrder.BEFORE_BACKGROUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int width = visibleArea.width - JBUI.scale((int)10);
        float topY = editor.offsetToXY((int)highlighter.getStartOffset()).y;
        float bottomY = (float)editor.offsetToXY((int)highlighter.getEndOffset()).y + (float)editor.getLineHeight();
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, topY, width, bottomY - topY);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            Paint paint = TerminalBlockBackgroundRendererKt.getBlockBackgroundPaint(editor, g2d, width, this.gradientCache, this.backgroundKey);
            if (paint != null) {
                Paint it = paint;
                boolean bl = false;
                g2d.setPaint(it);
                g2d.fill(rect);
            }
        }
        finally {
            g2d.dispose();
        }
    }
}

