/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.internal.annotation.InternalApi;

@InternalApi
public class JScrollPaneDriver
extends JComponentDriver {
    public JScrollPaneDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @Nonnull
    @RunsInEDT
    public JScrollBar horizontalScrollBarIn(@Nonnull JScrollPane scrollPane) {
        return JScrollPaneDriver.horizontalScrollBar(scrollPane);
    }

    @Nonnull
    @RunsInEDT
    private static JScrollBar horizontalScrollBar(@Nonnull JScrollPane scrollPane) {
        JScrollBar result = GuiActionRunner.execute(() -> scrollPane.getHorizontalScrollBar());
        return (JScrollBar)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @RunsInEDT
    public JScrollBar verticalScrollBarIn(@Nonnull JScrollPane scrollPane) {
        return JScrollPaneDriver.verticalScrollBar(scrollPane);
    }

    @Nonnull
    @RunsInEDT
    private static JScrollBar verticalScrollBar(@Nonnull JScrollPane scrollPane) {
        JScrollBar result = GuiActionRunner.execute(() -> scrollPane.getVerticalScrollBar());
        return (JScrollBar)Preconditions.checkNotNull((Object)result);
    }
}

