/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringSearcher;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class InjectorUtils {
    public static final Comparator<TextRange> RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.intersects(o2)) {
            return 0;
        }
        return o1.getStartOffset() - o2.getStartOffset();
    };
    private static final Pattern MAP_ENTRY_PATTERN = Pattern.compile("([\\S&&[^=]]+)=(\"(?:[^\"]|\\\\\")*\"|\\S*)");

    private InjectorUtils() {
    }

    @Nullable
    public static Language getLanguage(@NotNull BaseInjection injection) {
        if (injection == null) {
            InjectorUtils.$$$reportNull$$$0(0);
        }
        return InjectorUtils.getLanguageByString(injection.getInjectedLanguageId());
    }

    @Nullable
    public static Language getLanguageByString(@NotNull String languageId) {
        Language language;
        if (languageId == null) {
            InjectorUtils.$$$reportNull$$$0(1);
        }
        if ((language = InjectedLanguage.findLanguageById(languageId)) != null) {
            return language;
        }
        ReferenceInjector injector = ReferenceInjector.findById((String)languageId);
        if (injector != null) {
            return injector.toLanguage();
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType fileType = fileTypeManager.getFileTypeByExtension(languageId);
        if (fileType instanceof LanguageFileType) {
            return ((LanguageFileType)fileType).getLanguage();
        }
        LightVirtualFile virtualFileNamedAsLanguageId = new LightVirtualFile(languageId);
        LightVirtualFile virtualFileWithLanguageIdAsExtension = new LightVirtualFile("textmate." + languageId);
        for (FileType registeredFileType : fileTypeManager.getRegisteredFileTypes()) {
            if (!(registeredFileType instanceof FileTypeIdentifiableByVirtualFile) || !(registeredFileType instanceof LanguageFileType) || !((FileTypeIdentifiableByVirtualFile)registeredFileType).isMyFileType((VirtualFile)virtualFileNamedAsLanguageId) && !((FileTypeIdentifiableByVirtualFile)registeredFileType).isMyFileType((VirtualFile)virtualFileWithLanguageIdAsExtension)) continue;
            return ((LanguageFileType)registeredFileType).getLanguage();
        }
        return null;
    }

    public static boolean registerInjectionSimple(@NotNull PsiLanguageInjectionHost host, @NotNull BaseInjection injection, @Nullable LanguageInjectionSupport support, @NotNull MultiHostRegistrar registrar) {
        Language language;
        if (host == null) {
            InjectorUtils.$$$reportNull$$$0(2);
        }
        if (injection == null) {
            InjectorUtils.$$$reportNull$$$0(3);
        }
        if (registrar == null) {
            InjectorUtils.$$$reportNull$$$0(4);
        }
        if ((language = InjectorUtils.getLanguage(injection)) == null) {
            return false;
        }
        InjectedLanguage injectedLanguage = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
        List<TextRange> ranges = injection.getInjectedArea((PsiElement)host);
        ArrayList<InjectionInfo> list = new ArrayList<InjectionInfo>(ranges.size());
        for (TextRange range : ranges) {
            list.add(new InjectionInfo(host, injectedLanguage, range));
        }
        InjectorUtils.registerInjection(language, host.getContainingFile(), list, registrar, it -> {
            if (support != null) {
                InjectorUtils.registerSupport(it, support, true);
            }
        });
        return !ranges.isEmpty();
    }

    public static void registerInjection(@Nullable Language language, @NotNull PsiFile containingFile, @NotNull List<InjectionInfo> list, @NotNull MultiHostRegistrar registrar) {
        if (containingFile == null) {
            InjectorUtils.$$$reportNull$$$0(5);
        }
        if (list == null) {
            InjectorUtils.$$$reportNull$$$0(6);
        }
        if (registrar == null) {
            InjectorUtils.$$$reportNull$$$0(7);
        }
        InjectorUtils.registerInjection(language, containingFile, list, registrar, null);
    }

    public static void registerInjection(@Nullable Language language, @NotNull PsiFile containingFile, @NotNull List<InjectionInfo> list, @NotNull MultiHostRegistrar registrar, @Nullable Consumer<MultiHostRegistrar> customizeInjection) {
        if (containingFile == null) {
            InjectorUtils.$$$reportNull$$$0(8);
        }
        if (list == null) {
            InjectorUtils.$$$reportNull$$$0(9);
        }
        if (registrar == null) {
            InjectorUtils.$$$reportNull$$$0(10);
        }
        if (language == null) {
            return;
        }
        ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
        if (parser == null && injector != null) {
            Iterator<InjectionInfo> iterator = list.iterator();
            if (iterator.hasNext()) {
                InjectionInfo trinity = iterator.next();
                String prefix = trinity.language().getPrefix();
                String suffix = trinity.language().getSuffix();
                PsiLanguageInjectionHost host = trinity.host();
                TextRange textRange = trinity.range();
                InjectedLanguageUtil.injectReference((MultiHostRegistrar)registrar, (Language)language, (String)prefix, (String)suffix, (PsiLanguageInjectionHost)host, (TextRange)textRange);
                return;
            }
            return;
        }
        boolean injectionStarted = false;
        for (InjectionInfo t : list) {
            PsiLanguageInjectionHost host = t.host();
            if (host.getContainingFile() != containingFile || !host.isValidHost()) continue;
            TextRange textRange = t.range();
            InjectedLanguage injectedLanguage = t.language();
            if (!injectionStarted) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)language.getID(), (CharSequence)t.language().getID())) {
                    registrar.startInjecting(language, StringUtil.toLowerCase((String)t.language().getID()));
                } else {
                    registrar.startInjecting(language);
                }
                injectionStarted = true;
            }
            registrar.addPlace(injectedLanguage.getPrefix(), injectedLanguage.getSuffix(), host, textRange);
        }
        if (customizeInjection != null) {
            customizeInjection.accept(registrar);
        }
        if (injectionStarted) {
            registrar.doneInjecting();
        }
    }

    @NotNull
    public static @Unmodifiable Collection<String> getActiveInjectionSupportIds() {
        List list = ContainerUtil.map((Collection)LanguageInjectionSupport.EP_NAME.getExtensionList(), LanguageInjectionSupport::getId);
        if (list == null) {
            InjectorUtils.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static Collection<LanguageInjectionSupport> getActiveInjectionSupports() {
        List list = LanguageInjectionSupport.EP_NAME.getExtensionList();
        if (list == null) {
            InjectorUtils.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public static LanguageInjectionSupport findInjectionSupport(@NotNull String id) {
        if (id == null) {
            InjectorUtils.$$$reportNull$$$0(13);
        }
        if ("temp".equals(id)) {
            return new TemporaryLanguageInjectionSupport();
        }
        for (LanguageInjectionSupport support : LanguageInjectionSupport.EP_NAME.getExtensionList()) {
            if (!id.equals(support.getId())) continue;
            return support;
        }
        return null;
    }

    public static Class<?> @NotNull [] getPatternClasses(@NotNull String supportId) {
        LanguageInjectionSupport support;
        if (supportId == null) {
            InjectorUtils.$$$reportNull$$$0(14);
        }
        Class[] classArray = (support = InjectorUtils.findInjectionSupport(supportId)) == null ? ArrayUtil.EMPTY_CLASS_ARRAY : support.getPatternClasses();
        if (classArray == null) {
            InjectorUtils.$$$reportNull$$$0(15);
        }
        return classArray;
    }

    @NotNull
    public static LanguageInjectionSupport findNotNullInjectionSupport(@NotNull String id) {
        LanguageInjectionSupport result;
        if (id == null) {
            InjectorUtils.$$$reportNull$$$0(16);
        }
        if ((result = InjectorUtils.findInjectionSupport(id)) == null) {
            throw new IllegalStateException(id + " injector not found");
        }
        LanguageInjectionSupport languageInjectionSupport = result;
        if (languageInjectionSupport == null) {
            InjectorUtils.$$$reportNull$$$0(17);
        }
        return languageInjectionSupport;
    }

    @NotNull
    public static StringBuilder appendStringPattern(@NotNull StringBuilder sb, @NotNull String prefix, @NotNull String text, @NotNull String suffix) {
        if (sb == null) {
            InjectorUtils.$$$reportNull$$$0(18);
        }
        if (prefix == null) {
            InjectorUtils.$$$reportNull$$$0(19);
        }
        if (text == null) {
            InjectorUtils.$$$reportNull$$$0(20);
        }
        if (suffix == null) {
            InjectorUtils.$$$reportNull$$$0(21);
        }
        sb.append(prefix).append("string().");
        String[] parts = text.split("[,|\\s]+");
        boolean useMatches = false;
        for (String part : parts) {
            if (!InjectorUtils.isRegexp(part)) continue;
            useMatches = true;
            break;
        }
        if (useMatches) {
            sb.append("matches(\"").append(text).append("\")");
        } else if (parts.length > 1) {
            sb.append("oneOf(");
            boolean first = true;
            for (String part : parts) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("\"").append(part).append("\"");
            }
            sb.append(")");
        } else {
            sb.append("equalTo(\"").append(text).append("\")");
        }
        sb.append(suffix);
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            InjectorUtils.$$$reportNull$$$0(22);
        }
        return stringBuilder;
    }

    public static boolean isRegexp(@NotNull String s) {
        if (s == null) {
            InjectorUtils.$$$reportNull$$$0(23);
        }
        boolean hasReChars = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '_' || c == '-' || Character.isLetterOrDigit(c)) continue;
            hasReChars = true;
            break;
        }
        if (hasReChars) {
            try {
                new URL(s);
            }
            catch (MalformedURLException e) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static void registerSupport(@NotNull LanguageInjectionSupport support, boolean settingsAvailable, @NotNull PsiElement element, @NotNull Language language) {
        if (support == null) {
            InjectorUtils.$$$reportNull$$$0(24);
        }
        if (element == null) {
            InjectorUtils.$$$reportNull$$$0(25);
        }
        if (language == null) {
            InjectorUtils.$$$reportNull$$$0(26);
        }
        InjectorUtils.putInjectedFileUserData(element, language, LanguageInjectionSupport.INJECTOR_SUPPORT, support);
        if (settingsAvailable) {
            InjectorUtils.putInjectedFileUserData(element, language, LanguageInjectionSupport.SETTINGS_EDITOR, support);
        }
    }

    public static void registerSupport(@NotNull MultiHostRegistrar registrar, @NotNull LanguageInjectionSupport support, boolean settingsAvailable) {
        if (registrar == null) {
            InjectorUtils.$$$reportNull$$$0(27);
        }
        if (support == null) {
            InjectorUtils.$$$reportNull$$$0(28);
        }
        registrar.putInjectedFileUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)support);
        if (settingsAvailable) {
            registrar.putInjectedFileUserData(LanguageInjectionSupport.SETTINGS_EDITOR, (Object)support);
        }
    }

    @Deprecated
    public static <T> void putInjectedFileUserData(@NotNull PsiElement element, @NotNull Language language, @NotNull Key<T> key, @Nullable T value) {
        if (element == null) {
            InjectorUtils.$$$reportNull$$$0(29);
        }
        if (language == null) {
            InjectorUtils.$$$reportNull$$$0(30);
        }
        if (key == null) {
            InjectorUtils.$$$reportNull$$$0(31);
        }
        InjectedLanguageUtil.putInjectedFileUserData((PsiElement)element, (Language)language, key, value);
    }

    public static Configuration getEditableInstance(@NotNull Project project) {
        if (project == null) {
            InjectorUtils.$$$reportNull$$$0(32);
        }
        return Configuration.getInstance();
    }

    public static boolean canBeRemoved(@NotNull BaseInjection injection) {
        if (injection == null) {
            InjectorUtils.$$$reportNull$$$0(33);
        }
        if (injection.isEnabled()) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)injection.getPrefix()) || StringUtil.isNotEmpty((String)injection.getSuffix())) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)injection.getValuePattern());
    }

    @Nullable
    private static CommentInjectionData findCommentInjectionData(@NotNull PsiElement context, @Nullable Ref<? super PsiElement> causeRef) {
        if (context == null) {
            InjectorUtils.$$$reportNull$$$0(34);
        }
        return InjectorUtils.findCommentInjectionData(context, true, causeRef);
    }

    @Nullable
    public static Pair.NonNull<PsiComment, CommentInjectionData> findClosestCommentInjectionData(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            InjectorUtils.$$$reportNull$$$0(35);
        }
        if ((file = context.getContainingFile()) == null) {
            return null;
        }
        TreeMap<TextRange, CommentInjectionData> map = InjectorUtils.getInjectionMap(file);
        if (map == null) {
            return null;
        }
        Map.Entry<TextRange, CommentInjectionData> entry = map.lowerEntry(context.getTextRange());
        if (entry == null) {
            return null;
        }
        PsiComment psiComment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)entry.getKey().getStartOffset(), PsiComment.class, (boolean)false);
        if (psiComment == null) {
            return null;
        }
        return Pair.createNonNull((Object)psiComment, (Object)entry.getValue());
    }

    @Nullable
    public static CommentInjectionData findCommentInjectionData(@NotNull PsiElement context, boolean treeElementsIncludeComment, @Nullable Ref<? super PsiElement> causeRef) {
        PsiElement target;
        Pair.NonNull<PsiComment, CommentInjectionData> pair;
        if (context == null) {
            InjectorUtils.$$$reportNull$$$0(36);
        }
        if ((pair = InjectorUtils.findClosestCommentInjectionData(target = CompletionUtil.getOriginalOrSelf((PsiElement)context))) == null) {
            return null;
        }
        PsiComment psiComment = (PsiComment)pair.first;
        CommentInjectionData injectionData = (CommentInjectionData)pair.second;
        TextRange r0 = psiComment.getTextRange();
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)psiComment, (PsiElement)target);
        if (commonParent == null) {
            return null;
        }
        PsiElement topmostElement = target;
        for (PsiElement parent = target; parent != null && (treeElementsIncludeComment ? parent : parent.getParent()) != commonParent; parent = parent.getParent()) {
            topmostElement = parent;
        }
        int off1 = r0.getEndOffset();
        int off2 = topmostElement.getTextRange().getStartOffset();
        if (off2 - off1 > 120) {
            return null;
        }
        if (off2 - off1 > 2) {
            PsiElement e;
            Supplier<PsiElement> producer = InjectorUtils.prevWalker(topmostElement, commonParent);
            while ((e = producer.get()) != null && e != psiComment) {
                if (!(e instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)e).isValidHost() || StringUtil.isEmptyOrSpaces((String)e.getText())) continue;
                return null;
            }
        }
        if (causeRef != null) {
            causeRef.set((Object)psiComment);
        }
        return injectionData;
    }

    @Nullable
    public static BaseInjection findCommentInjection(@NotNull PsiElement context, @NotNull String supportId, @Nullable Ref<? super PsiElement> causeRef) {
        CommentInjectionData data;
        if (context == null) {
            InjectorUtils.$$$reportNull$$$0(37);
        }
        if (supportId == null) {
            InjectorUtils.$$$reportNull$$$0(38);
        }
        if ((data = InjectorUtils.findCommentInjectionData(context, causeRef)) == null) {
            return null;
        }
        BaseInjection injection = new BaseInjection(supportId);
        injection.setPrefix(data.getPrefix());
        injection.setSuffix(data.getSuffix());
        injection.setInjectedLanguageId(data.getInjectedLanguageId());
        injection.setDisplayName(data.getDisplayName());
        return injection;
    }

    @Nullable
    private static TreeMap<TextRange, CommentInjectionData> getInjectionMap(@NotNull PsiFile file) {
        if (file == null) {
            InjectorUtils.$$$reportNull$$$0(39);
        }
        return (TreeMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            TreeMap<TextRange, CommentInjectionData> map = InjectorUtils.calcInjections(file);
            return CachedValueProvider.Result.create(map.isEmpty() ? null : map, (Object[])new Object[]{file});
        });
    }

    @NotNull
    private static TreeMap<TextRange, CommentInjectionData> calcInjections(@NotNull PsiFile file) {
        if (file == null) {
            InjectorUtils.$$$reportNull$$$0(40);
        }
        TreeMap<TextRange, CommentInjectionData> injectionMap = new TreeMap<TextRange, CommentInjectionData>(RANGE_COMPARATOR);
        StringSearcher searcher = new StringSearcher("language=", true, true, false);
        CharSequence contents = file.getViewProvider().getContents();
        char[] contentsArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)contents);
        int s0 = 0;
        int s1 = contents.length();
        int idx = searcher.scan(contents, contentsArray, s0, s1);
        while (idx != -1) {
            PsiComment element = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)idx, PsiComment.class, (boolean)false);
            if (element != null) {
                CommentInjectionData injection;
                String str = ElementManipulators.getValueText((PsiElement)element).trim();
                CommentInjectionData commentInjectionData = injection = str.startsWith("language=") ? new CommentInjectionData(InjectorUtils.decodeMap(str), str) : null;
                if (injection != null) {
                    injectionMap.put(element.getTextRange(), injection);
                }
            }
            idx = searcher.scan(contents, contentsArray, idx + 1, s1);
        }
        TreeMap<TextRange, CommentInjectionData> treeMap = injectionMap;
        if (treeMap == null) {
            InjectorUtils.$$$reportNull$$$0(41);
        }
        return treeMap;
    }

    @NotNull
    private static Map<String, String> decodeMap(@NotNull CharSequence charSequence) {
        if (charSequence == null) {
            InjectorUtils.$$$reportNull$$$0(42);
        }
        if (StringUtil.isEmpty((CharSequence)charSequence)) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                InjectorUtils.$$$reportNull$$$0(43);
            }
            return map;
        }
        Matcher matcher = MAP_ENTRY_PATTERN.matcher(charSequence);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            map.put(StringUtil.unescapeStringCharacters((String)matcher.group(1)), StringUtil.unescapeStringCharacters((String)StringUtil.unquoteString((String)matcher.group(2))));
        }
        LinkedHashMap<String, String> linkedHashMap = map;
        if (linkedHashMap == null) {
            InjectorUtils.$$$reportNull$$$0(44);
        }
        return linkedHashMap;
    }

    @NotNull
    private static Supplier<PsiElement> prevWalker(final @NotNull PsiElement element, final @NotNull PsiElement scope) {
        if (element == null) {
            InjectorUtils.$$$reportNull$$$0(45);
        }
        if (scope == null) {
            InjectorUtils.$$$reportNull$$$0(46);
        }
        return new Supplier<PsiElement>(){
            PsiElement e;
            {
                this.e = element;
            }

            @Override
            @Nullable
            public PsiElement get() {
                if (this.e == null || this.e == scope) {
                    return null;
                }
                PsiElement prev = this.e.getPrevSibling();
                if (prev != null) {
                    this.e = PsiTreeUtil.getDeepestLast((PsiElement)prev);
                    return this.e;
                }
                PsiElement parent = this.e.getParent();
                this.e = parent == scope || parent instanceof PsiFile ? null : parent;
                return this.e;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 15, 17, 22, 41, 43, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 22: 
            case 41: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/InjectorUtils";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 14: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 25: 
            case 29: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSequence";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/InjectorUtils";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveInjectionSupportIds";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveInjectionSupports";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findNotNullInjectionSupport";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "appendStringPattern";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInjections";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageByString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerInjectionSimple";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerInjection";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 22: 
            case 41: 
            case 43: 
            case 44: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findInjectionSupport";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPatternClasses";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findNotNullInjectionSupport";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "appendStringPattern";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isRegexp";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "registerSupport";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "putInjectedFileUserData";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getEditableInstance";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "canBeRemoved";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjectionData";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findClosestCommentInjectionData";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjection";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionMap";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "calcInjections";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "decodeMap";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "prevWalker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 15, 17, 22, 41, 43, 44 -> new IllegalStateException(string);
        };
    }

    public record InjectionInfo(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguage language, @NotNull TextRange range) {
        @NotNull
        private final PsiLanguageInjectionHost host;
        @NotNull
        private final InjectedLanguage language;
        @NotNull
        private final TextRange range;

        public InjectionInfo(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguage language, @NotNull TextRange range) {
            if (host == null) {
                InjectionInfo.$$$reportNull$$$0(0);
            }
            if (language == null) {
                InjectionInfo.$$$reportNull$$$0(1);
            }
            if (range == null) {
                InjectionInfo.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        public PsiLanguageInjectionHost host() {
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.host;
            if (psiLanguageInjectionHost == null) {
                InjectionInfo.$$$reportNull$$$0(3);
            }
            return psiLanguageInjectionHost;
        }

        @NotNull
        public InjectedLanguage language() {
            InjectedLanguage injectedLanguage = this.language;
            if (injectedLanguage == null) {
                InjectionInfo.$$$reportNull$$$0(4);
            }
            return injectedLanguage;
        }

        @NotNull
        public TextRange range() {
            TextRange textRange = this.range;
            if (textRange == null) {
                InjectionInfo.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/intelliLang/inject/InjectorUtils$InjectionInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/intelliLang/inject/InjectorUtils$InjectionInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "host";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "language";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class CommentInjectionData {
        private final String myDisplayName;
        private final Map<String, String> myMap;

        CommentInjectionData(@NotNull Map<String, String> map, @NotNull String displayName) {
            if (map == null) {
                CommentInjectionData.$$$reportNull$$$0(0);
            }
            if (displayName == null) {
                CommentInjectionData.$$$reportNull$$$0(1);
            }
            this.myMap = Collections.unmodifiableMap(map);
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getPrefix() {
            String string = (String)ObjectUtils.notNull((Object)this.myMap.get("prefix"), (Object)"");
            if (string == null) {
                CommentInjectionData.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getSuffix() {
            String string = (String)ObjectUtils.notNull((Object)this.myMap.get("suffix"), (Object)"");
            if (string == null) {
                CommentInjectionData.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getInjectedLanguageId() {
            String string = (String)ObjectUtils.notNull((Object)this.myMap.get("language"), (Object)"");
            if (string == null) {
                CommentInjectionData.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NlsSafe
        @NotNull
        public String getDisplayName() {
            String string = this.myDisplayName;
            if (string == null) {
                CommentInjectionData.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public Map<String, String> getValues() {
            Map<String, String> map = this.myMap;
            if (map == null) {
                CommentInjectionData.$$$reportNull$$$0(6);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/intelliLang/inject/InjectorUtils$CommentInjectionData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/intelliLang/inject/InjectorUtils$CommentInjectionData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuffix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInjectedLanguageId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

