/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.util.BitUtil;
import org.opensearch.core.common.io.stream.FilterStreamInput;
import org.opensearch.core.common.io.stream.StreamInput;

public final class BufferedChecksumStreamInput
extends FilterStreamInput {
    private static final int SKIP_BUFFER_SIZE = 1024;
    private byte[] skipBuffer;
    private final Checksum digest;
    private final String source;
    private static final ThreadLocal<byte[]> buffer = ThreadLocal.withInitial(() -> new byte[8]);

    public BufferedChecksumStreamInput(StreamInput in, String source, BufferedChecksumStreamInput reuse) {
        super(in);
        this.source = source;
        if (reuse == null) {
            this.digest = new BufferedChecksum((Checksum)new CRC32());
        } else {
            this.digest = reuse.digest;
            this.digest.reset();
            this.skipBuffer = reuse.skipBuffer;
        }
    }

    public BufferedChecksumStreamInput(StreamInput in, String source) {
        this(in, source, null);
    }

    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public byte readByte() throws IOException {
        byte b = this.delegate.readByte();
        this.digest.update(b);
        return b;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.delegate.readBytes(b, offset, len);
        this.digest.update(b, offset, len);
    }

    @Override
    public short readShort() throws IOException {
        byte[] buf = buffer.get();
        this.readBytes(buf, 0, 2);
        return BitUtil.VH_BE_SHORT.get(buf, 0);
    }

    @Override
    public int readInt() throws IOException {
        byte[] buf = buffer.get();
        this.readBytes(buf, 0, 4);
        return BitUtil.VH_BE_INT.get(buf, 0);
    }

    @Override
    public long readLong() throws IOException {
        byte[] buf = buffer.get();
        this.readBytes(buf, 0, 8);
        return BitUtil.VH_BE_LONG.get(buf, 0);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
        this.digest.reset();
    }

    @Override
    public int read() throws IOException {
        try {
            return this.readByte() & 0xFF;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public long skip(long numBytes) throws IOException {
        long skipped;
        int step;
        if (numBytes < 0L) {
            throw new IllegalArgumentException("numBytes must be >= 0, got " + numBytes);
        }
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[1024];
        }
        assert (this.skipBuffer.length == 1024);
        for (skipped = 0L; skipped < numBytes; skipped += (long)step) {
            step = (int)Math.min(1024L, numBytes - skipped);
            this.readBytes(this.skipBuffer, 0, step);
        }
        return skipped;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    public void resetDigest() {
        this.digest.reset();
    }

    public String getSource() {
        return this.source;
    }
}

