/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.rpc.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ons.CallBack;
import oracle.ons.CallBackMode;
import oracle.ons.CallBackSubscriber;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.Publisher;
import oracle.ons.rpc.RpcRequestListener;
import oracle.ons.rpc.RpcServer;
import oracle.ons.rpc.RpcServerException;
import oracle.ons.rpc.impl.RpcRequestImpl;

public final class RpcServerImpl
implements RpcServer,
CallBack {
    private CallBackSubscriber cbsubscriber;
    private String component;
    private ONS myons;
    private String rpcServerName;
    private CallBackMode callBackMode;
    private Map<String, RpcRequestListener> rpcRequestListeners;
    private Map<String, String> addrProperties;
    private boolean isLocal;
    private boolean isRunning;
    private Publisher publisher;
    private Logger logger;

    public RpcServerImpl(ONS oNS, String string, String string2, Map<String, String> map, CallBackMode callBackMode, boolean bl) {
        this.myons = oNS;
        RpcServerImpl rpcServerImpl = this;
        this.logger = rpcServerImpl.myons.getLogger();
        this.component = string2;
        this.rpcServerName = string;
        this.callBackMode = callBackMode;
        this.cbsubscriber = null;
        this.rpcRequestListeners = new HashMap<String, RpcRequestListener>();
        this.isLocal = bl;
        this.isRunning = false;
        this.addrProperties = map;
        this.logger.info("create (" + string + ", " + string2 + ") local=" + bl);
    }

    public RpcServerImpl(ONS oNS, String string, String string2, Map<String, String> map, CallBackMode callBackMode) {
        this(oNS, string, string2, map, callBackMode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launch() throws RpcServerException {
        RpcServerImpl rpcServerImpl = this;
        synchronized (rpcServerImpl) {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
        }
        this.logger.info("launch (" + this.rpcServerName + ")");
        this.cbsubscriber = new CallBackSubscriber(this.rpcServerName, this.myons, "!", this.component, this, this.callBackMode, this.addrProperties, this.isLocal);
        this.publisher = new Publisher(this.myons.config, this.rpcServerName);
        this.cbsubscriber.waitForRpcServerRegistrationReply();
        this.logger.info("launch (" + this.rpcServerName + ") complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        RpcServerImpl rpcServerImpl = this;
        synchronized (rpcServerImpl) {
            if (!this.isRunning) {
                return;
            }
            this.isRunning = false;
        }
        this.logger.info("shutdown (" + this.rpcServerName + ")");
        if (this.cbsubscriber != null) {
            this.cbsubscriber.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRequestListener(String string, RpcRequestListener rpcRequestListener) {
        RpcServerImpl rpcServerImpl = this;
        synchronized (rpcServerImpl) {
            if (string == null) {
                throw new IllegalArgumentException("Cannot add an RPC handler with a null RPC name");
            }
            if (this.rpcRequestListeners.containsKey(string)) {
                throw new IllegalArgumentException("RPC " + string + " is already added to this RPC Server");
            }
            this.rpcRequestListeners.put(string, rpcRequestListener);
        }
    }

    @Override
    public void notification_callback(Notification notification) {
        byte[] byArray;
        String string = notification.get("DirectSource");
        String string2 = notification.get("ONSbroadcastID");
        String string3 = notification.get("TraceRoute");
        String string4 = notification.get("ONSrpcRequest");
        byte[] byArray2 = notification.body();
        if (byArray2 != null) {
            int n;
            int n2 = 0;
            for (n = 0; n < byArray2.length; ++n) {
                if (byArray2[n] != 0) continue;
                n2 = n;
                break;
            }
            byArray = new byte[n2];
            for (n = 0; n < n2; ++n) {
                byArray[n] = byArray2[n];
            }
        } else {
            byArray = null;
        }
        RpcRequestListener rpcRequestListener = this.rpcRequestListeners.get(string4);
        RpcRequestImpl rpcRequestImpl = new RpcRequestImpl(string2, string, string3, this.cbsubscriber.getLogicalAddress(), byArray, this.publisher);
        if (rpcRequestListener == null) {
            rpcRequestImpl.sendResult("RpcRequestListener is null".getBytes(), false);
            return;
        }
        try {
            rpcRequestListener.onRequest(rpcRequestImpl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            rpcRequestImpl.sendResult(throwable.toString().getBytes(), false);
        }
        if (!rpcRequestImpl.isDone()) {
            rpcRequestImpl.sendResult(null, true);
        }
    }
}

