/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pkcs12;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.security.pki.internal.asn1.ASN1Constructed;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.pkcs12.PKCS12Bag;
import oracle.security.pki.internal.pkcs12.PKCS12Safe;
import oracle.security.pki.util.Utils;

public class PKCS12SafeContentsBag
extends PKCS12Bag {
    private PKCS12Safe c;
    private ArrayList<PKCS12Bag> d;
    private ASN1Sequence e;

    public PKCS12SafeContentsBag() {
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe) {
        this.c = pKCS12Safe;
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, List<PKCS12Bag> list) {
        this(pKCS12Safe);
        this.d = list == null ? null : new ArrayList<PKCS12Bag>(list);
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.a(aSN1Sequence);
    }

    @Override
    void a() {
        this.e = null;
        if (this.c != null) {
            this.c.a();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a(new ASN1Sequence(inputStream));
    }

    public void a(ASN1Sequence aSN1Sequence) throws IOException {
        this.a();
        try {
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.a(1);
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.a(0);
            this.d = new ArrayList();
            int n = aSN1Sequence2.c();
            for (int i = 0; i < n; ++i) {
                this.d.add(PKCS12Bag.a(null, (ASN1Sequence)aSN1Sequence2.a(i)));
            }
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.f().output(outputStream);
    }

    private ASN1Sequence f() {
        if (this.e != null) {
            return this.e;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.a(new ASN1ObjectID(ASN1Utils.e, 12, 10, 1, 6));
        ASN1Constructed aSN1Constructed = new ASN1Sequence((List<? extends ASN1Object>)this.d);
        aSN1Sequence.a(new ASN1GenericConstructed(aSN1Constructed, 0));
        aSN1Constructed = this.d();
        if (aSN1Constructed != null) {
            aSN1Sequence.a(aSN1Constructed);
        }
        this.e = aSN1Sequence;
        return aSN1Sequence;
    }

    @Override
    public int length() {
        return this.f().length();
    }

    public ArrayList<PKCS12Bag> e() {
        return this.d;
    }

    public void a(List<PKCS12Bag> list) {
        this.d = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<PKCS12Bag>(list));
        this.a();
    }

    public void a(PKCS12Bag pKCS12Bag) {
        if (this.d == null) {
            this.d = new ArrayList();
        }
        this.d.add(pKCS12Bag);
        this.a();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("friendlyName = \"" + this.a + "\", ");
        }
        if (this.b != null) {
            stringBuffer.append("localKeyID = " + Utils.toHexString(this.b) + ", ");
        }
        stringBuffer.append("bags = {");
        int n = this.d.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.d.get(i).toString());
            if (i == n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

