/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner.bootstrap;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class ForkJoinClassLoading {
    private static final Logger log = Logger.getLogger((String)ForkJoinClassLoading.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setForkJoinClassLoader(final ClassLoader classLoader) {
        final CountDownLatch allDone = new CountDownLatch(ForkJoinPool.getCommonPoolParallelism());
        final CountDownLatch taskRelease = new CountDownLatch(1);
        for (int i = 0; i < ForkJoinPool.getCommonPoolParallelism(); ++i) {
            ForkJoinPool.commonPool().execute(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    allDone.countDown();
                    try {
                        taskRelease.await();
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"Failed to set fork join ClassLoader", (Throwable)e);
                    }
                }
            });
        }
        try {
            if (!allDone.await(1L, TimeUnit.SECONDS)) {
                log.error((Object)"Timed out trying to set fork join ClassLoader, this should never happen unless something has tied up a fork join thread before the app launched");
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Failed to set fork join ClassLoader", (Throwable)e);
        }
        finally {
            taskRelease.countDown();
        }
    }
}

