/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class RebalanceConfirmationCollector {
    private static final Log log = LogFactory.getLog(RebalanceConfirmationCollector.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final String cacheName;
    private final int topologyId;
    private final Set<Address> confirmationsNeeded;
    private final Runnable whenCompleted;

    public RebalanceConfirmationCollector(String cacheName, int topologyId, Collection<Address> members, Runnable whenCompleted) {
        this.cacheName = cacheName;
        this.topologyId = topologyId;
        this.confirmationsNeeded = new HashSet<Address>(members);
        this.whenCompleted = whenCompleted;
        log.tracef("Initialized topology confirmation collector %d@%s, initial list is %s", topologyId, cacheName, this.confirmationsNeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmPhase(Address node, int receivedTopologyId) {
        this.acquireLock();
        try {
            boolean removed;
            if (this.topologyId > receivedTopologyId) {
                log.tracef("Ignoring rebalance confirmation with old topology from %s for cache %s, expecting topology id %d but got %d", new Object[]{node, this.cacheName, this.topologyId, receivedTopologyId});
            }
            if (!(removed = this.confirmationsNeeded.remove(node))) {
                log.tracef("Rebalance confirmation collector %d@%s ignored confirmation for %s, which is already confirmed", this.topologyId, this.cacheName, node);
                return;
            }
            log.tracef("Rebalance confirmation collector %d@%s received confirmation for %s, remaining list is %s", new Object[]{this.topologyId, this.cacheName, node, this.confirmationsNeeded});
            if (this.confirmationsNeeded.isEmpty()) {
                this.whenCompleted.run();
            }
        }
        finally {
            this.releaseLock();
        }
    }

    public void updateMembers(Collection<Address> newMembers) {
        this.acquireLock();
        try {
            boolean modified = this.confirmationsNeeded.retainAll(newMembers);
            log.tracef("Rebalance confirmation collector %d@%s members list updated, remaining list is %s", this.topologyId, this.cacheName, this.confirmationsNeeded);
            if (modified && this.confirmationsNeeded.isEmpty()) {
                this.whenCompleted.run();
            }
        }
        finally {
            this.releaseLock();
        }
    }

    public String toString() {
        this.acquireLock();
        try {
            String string = "RebalanceConfirmationCollector{cacheName=" + this.cacheName + ", topologyId=" + this.topologyId + ", confirmationsNeeded=" + String.valueOf(this.confirmationsNeeded) + "}";
            return string;
        }
        finally {
            this.releaseLock();
        }
    }

    private void acquireLock() {
        this.lock.lock();
    }

    private void releaseLock() {
        this.lock.unlock();
    }
}

