/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.jpa.store.JPAScopeStore;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.jpa.store.ScopeAdapter;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JPAScopeStore
implements ScopeStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAScopeStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public Scope create(ResourceServer resourceServer, String name) {
        return this.create(resourceServer, null, name);
    }

    public Scope create(ResourceServer resourceServer, String id, String name) {
        ScopeEntity entity = new ScopeEntity();
        if (id == null) {
            entity.setId(KeycloakModelUtils.generateId());
        } else {
            entity.setId(id);
        }
        entity.setName(name);
        entity.setResourceServer(ResourceServerAdapter.toEntity(this.entityManager, resourceServer));
        this.entityManager.persist((Object)entity);
        this.entityManager.flush();
        return new ScopeAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public void delete(String id) {
        ScopeEntity scope = (ScopeEntity)this.entityManager.find(ScopeEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (scope != null) {
            this.entityManager.remove((Object)scope);
        }
    }

    public Scope findById(ResourceServer resourceServer, String id) {
        if (id == null) {
            return null;
        }
        ScopeEntity entity = (ScopeEntity)this.entityManager.find(ScopeEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new ScopeAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public Scope findByName(ResourceServer resourceServer, String name) {
        try {
            TypedQuery query = this.entityManager.createNamedQuery("findScopeIdByName", String.class);
            query.setFlushMode(FlushModeType.COMMIT);
            query.setParameter("serverId", (Object)resourceServer.getId());
            query.setParameter("name", (Object)name);
            String id = (String)query.getSingleResult();
            return this.provider.getStoreFactory().getScopeStore().findById(resourceServer, id);
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public List<Scope> findByResourceServer(ResourceServer resourceServer) {
        TypedQuery query = this.entityManager.createNamedQuery("findScopeIdByResourceServer", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServer.getId());
        List result = query.getResultList();
        LinkedList<Scope> list = new LinkedList<Scope>();
        for (String id : result) {
            list.add(this.provider.getStoreFactory().getScopeStore().findById(resourceServer, id));
        }
        return list;
    }

    public List<Scope> findByResourceServer(ResourceServer resourceServer, Map<Scope.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(String.class);
        Root root = querybuilder.from(ScopeEntity.class);
        querybuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServer.getId()));
        attributes.forEach((filterOption, value) -> {
            switch (1.$SwitchMap$org$keycloak$authorization$model$Scope$FilterOption[filterOption.ordinal()]) {
                case 1: {
                    predicates.add(root.get(filterOption.getName()).in((Object[])value));
                    break;
                }
                case 2: {
                    predicates.add(builder.like(builder.lower((Expression)root.get(filterOption.getName())), "%" + value[0].toLowerCase() + "%"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported filter [" + String.valueOf(filterOption) + "]");
                }
            }
        });
        querybuilder.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        List result = PaginationUtils.paginateQuery((TypedQuery)query, (Integer)firstResult, (Integer)maxResults).getResultList();
        LinkedList<Scope> list = new LinkedList<Scope>();
        for (String id : result) {
            list.add(this.provider.getStoreFactory().getScopeStore().findById(resourceServer, id));
        }
        return list;
    }
}

