/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class StringFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public StringFunction(TypeConfiguration typeConfiguration) {
        super("string", new ArgumentTypesValidator(null, FunctionParameterType.ENUM), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)), null);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression singleExpression = (Expression)arguments.get(0);
        JdbcMapping singleJdbcMapping = singleExpression.getExpressionType().getSingleJdbcMapping();
        JdbcType argumentType = singleJdbcMapping.getJdbcType();
        if (argumentType.isString() || argumentType.getDefaultSqlTypeCode() == 6000) {
            singleExpression.accept(walker);
        } else if (argumentType.isInteger()) {
            EnumJavaType enumJavaType = (EnumJavaType)singleJdbcMapping.getMappedJavaType();
            T[] enumConstants = enumJavaType.getJavaTypeClass().getEnumConstants();
            sqlAppender.appendSql("case ");
            singleExpression.accept(walker);
            for (Object e : enumConstants) {
                Enum enumValue = (Enum)e;
                sqlAppender.appendSql(" when ");
                sqlAppender.appendSql(enumValue.ordinal());
                sqlAppender.appendSql(" then ");
                sqlAppender.appendSingleQuoteEscapedString(enumValue.name());
            }
            sqlAppender.appendSql(" end");
        } else {
            throw new QueryException("Unsupported enum type passed to 'string()' function: " + String.valueOf(argumentType));
        }
    }

    @Override
    public String getArgumentListSignature() {
        return "(ENUM arg)";
    }
}

