/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.MeteredIterator;

class MeteredWindowStoreIterator<V>
implements WindowStoreIterator<V>,
MeteredIterator {
    private final WindowStoreIterator<byte[]> iter;
    private final Sensor operationSensor;
    private final Sensor iteratorSensor;
    private final StreamsMetrics metrics;
    private final Function<byte[], V> valueFrom;
    private final long startNs;
    private final long startTimestampMs;
    private final Time time;
    private final LongAdder numOpenIterators;
    private final Set<MeteredIterator> openIterators;

    MeteredWindowStoreIterator(WindowStoreIterator<byte[]> iter, Sensor operationSensor, Sensor iteratorSensor, StreamsMetrics metrics, Function<byte[], V> valueFrom, Time time, LongAdder numOpenIterators, Set<MeteredIterator> openIterators) {
        this.iter = iter;
        this.operationSensor = operationSensor;
        this.iteratorSensor = iteratorSensor;
        this.metrics = metrics;
        this.valueFrom = valueFrom;
        this.startNs = time.nanoseconds();
        this.startTimestampMs = time.milliseconds();
        this.time = time;
        this.numOpenIterators = numOpenIterators;
        this.openIterators = openIterators;
        numOpenIterators.increment();
        openIterators.add(this);
    }

    @Override
    public long startTimestamp() {
        return this.startTimestampMs;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public KeyValue<Long, V> next() {
        KeyValue next = (KeyValue)this.iter.next();
        return KeyValue.pair((Long)next.key, this.valueFrom.apply((byte[])next.value));
    }

    @Override
    public void close() {
        try {
            this.iter.close();
        }
        finally {
            long duration = this.time.nanoseconds() - this.startNs;
            this.operationSensor.record((double)duration);
            this.iteratorSensor.record((double)duration);
            this.numOpenIterators.decrement();
            this.openIterators.remove(this);
        }
    }

    @Override
    public Long peekNextKey() {
        return (Long)this.iter.peekNextKey();
    }
}

