/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.filter;

import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.tools.filter.PartitionFilter;
import org.apache.kafka.tools.filter.TopicFilter;

public interface TopicPartitionFilter {
    public boolean isTopicAllowed(String var1);

    public boolean isTopicPartitionAllowed(TopicPartition var1);

    public static class CompositeTopicPartitionFilter
    implements TopicPartitionFilter {
        private final List<TopicPartitionFilter> filters;

        public CompositeTopicPartitionFilter(List<TopicPartitionFilter> filters) {
            this.filters = filters;
        }

        @Override
        public boolean isTopicAllowed(String topic) {
            return this.filters.stream().anyMatch(tp -> tp.isTopicAllowed(topic));
        }

        @Override
        public boolean isTopicPartitionAllowed(TopicPartition partition) {
            return this.filters.stream().anyMatch(tp -> tp.isTopicPartitionAllowed(partition));
        }
    }

    public static class TopicFilterAndPartitionFilter
    implements TopicPartitionFilter {
        private final TopicFilter.IncludeList topicFilter;
        private final PartitionFilter partitionFilter;

        public TopicFilterAndPartitionFilter(TopicFilter.IncludeList topicFilter, PartitionFilter partitionFilter) {
            this.topicFilter = topicFilter;
            this.partitionFilter = partitionFilter;
        }

        @Override
        public boolean isTopicAllowed(String topic) {
            return this.topicFilter.isTopicAllowed(topic, false);
        }

        @Override
        public boolean isTopicPartitionAllowed(TopicPartition partition) {
            return this.isTopicAllowed(partition.topic()) && this.partitionFilter.isPartitionAllowed(partition.partition());
        }
    }
}

