/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.transport.HttpClientConnectionFactory;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="The HTTP client transport that supports many HTTP versions")
public class HttpClientTransportDynamic
extends AbstractConnectorHttpClientTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransportDynamic.class);
    private final List<ClientConnectionFactory.Info> clientConnectionFactoryInfos;

    public HttpClientTransportDynamic() {
        this(new ClientConnector(), HttpClientConnectionFactory.HTTP11);
    }

    @Deprecated(since="12.0.7", forRemoval=true)
    public HttpClientTransportDynamic(ClientConnectionFactory.Info ... infos) {
        this(HttpClientTransportDynamic.findClientConnector(infos), infos);
    }

    public HttpClientTransportDynamic(ClientConnector connector, ClientConnectionFactory.Info ... infos) {
        super(connector);
        this.clientConnectionFactoryInfos = infos.length == 0 ? List.of(HttpClientConnectionFactory.HTTP11) : List.of(infos);
        this.clientConnectionFactoryInfos.forEach(x$0 -> this.installBean(x$0));
        this.setConnectionPoolFactory(destination -> new MultiplexConnectionPool(destination, destination.getHttpClient().getMaxConnectionsPerDestination(), 1));
    }

    private static ClientConnector findClientConnector(ClientConnectionFactory.Info[] infos) {
        return Arrays.stream(infos).flatMap(info -> info.getContainedBeans(ClientConnector.class).stream()).findFirst().orElseGet(ClientConnector::new);
    }

    @Override
    public Origin newOrigin(Request request) {
        boolean secure = HttpScheme.isSecure((String)request.getScheme());
        ArrayList<ClientConnectionFactory.Info> matchingInfos = new ArrayList<ClientConnectionFactory.Info>();
        boolean negotiate = false;
        if (((HttpRequest)request).isVersionExplicit()) {
            HttpVersion version = request.getVersion();
            List<String> wanted = this.toProtocols(version);
            for (ClientConnectionFactory.Info info2 : this.clientConnectionFactoryInfos) {
                List protocols = info2.getProtocols(secure);
                for (String p : protocols) {
                    if (!wanted.contains(p)) continue;
                    matchingInfos.add(info2);
                    break;
                }
                if (matchingInfos.isEmpty()) continue;
                if (!secure || protocols.size() <= 1) break;
                negotiate = true;
                break;
            }
        } else {
            ClientConnectionFactory.Info preferredInfo = this.clientConnectionFactoryInfos.get(0);
            if (secure) {
                if (preferredInfo.getProtocols(true).contains("h3")) {
                    matchingInfos.add(preferredInfo);
                } else {
                    for (ClientConnectionFactory.Info info3 : this.clientConnectionFactoryInfos) {
                        if (info3.getProtocols(true).contains("h3")) continue;
                        matchingInfos.add(info3);
                    }
                    if (!request.getHeaders().contains(HttpHeader.UPGRADE, "h2c")) {
                        int matches = matchingInfos.size();
                        if (matches > 1) {
                            negotiate = true;
                        } else if (matches == 1) {
                            negotiate = ((ClientConnectionFactory.Info)matchingInfos.get(0)).getProtocols(true).size() > 1;
                        }
                    }
                }
            } else {
                for (ClientConnectionFactory.Info info3 : this.clientConnectionFactoryInfos) {
                    if (info3.getProtocols(false).contains("h3")) continue;
                    matchingInfos.add(info3);
                    break;
                }
            }
        }
        if (matchingInfos.isEmpty()) {
            return this.getHttpClient().createOrigin(request, null);
        }
        Transport transport = request.getTransport();
        if (transport == null) {
            transport = this.getClientConnector().newTransport();
            if (transport == null) {
                transport = ((ClientConnectionFactory.Info)matchingInfos.get(0)).newTransport();
            }
            request.transport(transport);
        }
        List protocols = matchingInfos.stream().flatMap(info -> info.getProtocols(secure).stream()).collect(Collectors.toCollection(ArrayList::new));
        if (negotiate) {
            protocols.remove("h2c");
        }
        Origin.Protocol protocol = new Origin.Protocol(protocols, negotiate);
        return this.getHttpClient().createOrigin(request, protocol);
    }

    @Override
    public Destination newDestination(Origin origin) {
        return new HttpDestination(this.getHttpClient(), origin);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        boolean intrinsicallySecure;
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        Origin origin = destination.getOrigin();
        Origin.Protocol protocol = origin.getProtocol();
        Object factory = protocol == null ? this.clientConnectionFactoryInfos.get(0).getClientConnectionFactory() : (!(intrinsicallySecure = origin.getTransport().isIntrinsicallySecure()) && destination.isSecure() && protocol.isNegotiate() ? new ALPNClientConnectionFactory(this.getClientConnector().getExecutor(), this::newNegotiatedConnection, protocol.getProtocols()) : this.findClientConnectionFactoryInfo(protocol.getProtocols(), destination.isSecure()).orElseThrow(() -> new IOException("Cannot find " + ClientConnectionFactory.class.getSimpleName() + " for " + String.valueOf(protocol))).getClientConnectionFactory());
        return factory.newConnection(endPoint, context);
    }

    public void upgrade(EndPoint endPoint, Map<String, Object> context) {
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        Origin.Protocol protocol = destination.getOrigin().getProtocol();
        ClientConnectionFactory.Info info = this.findClientConnectionFactoryInfo(protocol.getProtocols(), destination.isSecure()).orElseThrow(() -> new IllegalStateException("Cannot find " + ClientConnectionFactory.class.getSimpleName() + " to upgrade to " + String.valueOf(protocol)));
        info.upgrade(endPoint, context);
    }

    protected Connection newNegotiatedConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        try {
            ClientConnectionFactory.Info factoryInfo;
            ALPNClientConnection alpnConnection = (ALPNClientConnection)endPoint.getConnection();
            String protocol = alpnConnection.getProtocol();
            if (protocol != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ALPN negotiated {} among {}", (Object)protocol, (Object)alpnConnection.getProtocols());
                }
                List<String> protocols = List.of(protocol);
                factoryInfo = this.findClientConnectionFactoryInfo(protocols, true).orElseThrow(() -> new IOException("Cannot find " + ClientConnectionFactory.class.getSimpleName() + " for negotiated protocol " + protocol));
            } else {
                factoryInfo = this.clientConnectionFactoryInfos.get(0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No ALPN protocol, using {}", (Object)factoryInfo);
                }
            }
            return factoryInfo.getClientConnectionFactory().newConnection(endPoint, context);
        }
        catch (Throwable failure) {
            this.connectFailed(context, failure);
            throw failure;
        }
    }

    private Optional<ClientConnectionFactory.Info> findClientConnectionFactoryInfo(List<String> protocols, boolean secure) {
        return this.clientConnectionFactoryInfos.stream().filter(info -> info.matches(protocols, secure)).findFirst();
    }

    private List<String> toProtocols(HttpVersion version) {
        return switch (version) {
            default -> throw new IncompatibleClassChangeError();
            case HttpVersion.HTTP_0_9, HttpVersion.HTTP_1_0, HttpVersion.HTTP_1_1 -> List.of("http/1.1");
            case HttpVersion.HTTP_2 -> List.of("h2c", "h2");
            case HttpVersion.HTTP_3 -> List.of("h3");
        };
    }
}

