/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultiCloseable
implements AutoCloseable {
    private static final AutoCloseable @NotNull [] EMPTY_ARRAY = new AutoCloseable[0];
    @NotNull
    private final SmartList<AutoCloseable> myCleanupList = new SmartList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCloseable(@NotNull AutoCloseable closeable) {
        if (closeable == null) {
            MultiCloseable.$$$reportNull$$$0(0);
        }
        SmartList<AutoCloseable> smartList = this.myCleanupList;
        synchronized (smartList) {
            this.myCleanupList.add(closeable);
        }
    }

    @Override
    public void close() throws Exception {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="!null -> fail")
    public void close(@Nullable Throwable throwable) throws Exception {
        AutoCloseable[] cleanupArray;
        SmartList<AutoCloseable> smartList = this.myCleanupList;
        synchronized (smartList) {
            cleanupArray = this.myCleanupList.toArray(EMPTY_ARRAY);
            this.myCleanupList.clear();
        }
        MultiCloseable.closeAll(cleanupArray, true, throwable);
    }

    public static void closeAll(AutoCloseable ... cleanupArray) throws Exception {
        if (cleanupArray == null) {
            MultiCloseable.$$$reportNull$$$0(1);
        }
        MultiCloseable.closeAll(cleanupArray, false, null);
    }

    @Contract(value="_, _, !null -> fail")
    public static void closeAll(@NotNull @NotNull AutoCloseable @NotNull [] cleanupArray, boolean reversed, @Nullable Throwable throwable) throws Exception {
        if (cleanupArray == null) {
            MultiCloseable.$$$reportNull$$$0(2);
        }
        for (int i = 0; i < cleanupArray.length; ++i) {
            AutoCloseable closeable = cleanupArray[reversed ? cleanupArray.length - 1 - i : i];
            try {
                closeable.close();
                continue;
            }
            catch (Throwable t) {
                if (throwable == null) {
                    throwable = t;
                    continue;
                }
                throwable.addSuppressed(t);
            }
        }
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        ExceptionUtil.rethrowAllAsUnchecked(throwable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupArray";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/MultiCloseable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCloseable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "closeAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

