/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.parsing.KotlinParsing;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilderImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J>\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0016\b\u0002\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00180\u0017H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/parsing/KotlinLightParser;", "", "<init>", "()V", "buildLightTree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "code", "", "sourceFile", "Lorg/jetbrains/kotlin/KtSourceFile;", "errorListener", "Lorg/jetbrains/kotlin/parsing/KotlinLightParser$LightTreeParsingErrorListener;", "parse", "builder", "Lcom/intellij/lang/PsiBuilder;", "isScript", "", "reportErrors", "", "node", "tree", "ref", "Lcom/intellij/openapi/util/Ref;", "", "LightTreeParsingErrorListener", "psi"})
@SourceDebugExtension(value={"SMAP\nKotlinLightParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLightParser.kt\norg/jetbrains/kotlin/parsing/KotlinLightParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class KotlinLightParser {
    @NotNull
    public static final KotlinLightParser INSTANCE = new KotlinLightParser();

    private KotlinLightParser() {
    }

    @NotNull
    public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTree(@NotNull CharSequence code, @Nullable KtSourceFile sourceFile, @Nullable LightTreeParsingErrorListener errorListener) {
        Object extension;
        Object it;
        Object object;
        PsiBuilder builder;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(code, "code");
                PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(new KotlinParserDefinition(), (Lexer)new KotlinLexer(), code);
                Intrinsics.checkNotNullExpressionValue(psiBuilder, "createBuilder(...)");
                builder = psiBuilder;
                object = sourceFile;
                if (object == null) break block4;
                it = object;
                boolean bl = false;
                String string = FileUtilRt.getExtension(it.getName());
                object = string;
                if (string != null) break block5;
            }
            object = "";
        }
        boolean isScript = !(((CharSequence)(extension = object)).length() == 0) && !Intrinsics.areEqual(extension, "kt");
        FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = this.parse(builder, isScript);
        it = flyweightCapableTreeStructure;
        boolean bl = false;
        if (errorListener != null) {
            Object t2 = it.getRoot();
            Intrinsics.checkNotNullExpressionValue(t2, "getRoot(...)");
            KotlinLightParser.reportErrors$default(INSTANCE, (LighterASTNode)t2, (FlyweightCapableTreeStructure)it, errorListener, null, 8, null);
        }
        return flyweightCapableTreeStructure;
    }

    @NotNull
    public final FlyweightCapableTreeStructure<LighterASTNode> parse(@NotNull PsiBuilder builder, boolean isScript) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        KotlinParsing ktParsing = KotlinParsing.createForTopLevelNonLazy(new SemanticWhitespaceAwarePsiBuilderImpl(builder));
        if (isScript) {
            ktParsing.parseScript();
        } else {
            ktParsing.parseFile();
        }
        FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = builder.getLightTree();
        Intrinsics.checkNotNullExpressionValue(flyweightCapableTreeStructure, "getLightTree(...)");
        return flyweightCapableTreeStructure;
    }

    private final void reportErrors(LighterASTNode node, FlyweightCapableTreeStructure<LighterASTNode> tree, LightTreeParsingErrorListener errorListener, Ref<LighterASTNode[]> ref) {
        tree.getChildren(node, ref);
        LighterASTNode[] lighterASTNodeArray = ref.get();
        if (lighterASTNodeArray == null) {
            return;
        }
        for (LighterASTNode child : lighterASTNodeArray) {
            if (child == null) break;
            IElementType tokenType = child.getTokenType();
            if (Intrinsics.areEqual(tokenType, TokenType.ERROR_ELEMENT)) {
                String message2 = PsiBuilderImpl.getErrorMessage(child);
                errorListener.onError(child.getStartOffset(), child.getEndOffset(), message2);
            }
            ref.set(null);
            this.reportErrors(child, tree, errorListener, ref);
        }
    }

    static /* synthetic */ void reportErrors$default(KotlinLightParser kotlinLightParser, LighterASTNode lighterASTNode, FlyweightCapableTreeStructure flyweightCapableTreeStructure, LightTreeParsingErrorListener lightTreeParsingErrorListener, Ref ref, int n2, Object object) {
        if ((n2 & 8) != 0) {
            ref = new Ref<LighterASTNode[]>();
        }
        kotlinLightParser.reportErrors(lighterASTNode, flyweightCapableTreeStructure, lightTreeParsingErrorListener, ref);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/parsing/KotlinLightParser$LightTreeParsingErrorListener;", "", "onError", "", "startOffset", "", "endOffset", "message", "", "psi"})
    public static interface LightTreeParsingErrorListener {
        public void onError(int var1, int var2, @Nullable String var3);
    }
}

