/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.RecursiveConversion;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKBinaryExpression;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKIfElseStatement;
import org.jetbrains.kotlin.nj2k.tree.JKIsExpression;
import org.jetbrains.kotlin.nj2k.tree.JKKtOperatorImpl;
import org.jetbrains.kotlin.nj2k.tree.JKOperatorToken;
import org.jetbrains.kotlin.nj2k.tree.JKParenthesizedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKPrefixExpression;
import org.jetbrains.kotlin.nj2k.tree.JKReturnStatement;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;
import org.jetbrains.kotlin.nj2k.types.JKJavaPrimitiveType;
import org.jetbrains.kotlin.nj2k.types.JKType;
import org.jetbrains.kotlin.nj2k.types.TypesUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J!\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016R\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\f\u0010\u0011\u001a\u00020\u0007*\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/SimplifyNegatedBinaryExpressionConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveConversion;", "context", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "<init>", "(Lorg/jetbrains/kotlin/j2k/ConverterContext;)V", "isEnabledInBasicMode", "", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "KaSession", "element", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;)Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "getNegatedToken", "Lorg/jetbrains/kotlin/nj2k/tree/JKOperatorToken;", "operator", "canBeSimplified", "Lorg/jetbrains/kotlin/nj2k/tree/JKBinaryExpression;", "kotlin.j2k.shared"})
public final class SimplifyNegatedBinaryExpressionConversion
extends RecursiveConversion {
    public SimplifyNegatedBinaryExpressionConversion(@NotNull ConverterContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @Override
    public boolean isEnabledInBasicMode() {
        return false;
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull KaSession $context_receiver_0, @NotNull JKTreeElement element) {
        boolean shouldBeParenthesized;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof JKPrefixExpression) || !Intrinsics.areEqual((Object)((JKPrefixExpression)element).getOperator().getToken(), (Object)JKOperatorToken.Companion.getEXCL())) {
            return this.recurse($context_receiver_0, element);
        }
        JKExpression jKExpression = ((JKPrefixExpression)element).getExpression();
        JKParenthesizedExpression jKParenthesizedExpression = jKExpression instanceof JKParenthesizedExpression ? (JKParenthesizedExpression)jKExpression : null;
        if (jKParenthesizedExpression == null) {
            return this.recurse($context_receiver_0, element);
        }
        JKParenthesizedExpression parenthesizedExpression = jKParenthesizedExpression;
        JKExpression innerExpression = parenthesizedExpression.getExpression();
        boolean bl = shouldBeParenthesized = !(element.getParent() instanceof JKIfElseStatement) && !(element.getParent() instanceof JKReturnStatement);
        if (innerExpression instanceof JKIsExpression) {
            innerExpression.detach(parenthesizedExpression);
            ((JKIsExpression)innerExpression).setNegated(true);
            return this.recurse($context_receiver_0, (JKTreeElement)(shouldBeParenthesized ? (JKExpression)ExpressionsKt.parenthesize(innerExpression) : innerExpression));
        }
        if (innerExpression instanceof JKBinaryExpression && this.canBeSimplified((JKBinaryExpression)innerExpression)) {
            JKOperatorToken jKOperatorToken = this.getNegatedToken(((JKBinaryExpression)innerExpression).getOperator().getToken());
            if (jKOperatorToken == null) {
                return this.recurse($context_receiver_0, element);
            }
            JKOperatorToken negatedToken = jKOperatorToken;
            innerExpression.invalidate();
            JKBinaryExpression negatedBinaryExpression = (JKBinaryExpression)FormattingKt.withCommentsFrom(FormattingKt.withFormattingFrom((JKFormattingOwner)new JKBinaryExpression(((JKBinaryExpression)innerExpression).getLeft(), ((JKBinaryExpression)innerExpression).getRight(), new JKKtOperatorImpl(negatedToken, this.getTypeFactory().getTypes().getBoolean()), null, 8, null), (JKFormattingOwner)parenthesizedExpression), innerExpression);
            return this.recurse($context_receiver_0, (JKTreeElement)(shouldBeParenthesized ? (JKExpression)ExpressionsKt.parenthesize(negatedBinaryExpression) : (JKExpression)negatedBinaryExpression));
        }
        return this.recurse($context_receiver_0, element);
    }

    private final JKOperatorToken getNegatedToken(JKOperatorToken operator) {
        JKOperatorToken jKOperatorToken = operator;
        return Intrinsics.areEqual((Object)jKOperatorToken, (Object)JKOperatorToken.Companion.getEQEQ()) ? (JKOperatorToken)JKOperatorToken.Companion.getEXCLEQ() : (Intrinsics.areEqual((Object)jKOperatorToken, (Object)JKOperatorToken.Companion.getEXCLEQ()) ? (JKOperatorToken)JKOperatorToken.Companion.getEQEQ() : (Intrinsics.areEqual((Object)jKOperatorToken, (Object)JKOperatorToken.Companion.getEQEQEQ()) ? (JKOperatorToken)JKOperatorToken.Companion.getEXCLEQEQEQ() : (Intrinsics.areEqual((Object)jKOperatorToken, (Object)JKOperatorToken.Companion.getEXCLEQEQEQ()) ? (JKOperatorToken)JKOperatorToken.Companion.getEQEQEQ() : (Intrinsics.areEqual((Object)jKOperatorToken, (Object)JKOperatorToken.Companion.getLT()) ? (JKOperatorToken)JKOperatorToken.Companion.getGTEQ() : (Intrinsics.areEqual((Object)jKOperatorToken, (Object)JKOperatorToken.Companion.getGTEQ()) ? (JKOperatorToken)JKOperatorToken.Companion.getLT() : (Intrinsics.areEqual((Object)jKOperatorToken, (Object)JKOperatorToken.Companion.getGT()) ? (JKOperatorToken)JKOperatorToken.Companion.getLTEQ() : (Intrinsics.areEqual((Object)jKOperatorToken, (Object)JKOperatorToken.Companion.getLTEQ()) ? (JKOperatorToken)JKOperatorToken.Companion.getGT() : null)))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canBeSimplified(JKBinaryExpression $this$canBeSimplified) {
        JKOperatorToken operatorToken = $this$canBeSimplified.getOperator().getToken();
        if (!(Intrinsics.areEqual((Object)operatorToken, (Object)JKOperatorToken.Companion.getLT()) || Intrinsics.areEqual((Object)operatorToken, (Object)JKOperatorToken.Companion.getLTEQ()) || Intrinsics.areEqual((Object)operatorToken, (Object)JKOperatorToken.Companion.getGT()) || Intrinsics.areEqual((Object)operatorToken, (Object)JKOperatorToken.Companion.getGTEQ()))) {
            return true;
        }
        JKType jKType = $this$canBeSimplified.getLeft().calculateType(this.getTypeFactory());
        JKJavaPrimitiveType leftType = jKType != null ? TypesUtilsKt.asPrimitiveType(jKType) : null;
        JKType jKType2 = $this$canBeSimplified.getRight().calculateType(this.getTypeFactory());
        JKJavaPrimitiveType rightType = jKType2 != null ? TypesUtilsKt.asPrimitiveType(jKType2) : null;
        JKJavaPrimitiveType jKJavaPrimitiveType = leftType;
        if (jKJavaPrimitiveType == null) return false;
        if (TypesUtilsKt.isFloatingPoint(jKJavaPrimitiveType)) return false;
        boolean bl = true;
        if (!bl) return false;
        JKJavaPrimitiveType jKJavaPrimitiveType2 = rightType;
        if (jKJavaPrimitiveType2 == null) return false;
        if (TypesUtilsKt.isFloatingPoint(jKJavaPrimitiveType2)) return false;
        return true;
    }
}

