/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsNoResolveKt;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KDocTagCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "isApplicable", "", "Lorg/jetbrains/kotlin/kdoc/parser/KDocKnownTag;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "kotlin.completion.impl.shared"})
@SourceDebugExtension(value={"SMAP\nKDocCompletion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KDocCompletion.kt\norg/jetbrains/kotlin/idea/completion/KDocTagCompletionProvider\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n217#2:61\n13472#3,2:62\n*S KotlinDebug\n*F\n+ 1 KDocCompletion.kt\norg/jetbrains/kotlin/idea/completion/KDocTagCompletionProvider\n*L\n33#1:61\n35#1:62,2\n*E\n"})
public final class KDocTagCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final KDocTagCompletionProvider INSTANCE = new KDocTagCompletionProvider();

    private KDocTagCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement = (PsiElement)parameters2.getPosition().getContainingFile();
        int n = parameters2.getOffset();
        CharPattern charPattern = StandardPatterns.character().javaIdentifierPart();
        Intrinsics.checkNotNullExpressionValue((Object)charPattern, (String)"javaIdentifierPart(...)");
        ElementPattern elementPattern = CompletionUtilsNoResolveKt.or((ElementPattern)charPattern, (ElementPattern)CompletionUtilsNoResolveKt.singleCharPattern('@'));
        CharPattern charPattern2 = StandardPatterns.character().javaIdentifierStart();
        Intrinsics.checkNotNullExpressionValue((Object)charPattern2, (String)"javaIdentifierStart(...)");
        String string = CompletionUtil.findIdentifierPrefix((PsiElement)psiElement, (int)n, elementPattern, CompletionUtilsNoResolveKt.or((ElementPattern)charPattern2, (ElementPattern)CompletionUtilsNoResolveKt.singleCharPattern('@')));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"findIdentifierPrefix(...)");
        String prefix2 = string;
        if (parameters2.isAutoPopup() && ((CharSequence)prefix2).length() == 0) {
            return;
        }
        if (((CharSequence)prefix2).length() > 0 && !StringsKt.startsWith$default((CharSequence)prefix2, (char)'@', (boolean)false, (int)2, null)) {
            return;
        }
        PsiElement psiElement2 = parameters2.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPosition(...)");
        PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
        boolean $i$f$getNonStrictParentOfType = false;
        KDoc kDoc = (KDoc)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KDoc.class, (boolean)false);
        KtDeclaration kdocOwner = kDoc != null ? kDoc.getOwner() : null;
        CompletionResultSet completionResultSet = result2.withPrefixMatcher(prefix2);
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withPrefixMatcher(...)");
        CompletionResultSet resultWithPrefix = completionResultSet;
        KDocKnownTag[] $this$forEach$iv = KDocKnownTag.values();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int j = 0; j < n2; ++j) {
            KDocKnownTag element$iv;
            KDocKnownTag it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (kdocOwner != null && !INSTANCE.isApplicable(it, kdocOwner)) continue;
            String string2 = it.name();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            resultWithPrefix.addElement((LookupElement)LookupElementBuilder.create((String)("@" + string3)));
        }
    }

    private final boolean isApplicable(KDocKnownTag $this$isApplicable, KtDeclaration declaration) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$isApplicable.ordinal()]) {
            case 1, 2 -> declaration instanceof KtClassOrObject;
            case 3 -> declaration instanceof KtNamedFunction;
            case 4 -> {
                if (declaration instanceof KtNamedFunction && ((KtNamedFunction)declaration).getReceiverTypeReference() != null) {
                    yield true;
                }
                yield false;
            }
            case 5, 6, 7, 8, 9, 10, 11, 12 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KDocKnownTag.values().length];
            try {
                nArray[KDocKnownTag.CONSTRUCTOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KDocKnownTag.PROPERTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KDocKnownTag.RETURN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KDocKnownTag.RECEIVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KDocKnownTag.AUTHOR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KDocKnownTag.THROWS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KDocKnownTag.EXCEPTION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KDocKnownTag.PARAM.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KDocKnownTag.SEE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KDocKnownTag.SINCE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KDocKnownTag.SAMPLE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KDocKnownTag.SUPPRESS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

