#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.43.1
visibility:           public
id:                   hledger-lib-1.43.1-K2HI3UVJMTmADOEpx5yRW2
key:                  hledger-lib-1.43.1-K2HI3UVJMTmADOEpx5yRW2
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  99ab82b9819e08cd78e6c004eb16161c
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Currency
    Hledger.Data.Dates Hledger.Data.Errors Hledger.Data.Journal
    Hledger.Data.JournalChecks Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Beancount Hledger.Write.Csv Hledger.Write.Html
    Hledger.Write.Html.Attribute Hledger.Write.Html.Blaze
    Hledger.Write.Html.HtmlCommon Hledger.Write.Html.Lucid
    Hledger.Write.Ods Hledger.Write.Spreadsheet Text.Tabular.AsciiWide
    Text.WideString

hidden-modules:       Paths_hledger_lib
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.43.1-K2HI3UVJMTmADOEpx5yRW2
depends:
    Decimal-0.5.2-GOM6hM9ChYd7QhckIARg8b
    Glob-0.10.2-DYTOLdItxiPHT6xGf9FKFQ
    aeson-2.1.2.1-KHwyqlRT8uq4KliO3neHti
    aeson-pretty-0.8.10-8diGmDaHQxN99pPdT6jKnG
    ansi-terminal-1.0.2-9vJ4GO68ExP9eHUAPyX7bq array-0.5.4.0
    base-4.17.2.1 blaze-html-0.9.2.0-BIKMCCBg4WREbcLt4aWKrB
    blaze-markup-0.8.3.0-6ICyj6U2NnC3mtRoGtKty6 bytestring-0.11.5.3
    call-stack-0.4.0-AAQ0PbHtRxA9hkeprsdCAo
    cassava-0.5.4.1-8iO9iOg0Y6tJVHPNzEhUWy
    cassava-megaparsec-2.1.1-FzZGsVR5eDgCoTBOF1xgTJ
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    colour-2.3.6-4ExSSwBcR1jEJhw6CsCgIg containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd deepseq-1.4.8.0
    directory-1.3.7.1 doclayout-0.5-695FydkwZ65EPLzNfF5qlS
    encoding-0.10.2-EyfZ8cGSumgEuNjRfPFqDh
    extra-1.7.16-LFhHReVYXhkAHHlVLFa5k7
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    hashtables-1.4.2-GO4mukx08oONCEVDh19KR
    lucid-2.11.20250303-3vY7NH9G97e45g9RHJExfQ
    megaparsec-9.7.0-2BpZEZysy1TBFLB2lr3zMC
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    pretty-simple-4.1.3.0-6MFTLXEDKivKWUJNblWStu process-1.6.18.0
    regex-tdfa-1.3.2.5-BezLFEZ8z7L6k5TXRgb20N
    safe-0.3.21-F7VtiJ5GidLJaCroTndPfj
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5.2-7ubK6yMTM44FqfYmrt10XU
    tasty-hunit-0.10.2-GMCRVPUrTqHHzjXFt3kCie template-haskell-2.19.0.0
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2 time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    uglymemo-0.1.0.1-8AX9zjlFnnmIrnTboBgOzO
    unordered-containers-0.2.20.1-L9h8TvnOBH1Ihya3LZF9bU
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

