---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token HashiCorp Terraform API token'
---

## Description

The response body contains content that matches the pattern of a HashiCorp Terraform API token was identified. API tokens can be used to access the HCP Terraform API. A malicious actor with access to this token can perform all actions the user account is entitled to.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke an API token:

- Sign in to the Terraform HCP console and access <https://app.terraform.io/app/settings/tokens>
- Find the token that was identified
- Select the trash icon on the right hand side of the token
- When prompted, select "Confirm" in the "Deleting token ..." dialog

For more information, please see [Terraform's documentation on API tokens](https://app.terraform.io/app/settings/tokens).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.58 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
