/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import ghidra.bitpatterns.info.FunctionBitPatternsGTreeNode;
import ghidra.bitpatterns.info.InstructionSequence;
import ghidra.bitpatterns.info.PatternType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;

public class InstructionSequenceTreePathFilter {
    private List<String> instructions;
    private List<Integer> lengths;
    private PatternType type;

    public InstructionSequenceTreePathFilter(TreePath path, PatternType type) {
        this.instructions = new ArrayList<String>();
        this.lengths = new ArrayList<Integer>();
        this.type = type;
        for (int i = 1; i < path.getPathCount(); ++i) {
            if (!(path.getPathComponent(i) instanceof FunctionBitPatternsGTreeNode)) {
                throw new IllegalArgumentException("non-root nodes must be members of class FunctionStartPatternsGTreeNode");
            }
            FunctionBitPatternsGTreeNode currentNode = (FunctionBitPatternsGTreeNode)((Object)path.getPathComponent(i));
            String currentInstruction = currentNode.getInstruction();
            Integer currentNumBytes = currentNode.getNumBytes();
            if (currentInstruction == null || currentNumBytes == null) {
                throw new IllegalArgumentException("Can't have null instructions or lengths in the path!");
            }
            this.instructions.add(currentInstruction);
            this.lengths.add(currentNumBytes);
        }
    }

    public InstructionSequenceTreePathFilter(List<String> insts, List<Integer> lens, PatternType pType) {
        this.instructions = insts;
        this.lengths = lens;
        this.type = pType;
    }

    public boolean allows(InstructionSequence instSeq) {
        if (instSeq.getInstructions() == null) {
            return false;
        }
        if (instSeq.getInstructions().length < this.instructions.size()) {
            return false;
        }
        for (int i = 0; i < this.instructions.size(); ++i) {
            String currentInst = instSeq.getInstructions()[i];
            if (currentInst == null) {
                return false;
            }
            if (!currentInst.equals(this.instructions.get(i))) {
                return false;
            }
            Integer currentSize = instSeq.getSizes()[i];
            if (currentSize == null) {
                return false;
            }
            if (currentSize.equals(this.lengths.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.instructions.size(); ++i) {
            sb.append(this.instructions.get(i));
            sb.append(":");
            sb.append(this.lengths.get(i));
            if (i == this.instructions.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public List<String> getInstructions() {
        return this.instructions;
    }

    public List<Integer> getLengths() {
        return this.lengths;
    }

    public int getTotalLength() {
        int totalLength = 0;
        for (Integer length : this.lengths) {
            totalLength += length.intValue();
        }
        return totalLength;
    }

    public PatternType getInstructionType() {
        return this.type;
    }
}

