/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModelStub;
import generic.theme.Gui;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.info.ByteSequenceRowObject;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.bytesearch.DittedBitSequence;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.List;

public class ByteSequenceTableModel
extends ThreadedTableModelStub<ByteSequenceRowObject> {
    private static final String FONT_ID = "font.bytepatterns.table";
    List<ByteSequenceRowObject> rowObjects;
    protected GColumnRenderer<String> monospacedRenderer = new AbstractGColumnRenderer<String>(){

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Component component = super.getTableCellRendererComponent(data);
            component.setFont(Gui.getFont((String)ByteSequenceTableModel.FONT_ID));
            return component;
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    };

    public ByteSequenceTableModel(FunctionBitPatternsExplorerPlugin plugin, List<ByteSequenceRowObject> rowObjects) {
        super("Function Start Patterns", (ServiceProvider)plugin.getTool());
        this.rowObjects = rowObjects;
    }

    protected void doLoad(Accumulator<ByteSequenceRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.rowObjects != null) {
            accumulator.addAll(this.rowObjects);
        }
    }

    protected TableColumnDescriptor<ByteSequenceRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new ByteSequenceTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ByteSequenceNumOccurrencesTableColumn(this), 0, false);
        descriptor.addVisibleColumn((DynamicTableColumn)new ByteSequencePercentageTableColumn(this));
        return descriptor;
    }

    public DittedBitSequence mergeSelectedRows() {
        List rows = this.getLastSelectedObjects();
        if (rows.size() == 0) {
            return null;
        }
        DittedBitSequence currentMerge = ByteSequenceRowObject.merge(rows);
        return currentMerge;
    }

    class ByteSequenceTableColumn
    extends AbstractDynamicTableColumn<ByteSequenceRowObject, String, Object> {
        ByteSequenceTableColumn() {
        }

        public String getColumnName() {
            return "Byte Sequence";
        }

        public String getValue(ByteSequenceRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getSequence();
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return ByteSequenceTableModel.this.monospacedRenderer;
        }
    }

    class ByteSequenceNumOccurrencesTableColumn
    extends AbstractDynamicTableColumn<ByteSequenceRowObject, Integer, Object> {
        ByteSequenceNumOccurrencesTableColumn(ByteSequenceTableModel this$0) {
        }

        public String getColumnName() {
            return "Number Of Occurrences";
        }

        public Integer getValue(ByteSequenceRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getNumOccurrences();
        }
    }

    class ByteSequencePercentageTableColumn
    extends AbstractDynamicTableColumn<ByteSequenceRowObject, Double, Object> {
        ByteSequencePercentageTableColumn(ByteSequenceTableModel this$0) {
        }

        public String getColumnName() {
            return "Percentage";
        }

        public Double getValue(ByteSequenceRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getPercentage();
        }
    }
}

