/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.headers;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatInstructionSet;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.List;

public class OatHeader_039
extends OatHeader {
    protected int adler32_checksum_;
    protected int instruction_set_;
    protected int instruction_set_features_;
    protected int dex_file_count_;
    protected int executable_offset_;
    protected int interpreter_to_interpreter_bridge_offset_;
    protected int interpreter_to_compiled_code_bridge_offset_;
    protected int jni_dlsym_lookup_offset_;
    protected int portable_imt_conflict_trampoline_offset_;
    protected int portable_resolution_trampoline_offset_;
    protected int portable_to_interpreter_bridge_offset_;
    protected int quick_generic_jni_trampoline_offset_;
    protected int quick_imt_conflict_trampoline_offset_;
    protected int quick_resolution_trampoline_offset_;
    protected int quick_to_interpreter_bridge_offset_;
    protected int image_patch_delta_;
    protected int image_file_location_oat_checksum_;
    protected int image_file_location_oat_data_begin_;
    protected int key_value_store_size_;

    public OatHeader_039(BinaryReader reader) throws IOException {
        super(reader);
        this.adler32_checksum_ = reader.readNextInt();
        this.instruction_set_ = reader.readNextInt();
        this.instruction_set_features_ = reader.readNextInt();
        this.dex_file_count_ = reader.readNextInt();
        this.executable_offset_ = reader.readNextInt();
        this.interpreter_to_interpreter_bridge_offset_ = reader.readNextInt();
        this.interpreter_to_compiled_code_bridge_offset_ = reader.readNextInt();
        this.jni_dlsym_lookup_offset_ = reader.readNextInt();
        this.portable_imt_conflict_trampoline_offset_ = reader.readNextInt();
        this.portable_resolution_trampoline_offset_ = reader.readNextInt();
        this.portable_to_interpreter_bridge_offset_ = reader.readNextInt();
        this.quick_generic_jni_trampoline_offset_ = reader.readNextInt();
        this.quick_imt_conflict_trampoline_offset_ = reader.readNextInt();
        this.quick_resolution_trampoline_offset_ = reader.readNextInt();
        this.quick_to_interpreter_bridge_offset_ = reader.readNextInt();
        this.image_patch_delta_ = reader.readNextInt();
        this.image_file_location_oat_checksum_ = reader.readNextInt();
        this.image_file_location_oat_data_begin_ = reader.readNextInt();
        this.key_value_store_size_ = reader.readNextInt();
    }

    @Override
    public int getOatDexFilesOffset(BinaryReader reader) {
        return (int)reader.getPointerIndex();
    }

    @Override
    public int getDexFileCount() {
        return this.dex_file_count_;
    }

    @Override
    public int getKeyValueStoreSize() {
        return this.key_value_store_size_;
    }

    @Override
    public List<OatDexFile> getOatDexFileList() {
        return this.oatDexFileList;
    }

    @Override
    public OatInstructionSet getInstructionSet() {
        return OatInstructionSet.valueOf(this.instruction_set_);
    }

    @Override
    public int getExecutableOffset() {
        return this.executable_offset_;
    }

    @Override
    public int getChecksum() {
        return this.adler32_checksum_;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        int i;
        Structure structure = (Structure)super.toDataType();
        structure.add(DWORD, "adler32_checksum_", null);
        structure.add(DWORD, "instruction_set_", null);
        structure.add(DWORD, "instruction_set_features_", null);
        structure.add(DWORD, "dex_file_count_", null);
        structure.add(DWORD, "executable_offset_", null);
        structure.add(DWORD, "interpreter_to_interpreter_bridge_offset_", null);
        structure.add(DWORD, "interpreter_to_compiled_code_bridge_offset_", null);
        structure.add(DWORD, "jni_dlsym_lookup_offset_", null);
        structure.add(DWORD, "portable_imt_conflict_trampoline_offset_", null);
        structure.add(DWORD, "portable_resolution_trampoline_offset_", null);
        structure.add(DWORD, "portable_to_interpreter_bridge_offset_", null);
        structure.add(DWORD, "quick_generic_jni_trampoline_offset_", null);
        structure.add(DWORD, "quick_imt_conflict_trampoline_offset_", null);
        structure.add(DWORD, "quick_resolution_trampoline_offset_", null);
        structure.add(DWORD, "quick_to_interpreter_bridge_offset_", null);
        structure.add(DWORD, "image_patch_delta_", null);
        structure.add(DWORD, "image_file_location_oat_checksum_", null);
        structure.add(DWORD, "image_file_location_oat_data_begin_", null);
        structure.add(DWORD, "key_value_store_size_", null);
        for (i = 0; i < this.orderedKeyList.size(); ++i) {
            String key = (String)this.orderedKeyList.get(i);
            String value = (String)this.key_value_store_.get(key);
            structure.add(STRING, key.length() + 1, "key_value_store_[" + i + "].key", null);
            structure.add(STRING, value.length() + 1, "key_value_store_[" + i + "].value", null);
        }
        for (i = 0; i < this.oatDexFileList.size(); ++i) {
            DataType dataType = ((OatDexFile)this.oatDexFileList.get(i)).toDataType();
            structure.add(dataType, dataType.getName(), null);
        }
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

